/***************************************************************************
 *   Copyright (C) 2005 by Krzysztof Zawadyl                               *
 *   k.zawadyl@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef POPUPMESSAGE_H
#define POPUPMESSAGE_H

#include "message.h"

#include <qwidget.h>
#include <qsimplerichtext.h>
#include <qpixmap.h>

#include <kprocess.h>

class Popup;

class QLabel;
class QTimer;
class QMouseEvent;
class QPushButton;

/**
@author Krzysztof Zawadyl
*/
class PopupMessage : public QWidget
{
Q_OBJECT
public:
	PopupMessage( Message *m, Popup *parent = 0, const char *name = 0);
    ~PopupMessage();

public slots:
	void 			startTimer();
	void			resetTimer();
	void			timerDone();
	void			setTimeout( int timeout );
	void			msgClick();
	void			runCommand();
	void			resetWidth( int w );
	
signals:
	void			anchorClicked();
	void			clicked();
	void			clicked(PopupMessage *);
	void			timeout();
	void			timeout(PopupMessage *);
	
protected:
	virtual void    mouseReleaseEvent( QMouseEvent * e );
	virtual void	mouseMoveEvent( QMouseEvent * e );
	QString 		getIconPath( const QString &name );
	void			paintEvent( QPaintEvent *e );
	QTimer *		hideTimer;
		
private:
	Message *		message;
	int				lifeTime;
	Popup *			p;
	QStringList		command;
	KProcess *		cmdProcess;
	QSimpleRichText * richText;
	QPixmap 		m_pixmap;
};

#endif
