/***************************************************************************
 *   Copyright (C) 2005 by Krzysztof Zawadyl							   *
 *   k.zawadyl@gmail.com												   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "popuptheme.h"

#include <qimage.h>
#include <qfile.h>

#include <kpixmapeffect.h>
#include <kstandarddirs.h>
#include <kconfig.h>

PopupTheme::PopupTheme(const QString& name) : themeName( name )
{
}


PopupTheme::~PopupTheme()
{
}


bool PopupTheme::load(QString themePath)
{
	if( themePath.isEmpty() )
		path = KGlobal::dirs()->findResource( "appdata", "themes/"+themeName+"/" );
	else
		path += themePath+themeName+"/";

	QFile f( path+"theme.ini" );
	if( !f.exists() )
		return false;
	
	KConfig cfg( path + "theme.ini", false );
	cfg.setGroup( "MetaMonitor Theme" );

	themeAuthor 		= cfg.readEntry( "ThemeAuthor", "" );
	themeVersion 		= cfg.readEntry( "ThemeVersion", "" );
	themeDescription 	= cfg.readEntry( "ThemeDescription", "" );
	
	previewPix.load( path + cfg.readEntry( "ThemePreview", "" ) );
	
	bottomCenterPix.load( path + cfg.readEntry( "BottomCenter", "" ) );
	bottomLeftPix.load( path + cfg.readEntry( "BottomLeft", "" ) );
	bottomRightPix.load( path + cfg.readEntry( "BottomRight", "" ) );
	centerCenterPix.load( path + cfg.readEntry( "CenterCenter", "" ) );
	centerLeftPix.load( path + cfg.readEntry( "CenterLeft", "" ) );
	centerRightPix.load( path + cfg.readEntry( "CenterRight", "" ) );
	topCenterPix.load( path + cfg.readEntry( "TopCenter", "" ) );
	topLeftPix.load( path + cfg.readEntry( "TopLeft", "" ) );
	topRightPix.load( path + cfg.readEntry( "TopRight", "" ) );

	bottomLeftMask.load( path + cfg.readEntry( "BottomLeftMask", "" ) );
	bottomRightMask.load( path + cfg.readEntry( "BottomRightMask", "" ) );
	topLeftMask.load( path + cfg.readEntry( "TopLeftMask", "" ) );
	topRightMask.load( path + cfg.readEntry( "TopRightMask", "" ) );
	leftMask.load( path + cfg.readEntry( "LeftMask", "" ) );
	rightMask.load( path + cfg.readEntry( "RightMask", "" ) );
	topMask.load( path + cfg.readEntry( "TopMask", "" ) );
	bottomMask.load( path + cfg.readEntry( "BottomMask", "" ) );
	
	leftMarginWidth = cfg.readNumEntry( "LeftMarginWidth", 0 );
	rightMarginWidth = cfg.readNumEntry( "RightMarginWidth", 0 );
	topMarginHeight = cfg.readNumEntry( "TopMarginHeight", 0 );
	bottomMarginHeight = cfg.readNumEntry( "BottomMarginHeight", 0 );

	marginWidth = cfg.readNumEntry( "MarginWidth", 0 );

	textColor 	= cfg.readEntry( "TextColor", "" );
	senderColor	= cfg.readEntry( "SenderColor", "" );
	body		= cfg.readEntry( "Body", "" );
	
	QString s;
	for( int i=1; ; i++ )
	{
		s.sprintf( "Additional Pixmap %d", i );
		if( !cfg.hasGroup( s ) )
			break;
		
		PopupPixmap *pp = new PopupPixmap();
		cfg.setGroup( s );
		pp->load( path + cfg.readEntry( "Path", "" ) );
		pp->xOffset = cfg.readNumEntry( "XOffset", 0 );
		pp->yOffset = cfg.readNumEntry( "YOffset", 0 );

		QString xAlign = cfg.readEntry( "XAlign", "" );
		if( xAlign == "Center" )
			pp->xAlign = PopupPixmap::xCenter;
		else
		if( xAlign == "Right" )
			pp->xAlign = PopupPixmap::xRight;
		else
			pp->xAlign = PopupPixmap::xLeft;

		QString yAlign = cfg.readEntry( "YAlign", "" );
		if( yAlign == "Center" )
			pp->yAlign = PopupPixmap::yCenter;
		else
		if( yAlign == "Bottom" )
			pp->yAlign = PopupPixmap::yBottom;
		else
			pp->yAlign = PopupPixmap::yTop;
		
		additionalPixmapsList.append( pp );
	}
	
	return true;
}

