/***************************************************************************
 *   Copyright (C) 2005 by Krzysztof Zawadyl							   *
 *   k.zawadyl@gmail.com												   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef POPUPTHEME_H
#define POPUPTHEME_H

#include "popuppixmap.h"

#include <qbitmap.h>
#include <qstring.h>

#include <kpixmap.h>
#include <qptrlist.h>

class PopupTheme
{
public:
	PopupTheme(const QString& name);
	~PopupTheme();

	bool 		load(QString path=0);

public:
	QString 	path;
	QString		themeName;
	QString 	themeAuthor;
	QString		themeVersion;
	QString		themeDescription;
	
	KPixmap		previewPix;
	
	KPixmap 	topLeftPix;
	KPixmap		topCenterPix;
	KPixmap		topRightPix;
	KPixmap		centerLeftPix;
	KPixmap		centerCenterPix;
	KPixmap		centerRightPix;
	KPixmap		bottomLeftPix;
	KPixmap		bottomCenterPix;
	KPixmap		bottomRightPix;

	QBitmap     topLeftMask;
	QBitmap     topRightMask;
	QBitmap     bottomLeftMask;
	QBitmap     bottomRightMask;
	QBitmap		leftMask;
	QBitmap		rightMask;
	QBitmap		bottomMask;
	QBitmap		topMask;
	
	int			topMarginHeight;
	int			bottomMarginHeight;
	int			leftMarginWidth;
	int			rightMarginWidth;
	
	int			marginWidth;

	QString		body;
	QString		senderColor;
	QString		textColor;
	
	QPtrList<PopupPixmap> additionalPixmapsList;
};

#endif
