#!/bin/sh

config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .sample`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

config etc/hosts.conf.sample
config etc/upsd.conf.sample
config etc/upsstats.html.sample
config etc/upsset.conf.sample
config etc/upsd.users.sample
config etc/upsmon.conf.sample
config etc/upsstats-single.html.sample
config etc/ups.conf.sample
config etc/upssched.conf.sample
( cd usr/lib ; rm -rf libupsclient.so.1 )
( cd usr/lib ; ln -sf libupsclient.so.1.0.0 libupsclient.so.1 )
( cd usr/lib ; rm -rf libupsclient.so )
( cd usr/lib ; ln -sf libupsclient.so.1.0.0 libupsclient.so )
