#!/bin/sh

config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/opensc.conf.new
( cd usr/lib ; rm -rf libscconf.so.2 )
( cd usr/lib ; ln -sf libscconf.so.2.0.0 libscconf.so.2 )
( cd usr/lib ; rm -rf libpkcs15init.so.2 )
( cd usr/lib ; ln -sf libpkcs15init.so.2.0.0 libpkcs15init.so.2 )
( cd usr/lib ; rm -rf libopensc.so )
( cd usr/lib ; ln -sf libopensc.so.2.0.0 libopensc.so )
( cd usr/lib ; rm -rf libpkcs15init.so )
( cd usr/lib ; ln -sf libpkcs15init.so.2.0.0 libpkcs15init.so )
( cd usr/lib ; rm -rf libscconf.so )
( cd usr/lib ; ln -sf libscconf.so.2.0.0 libscconf.so )
( cd usr/lib/pkcs11 ; rm -rf opensc-pkcs11.so )
( cd usr/lib/pkcs11 ; ln -sf ../opensc-pkcs11.so opensc-pkcs11.so )
( cd usr/lib/pkcs11 ; rm -rf onepin-opensc-pkcs11.so )
( cd usr/lib/pkcs11 ; ln -sf ../onepin-opensc-pkcs11.so onepin-opensc-pkcs11.so )
( cd usr/lib/pkcs11 ; rm -rf pkcs11-spy.so )
( cd usr/lib/pkcs11 ; ln -sf ../pkcs11-spy.so pkcs11-spy.so )
( cd usr/lib ; rm -rf libopensc.so.2 )
( cd usr/lib ; ln -sf libopensc.so.2.0.0 libopensc.so.2 )
