# This file was automatically generated by SWIG (http://www.swig.org).
# Version 1.3.35
#
# Don't modify this file, modify the SWIG interface instead.

"""
Python bindings for the OpenSync library
"""

import _opensync
import new
new_instancemethod = new.instancemethod
try:
    _swig_property = property
except NameError:
    pass # Python < 2.2 doesn't have 'property'.
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'PySwigObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static) or hasattr(self,name):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError,name

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

import types
try:
    _object = types.ObjectType
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0
del types


def _swig_setattr_nondynamic_method(set):
    def set_attr(self,name,value):
        if (name == "thisown"): return self.this.own(value)
        if hasattr(self,name) or (name == "this"):
            set(self,name,value)
        else:
            raise AttributeError("You cannot add attributes to %s" % self)
    return set_attr


class _ListWrapper:
	"""Utility class to wrap a common idiom in OpenSync as a Python list."""
	def __init__(self, lenf, getf):
		self.__lenf = lenf
		self.__getf = getf
	
	def __len__(self):
		return self.__lenf()
	
	def __getitem__(self, num):
		if not isinstance(num, int):
			raise TypeError
		if num < 0 or num >= len(self):
			raise IndexError
		return self.__getf(num)

class Error(Exception):
    """Proxy of C Error struct"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self, PyObject obj) -> Error
        __init__(self, char msg, ErrorType type=OSYNC_ERROR_GENERIC) -> Error
        """
        this = _opensync.new_Error(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _opensync.delete_Error
    __del__ = lambda self : None;
    def get_name(*args):
        """get_name(self) -> char"""
        return _opensync.Error_get_name(*args)

    def is_set(*args):
        """is_set(self) -> bool"""
        return _opensync.Error_is_set(*args)

    def get_type(*args):
        """get_type(self) -> ErrorType"""
        return _opensync.Error_get_type(*args)

    def set_type(*args):
        """set_type(self, ErrorType type)"""
        return _opensync.Error_set_type(*args)

    def get_msg(*args):
        """get_msg(self) -> char"""
        return _opensync.Error_get_msg(*args)

    def print_stack(*args):
        """print_stack(self) -> char"""
        return _opensync.Error_print_stack(*args)

    def set_from_error(*args):
        """set_from_error(self, Error source)"""
        return _opensync.Error_set_from_error(*args)

    def set(*args):
        """set(self, ErrorType type, char msg)"""
        return _opensync.Error_set(*args)

    def stack(*args):
        """stack(self, Error child)"""
        return _opensync.Error_stack(*args)

    def get_child(*args):
        """get_child(self) -> Error"""
        return _opensync.Error_get_child(*args)

    # for some reason the OpenSync API only allows setting the msg with a type
    def __set_msg(self, msg):
    	self.set(self.num, msg)

    def __str__(self):
    	return self.get_name() + ": " + self.get_msg()

    def report(self, context):
    	"""Report myself as an error to the given Context object."""
    	context.report_osyncerror(self)

    name = property(get_name)
    is_set = property(is_set)
    num = property(get_type, set_type) # 'type' is a reserved word
    msg = property(get_msg, __set_msg)

Error_swigregister = _opensync.Error_swigregister
Error_swigregister(Error)

NO_ERROR = _opensync.NO_ERROR
ERROR_GENERIC = _opensync.ERROR_GENERIC
ERROR_IO_ERROR = _opensync.ERROR_IO_ERROR
ERROR_NOT_SUPPORTED = _opensync.ERROR_NOT_SUPPORTED
ERROR_TIMEOUT = _opensync.ERROR_TIMEOUT
ERROR_DISCONNECTED = _opensync.ERROR_DISCONNECTED
ERROR_FILE_NOT_FOUND = _opensync.ERROR_FILE_NOT_FOUND
ERROR_EXISTS = _opensync.ERROR_EXISTS
ERROR_CONVERT = _opensync.ERROR_CONVERT
ERROR_MISCONFIGURATION = _opensync.ERROR_MISCONFIGURATION
ERROR_INITIALIZATION = _opensync.ERROR_INITIALIZATION
ERROR_PARAMETER = _opensync.ERROR_PARAMETER
ERROR_EXPECTED = _opensync.ERROR_EXPECTED
ERROR_NO_CONNECTION = _opensync.ERROR_NO_CONNECTION
ERROR_TEMPORARY = _opensync.ERROR_TEMPORARY
ERROR_LOCKED = _opensync.ERROR_LOCKED
ERROR_PLUGIN_NOT_FOUND = _opensync.ERROR_PLUGIN_NOT_FOUND
class Context(object):
    """Proxy of C Context struct"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self, PyObject obj) -> Context
        __init__(self) -> Context
        """
        this = _opensync.new_Context(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _opensync.delete_Context
    __del__ = lambda self : None;
    def report_error(*args):
        """report_error(self, ErrorType type, char msg)"""
        return _opensync.Context_report_error(*args)

    def report_success(*args):
        """report_success(self)"""
        return _opensync.Context_report_success(*args)

    def report_osyncerror(*args):
        """report_osyncerror(self, Error error)"""
        return _opensync.Context_report_osyncerror(*args)

    def report_osyncwarning(*args):
        """report_osyncwarning(self, Error error)"""
        return _opensync.Context_report_osyncwarning(*args)

    def report_change(*args):
        """report_change(self, Change change)"""
        return _opensync.Context_report_change(*args)

    def set_callback_object(*args):
        """set_callback_object(self, PyObject handler)"""
        return _opensync.Context_set_callback_object(*args)

Context_swigregister = _opensync.Context_swigregister
Context_swigregister(Context)

class ContextCallbacks:
	"""A purely-Python class that should be subclassed by code that wishes to handle context callbacks."""
	def callback(self, err):
		"""If err is set, this call indicates that an error was reported. Otherwise success."""
		pass

	def changes(self, change):
		"""Called to report a change object."""
		pass

	def warning(self, err):
		"""Called to report a non-fatal error."""
		pass

CONV_DATA_UNKNOWN = _opensync.CONV_DATA_UNKNOWN
CONV_DATA_MISMATCH = _opensync.CONV_DATA_MISMATCH
CONV_DATA_SIMILAR = _opensync.CONV_DATA_SIMILAR
CONV_DATA_SAME = _opensync.CONV_DATA_SAME
class Data(object):
    """Proxy of C Data struct"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, char buf, ObjFormat format) -> Data"""
        this = _opensync.new_Data(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _opensync.delete_Data
    __del__ = lambda self : None;
    def get_objformat(*args):
        """get_objformat(self) -> ObjFormat"""
        return _opensync.Data_get_objformat(*args)

    def set_objformat(*args):
        """set_objformat(self, ObjFormat objformat)"""
        return _opensync.Data_set_objformat(*args)

    def get_objtype(*args):
        """get_objtype(self) -> char"""
        return _opensync.Data_get_objtype(*args)

    def set_objtype(*args):
        """set_objtype(self, char objtype)"""
        return _opensync.Data_set_objtype(*args)

    def get_data(*args):
        """get_data(self, char buffer)"""
        return _opensync.Data_get_data(*args)

    def steal_data(*args):
        """steal_data(self, char buffer)"""
        return _opensync.Data_steal_data(*args)

    def set_data(*args):
        """set_data(self, char buffer, unsigned int size)"""
        return _opensync.Data_set_data(*args)

    def has_data(*args):
        """has_data(self) -> bool"""
        return _opensync.Data_has_data(*args)

    def clone(*args):
        """clone(self) -> Data"""
        return _opensync.Data_clone(*args)

    def compare(*args):
        """compare(self, Data data) -> ConvCmpResult"""
        return _opensync.Data_compare(*args)

    def get_printable(*args):
        """get_printable(self) -> char"""
        return _opensync.Data_get_printable(*args)

    def get_revision(*args):
        """get_revision(self) -> time_t"""
        return _opensync.Data_get_revision(*args)

    objformat = property(get_objformat, set_objformat)
    objtype = property(get_objtype, set_objtype)
    data = property(get_data, set_data)
    revision = property(get_revision)

Data_swigregister = _opensync.Data_swigregister
Data_swigregister(Data)

CHANGE_TYPE_UNKNOWN = _opensync.CHANGE_TYPE_UNKNOWN
CHANGE_TYPE_ADDED = _opensync.CHANGE_TYPE_ADDED
CHANGE_TYPE_UNMODIFIED = _opensync.CHANGE_TYPE_UNMODIFIED
CHANGE_TYPE_DELETED = _opensync.CHANGE_TYPE_DELETED
CHANGE_TYPE_MODIFIED = _opensync.CHANGE_TYPE_MODIFIED
class Change(object):
    """Proxy of C Change struct"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self, PyObject obj) -> Change
        __init__(self) -> Change
        """
        this = _opensync.new_Change(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _opensync.delete_Change
    __del__ = lambda self : None;
    def set_hash(*args):
        """set_hash(self, char hash)"""
        return _opensync.Change_set_hash(*args)

    def get_hash(*args):
        """get_hash(self) -> char"""
        return _opensync.Change_get_hash(*args)

    def set_uid(*args):
        """set_uid(self, char uid)"""
        return _opensync.Change_set_uid(*args)

    def get_uid(*args):
        """get_uid(self) -> char"""
        return _opensync.Change_get_uid(*args)

    def set_changetype(*args):
        """set_changetype(self, ChangeType changetype)"""
        return _opensync.Change_set_changetype(*args)

    def get_changetype(*args):
        """get_changetype(self) -> ChangeType"""
        return _opensync.Change_get_changetype(*args)

    def set_data(*args):
        """set_data(self, Data data)"""
        return _opensync.Change_set_data(*args)

    def get_data(*args):
        """get_data(self) -> Data"""
        return _opensync.Change_get_data(*args)

    def compare(*args):
        """compare(self, Change change) -> ConvCmpResult"""
        return _opensync.Change_compare(*args)

    def duplicate(*args):
        """duplicate(self) -> bool"""
        return _opensync.Change_duplicate(*args)

    def get_objformat(*args):
        """get_objformat(self) -> ObjFormat"""
        return _opensync.Change_get_objformat(*args)

    def set_objtype(*args):
        """set_objtype(self, char objtype)"""
        return _opensync.Change_set_objtype(*args)

    def get_objtype(*args):
        """get_objtype(self) -> char"""
        return _opensync.Change_get_objtype(*args)

    hash = property(get_hash, set_hash)
    uid = property(get_uid, set_uid)
    changetype = property(get_changetype, set_changetype)
    data = property(get_data, set_data)
    objformat = property(get_objformat)
    objtype = property(get_objtype, set_objtype)

Change_swigregister = _opensync.Change_swigregister
Change_swigregister(Change)

ENGINE_COMMAND_CONNECT = _opensync.ENGINE_COMMAND_CONNECT
ENGINE_COMMAND_READ = _opensync.ENGINE_COMMAND_READ
ENGINE_COMMAND_WRITE = _opensync.ENGINE_COMMAND_WRITE
ENGINE_COMMAND_SYNC_DONE = _opensync.ENGINE_COMMAND_SYNC_DONE
ENGINE_COMMAND_DISCONNECT = _opensync.ENGINE_COMMAND_DISCONNECT
ENGINE_COMMAND_SOLVE = _opensync.ENGINE_COMMAND_SOLVE
ENGINE_COMMAND_DISCOVER = _opensync.ENGINE_COMMAND_DISCOVER
ENGINE_STATE_UNINITIALIZED = _opensync.ENGINE_STATE_UNINITIALIZED
ENGINE_STATE_INITIALIZED = _opensync.ENGINE_STATE_INITIALIZED
ENGINE_STATE_WAITING = _opensync.ENGINE_STATE_WAITING
ENGINE_STATE_CONNECTING = _opensync.ENGINE_STATE_CONNECTING
ENGINE_STATE_READING = _opensync.ENGINE_STATE_READING
ENGINE_STATE_WRITING = _opensync.ENGINE_STATE_WRITING
ENGINE_STATE_DISCONNECTING = _opensync.ENGINE_STATE_DISCONNECTING
ENGINE_EVENT_CONNECTED = _opensync.ENGINE_EVENT_CONNECTED
ENGINE_EVENT_ERROR = _opensync.ENGINE_EVENT_ERROR
ENGINE_EVENT_READ = _opensync.ENGINE_EVENT_READ
ENGINE_EVENT_WRITTEN = _opensync.ENGINE_EVENT_WRITTEN
ENGINE_EVENT_SYNC_DONE = _opensync.ENGINE_EVENT_SYNC_DONE
ENGINE_EVENT_DISCONNECTED = _opensync.ENGINE_EVENT_DISCONNECTED
ENGINE_EVENT_SUCCESSFUL = _opensync.ENGINE_EVENT_SUCCESSFUL
ENGINE_EVENT_END_CONFLICTS = _opensync.ENGINE_EVENT_END_CONFLICTS
ENGINE_EVENT_PREV_UNCLEAN = _opensync.ENGINE_EVENT_PREV_UNCLEAN
CLIENT_EVENT_CONNECTED = _opensync.CLIENT_EVENT_CONNECTED
CLIENT_EVENT_ERROR = _opensync.CLIENT_EVENT_ERROR
CLIENT_EVENT_READ = _opensync.CLIENT_EVENT_READ
CLIENT_EVENT_WRITTEN = _opensync.CLIENT_EVENT_WRITTEN
CLIENT_EVENT_SYNC_DONE = _opensync.CLIENT_EVENT_SYNC_DONE
CLIENT_EVENT_DISCONNECTED = _opensync.CLIENT_EVENT_DISCONNECTED
CLIENT_EVENT_DISCOVERED = _opensync.CLIENT_EVENT_DISCOVERED
CHANGE_EVENT_READ = _opensync.CHANGE_EVENT_READ
CHANGE_EVENT_WRITTEN = _opensync.CHANGE_EVENT_WRITTEN
CHANGE_EVENT_ERROR = _opensync.CHANGE_EVENT_ERROR
MAPPING_EVENT_SOLVED = _opensync.MAPPING_EVENT_SOLVED
MAPPING_EVENT_ERROR = _opensync.MAPPING_EVENT_ERROR
class Engine(object):
    """Proxy of C Engine struct"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, Group group) -> Engine"""
        this = _opensync.new_Engine(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _opensync.delete_Engine
    __del__ = lambda self : None;
    def set_plugindir(*args):
        """set_plugindir(self, char dir)"""
        return _opensync.Engine_set_plugindir(*args)

    def set_formatdir(*args):
        """set_formatdir(self, char dir)"""
        return _opensync.Engine_set_formatdir(*args)

    def get_group(*args):
        """get_group(self) -> Group"""
        return _opensync.Engine_get_group(*args)

    def initialize(*args):
        """initialize(self)"""
        return _opensync.Engine_initialize(*args)

    def finalize(*args):
        """finalize(self)"""
        return _opensync.Engine_finalize(*args)

    def synchronize(*args):
        """synchronize(self)"""
        return _opensync.Engine_synchronize(*args)

    def synchronize_and_block(*args):
        """synchronize_and_block(self)"""
        return _opensync.Engine_synchronize_and_block(*args)

    def wait_sync_end(*args):
        """wait_sync_end(self)"""
        return _opensync.Engine_wait_sync_end(*args)

    def discover(*args):
        """discover(self, Member member)"""
        return _opensync.Engine_discover(*args)

    def discover_and_block(*args):
        """discover_and_block(self, Member member)"""
        return _opensync.Engine_discover_and_block(*args)

    def set_enginestatus_callback(*args):
        """set_enginestatus_callback(self, PyObject pyfunc)"""
        return _opensync.Engine_set_enginestatus_callback(*args)

    def event(*args):
        """event(self, EngineEvent ev)"""
        return _opensync.Engine_event(*args)

    def check_get_changes(*args):
        """check_get_changes(self) -> bool"""
        return _opensync.Engine_check_get_changes(*args)

    def num_proxies(*args):
        """num_proxies(self) -> int"""
        return _opensync.Engine_num_proxies(*args)

    def num_objengine(*args):
        """num_objengine(self) -> int"""
        return _opensync.Engine_num_objengine(*args)

    group = property(get_group)
    # archive = property(get_archive)

Engine_swigregister = _opensync.Engine_swigregister
Engine_swigregister(Engine)

CONVERTER_CONV = _opensync.CONVERTER_CONV
CONVERTER_ENCAP = _opensync.CONVERTER_ENCAP
CONVERTER_DECAP = _opensync.CONVERTER_DECAP
CONVERTER_DETECTOR = _opensync.CONVERTER_DETECTOR
class FormatConverter(object):
    """Proxy of C FormatConverter struct"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self) -> FormatConverter"""
        this = _opensync.new_FormatConverter(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _opensync.delete_FormatConverter
    __del__ = lambda self : None;
    def get_sourceformat(*args):
        """get_sourceformat(self) -> ObjFormat"""
        return _opensync.FormatConverter_get_sourceformat(*args)

    def get_targetformat(*args):
        """get_targetformat(self) -> ObjFormat"""
        return _opensync.FormatConverter_get_targetformat(*args)

    def get_type(*args):
        """get_type(self) -> OSyncConverterType"""
        return _opensync.FormatConverter_get_type(*args)

    def detect(*args):
        """detect(self, Data data) -> ObjFormat"""
        return _opensync.FormatConverter_detect(*args)

    def invoke(*args):
        """invoke(self, Data data, char config)"""
        return _opensync.FormatConverter_invoke(*args)

    def matches(*args):
        """matches(self, Data data) -> bool"""
        return _opensync.FormatConverter_matches(*args)

    sourceformat = property(get_sourceformat)
    targetformat = property(get_targetformat)
    type = property(get_type)

FormatConverter_swigregister = _opensync.FormatConverter_swigregister
FormatConverter_swigregister(FormatConverter)

class FormatConverterPath(object):
    """Proxy of C FormatConverterPath struct"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self) -> FormatConverterPath"""
        this = _opensync.new_FormatConverterPath(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _opensync.delete_FormatConverterPath
    __del__ = lambda self : None;
    def add_edge(*args):
        """add_edge(self, FormatConverter edge)"""
        return _opensync.FormatConverterPath_add_edge(*args)

    def num_edges(*args):
        """num_edges(self) -> int"""
        return _opensync.FormatConverterPath_num_edges(*args)

    def nth_edge(*args):
        """nth_edge(self, unsigned int nth) -> FormatConverter"""
        return _opensync.FormatConverterPath_nth_edge(*args)

    def get_config(*args):
        """get_config(self) -> char"""
        return _opensync.FormatConverterPath_get_config(*args)

    def set_config(*args):
        """set_config(self, char config)"""
        return _opensync.FormatConverterPath_set_config(*args)

    config = property(get_config, set_config)

    # extend the SWIG-generated constructor, so that we can setup our list-wrapper classes
    __oldinit = __init__
    def __init__(self, *args):
    	self.__oldinit(*args)
    	self.edges = _ListWrapper(self.num_edges, self.nth_edge)

FormatConverterPath_swigregister = _opensync.FormatConverterPath_swigregister
FormatConverterPath_swigregister(FormatConverterPath)

FILTER_IGNORE = _opensync.FILTER_IGNORE
FILTER_ALLOW = _opensync.FILTER_ALLOW
FILTER_DENY = _opensync.FILTER_DENY
class Filter(object):
    """Proxy of C Filter struct"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, char objtype, FilterAction action) -> Filter"""
        this = _opensync.new_Filter(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _opensync.delete_Filter
    __del__ = lambda self : None;
    def set_config(*args):
        """set_config(self, char config)"""
        return _opensync.Filter_set_config(*args)

    def get_config(*args):
        """get_config(self) -> char"""
        return _opensync.Filter_get_config(*args)

    def invoke(*args):
        """invoke(self, Data data) -> FilterAction"""
        return _opensync.Filter_invoke(*args)

    def get_objtype(*args):
        """get_objtype(self) -> char"""
        return _opensync.Filter_get_objtype(*args)

    config = property(get_config, set_config)
    objtype = property(get_objtype)

Filter_swigregister = _opensync.Filter_swigregister
Filter_swigregister(Filter)

class FormatEnv(object):
    """Proxy of C FormatEnv struct"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self) -> FormatEnv"""
        this = _opensync.new_FormatEnv(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _opensync.delete_FormatEnv
    __del__ = lambda self : None;
    def load_plugins(*args):
        """load_plugins(self, char path=None)"""
        return _opensync.FormatEnv_load_plugins(*args)

    def register_objformat(*args):
        """register_objformat(self, ObjFormat format)"""
        return _opensync.FormatEnv_register_objformat(*args)

    def find_objformat(*args):
        """find_objformat(self, char name) -> ObjFormat"""
        return _opensync.FormatEnv_find_objformat(*args)

    def num_objformats(*args):
        """num_objformats(self) -> int"""
        return _opensync.FormatEnv_num_objformats(*args)

    def nth_objformat(*args):
        """nth_objformat(self, int nth) -> ObjFormat"""
        return _opensync.FormatEnv_nth_objformat(*args)

    def register_converter(*args):
        """register_converter(self, FormatConverter converter)"""
        return _opensync.FormatEnv_register_converter(*args)

    def find_converter(*args):
        """find_converter(self, ObjFormat sourceformat, ObjFormat targetformat) -> FormatConverter"""
        return _opensync.FormatEnv_find_converter(*args)

    def num_converters(*args):
        """num_converters(self) -> int"""
        return _opensync.FormatEnv_num_converters(*args)

    def nth_converter(*args):
        """nth_converter(self, int nth) -> FormatConverter"""
        return _opensync.FormatEnv_nth_converter(*args)

    def register_filter(*args):
        """register_filter(self, CustomFilter filter)"""
        return _opensync.FormatEnv_register_filter(*args)

    def num_filters(*args):
        """num_filters(self) -> int"""
        return _opensync.FormatEnv_num_filters(*args)

    def nth_filter(*args):
        """nth_filter(self, int nth) -> CustomFilter"""
        return _opensync.FormatEnv_nth_filter(*args)

    def detect_objformat(*args):
        """detect_objformat(self, Data data) -> ObjFormat"""
        return _opensync.FormatEnv_detect_objformat(*args)

    def detect_objformat_full(*args):
        """detect_objformat_full(self, Data input) -> ObjFormat"""
        return _opensync.FormatEnv_detect_objformat_full(*args)

    def convert(*args):
        """convert(self, FormatConverterPath path, Data data)"""
        return _opensync.FormatEnv_convert(*args)

    def find_path(*args):
        """find_path(self, ObjFormat sourceformat, ObjFormat targetformat) -> FormatConverterPath"""
        return _opensync.FormatEnv_find_path(*args)

    def find_path_formats(*args):
        """find_path_formats(self, ObjFormat sourceformat, PyObject targets) -> FormatConverterPath"""
        return _opensync.FormatEnv_find_path_formats(*args)

    # extend the SWIG-generated constructor, so that we can setup our list-wrapper classes
    __oldinit = __init__
    def __init__(self, *args):
    	self.__oldinit(*args)
    	self.objformats = _ListWrapper(self.num_objformats, self.nth_objformat)
    	self.converters = _ListWrapper(self.num_converters, self.nth_converter)
    	self.filters = _ListWrapper(self.num_filters, self.nth_filter)

FormatEnv_swigregister = _opensync.FormatEnv_swigregister
FormatEnv_swigregister(FormatEnv)

class ObjFormat(object):
    """Proxy of C ObjFormat struct"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, char name, char objtype_name) -> ObjFormat"""
        this = _opensync.new_ObjFormat(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _opensync.delete_ObjFormat
    __del__ = lambda self : None;
    def get_name(*args):
        """get_name(self) -> char"""
        return _opensync.ObjFormat_get_name(*args)

    def get_objtype(*args):
        """get_objtype(self) -> char"""
        return _opensync.ObjFormat_get_objtype(*args)

    def is_equal(*args):
        """is_equal(self, ObjFormat rightformat) -> bool"""
        return _opensync.ObjFormat_is_equal(*args)

    def must_marshal(*args):
        """must_marshal(self) -> bool"""
        return _opensync.ObjFormat_must_marshal(*args)

    name = property(get_name)
    objtype = property(get_objtype)
    must_marshal = property(must_marshal)

ObjFormat_swigregister = _opensync.ObjFormat_swigregister
ObjFormat_swigregister(ObjFormat)

class GroupEnv(object):
    """Proxy of C GroupEnv struct"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self) -> GroupEnv"""
        this = _opensync.new_GroupEnv(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _opensync.delete_GroupEnv
    __del__ = lambda self : None;
    def load_groups(*args):
        """load_groups(self, char path=None)"""
        return _opensync.GroupEnv_load_groups(*args)

    def find_group(*args):
        """find_group(self, char name) -> Group"""
        return _opensync.GroupEnv_find_group(*args)

    def add_group(*args):
        """add_group(self, Group group)"""
        return _opensync.GroupEnv_add_group(*args)

    def remove_group(*args):
        """remove_group(self, Group group)"""
        return _opensync.GroupEnv_remove_group(*args)

    def num_groups(*args):
        """num_groups(self) -> int"""
        return _opensync.GroupEnv_num_groups(*args)

    def nth_group(*args):
        """nth_group(self, int nth) -> Group"""
        return _opensync.GroupEnv_nth_group(*args)

    # extend the SWIG-generated constructor, so that we can setup our list-wrapper classes
    __oldinit = __init__
    def __init__(self, *args):
    	self.__oldinit(*args)
    	self.groups = _ListWrapper(self.num_groups, self.nth_group)

GroupEnv_swigregister = _opensync.GroupEnv_swigregister
GroupEnv_swigregister(GroupEnv)

LOCK_OK = _opensync.LOCK_OK
LOCKED = _opensync.LOCKED
LOCK_STALE = _opensync.LOCK_STALE
CONFLICT_RESOLUTION_UNKNOWN = _opensync.CONFLICT_RESOLUTION_UNKNOWN
CONFLICT_RESOLUTION_DUPLICATE = _opensync.CONFLICT_RESOLUTION_DUPLICATE
CONFLICT_RESOLUTION_IGNORE = _opensync.CONFLICT_RESOLUTION_IGNORE
CONFLICT_RESOLUTION_NEWER = _opensync.CONFLICT_RESOLUTION_NEWER
CONFLICT_RESOLUTION_SELECT = _opensync.CONFLICT_RESOLUTION_SELECT
class Group(object):
    """Proxy of C Group struct"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self) -> Group"""
        this = _opensync.new_Group(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _opensync.delete_Group
    __del__ = lambda self : None;
    def lock(*args):
        """lock(self) -> LockState"""
        return _opensync.Group_lock(*args)

    def unlock(*args):
        """unlock(self)"""
        return _opensync.Group_unlock(*args)

    def set_name(*args):
        """set_name(self, char name)"""
        return _opensync.Group_set_name(*args)

    def get_name(*args):
        """get_name(self) -> char"""
        return _opensync.Group_get_name(*args)

    def save(*args):
        """save(self)"""
        return _opensync.Group_save(*args)

    def delete(*args):
        """delete(self)"""
        return _opensync.Group_delete(*args)

    def reset(*args):
        """reset(self)"""
        return _opensync.Group_reset(*args)

    def load(*args):
        """load(self, char path)"""
        return _opensync.Group_load(*args)

    def add_member(*args):
        """add_member(self, Member member)"""
        return _opensync.Group_add_member(*args)

    def remove_member(*args):
        """remove_member(self, Member member)"""
        return _opensync.Group_remove_member(*args)

    def find_member(*args):
        """find_member(self, int id) -> Member"""
        return _opensync.Group_find_member(*args)

    def nth_member(*args):
        """nth_member(self, int nth) -> Member"""
        return _opensync.Group_nth_member(*args)

    def num_members(*args):
        """num_members(self) -> int"""
        return _opensync.Group_num_members(*args)

    def get_configdir(*args):
        """get_configdir(self) -> char"""
        return _opensync.Group_get_configdir(*args)

    def set_configdir(*args):
        """set_configdir(self, char directory)"""
        return _opensync.Group_set_configdir(*args)

    def num_objtypes(*args):
        """num_objtypes(self) -> int"""
        return _opensync.Group_num_objtypes(*args)

    def nth_objtype(*args):
        """nth_objtype(self, int nth) -> char"""
        return _opensync.Group_nth_objtype(*args)

    def set_objtype_enabled(*args):
        """set_objtype_enabled(self, char objtype, bool enabled)"""
        return _opensync.Group_set_objtype_enabled(*args)

    def objtype_enabled(*args):
        """objtype_enabled(self, char objtype) -> int"""
        return _opensync.Group_objtype_enabled(*args)

    def add_filter(*args):
        """add_filter(self, Filter filter)"""
        return _opensync.Group_add_filter(*args)

    def remove_filter(*args):
        """remove_filter(self, Filter filter)"""
        return _opensync.Group_remove_filter(*args)

    def num_filters(*args):
        """num_filters(self) -> int"""
        return _opensync.Group_num_filters(*args)

    def nth_filter(*args):
        """nth_filter(self, int nth) -> Filter"""
        return _opensync.Group_nth_filter(*args)

    def set_last_synchronization(*args):
        """set_last_synchronization(self, time_t last_sync)"""
        return _opensync.Group_set_last_synchronization(*args)

    def get_last_synchronization(*args):
        """get_last_synchronization(self) -> time_t"""
        return _opensync.Group_get_last_synchronization(*args)

    def set_conflict_resolution(*args):
        """set_conflict_resolution(self, ConflictResolution res, int num)"""
        return _opensync.Group_set_conflict_resolution(*args)

    def get_conflict_resolution(*args):
        """get_conflict_resolution(self, ConflictResolution res, int num)"""
        return _opensync.Group_get_conflict_resolution(*args)

    def get_merger_enabled(*args):
        """get_merger_enabled(self) -> bool"""
        return _opensync.Group_get_merger_enabled(*args)

    def set_merger_enabled(*args):
        """set_merger_enabled(self, bool enable_merger)"""
        return _opensync.Group_set_merger_enabled(*args)

    def get_converter_enabled(*args):
        """get_converter_enabled(self) -> bool"""
        return _opensync.Group_get_converter_enabled(*args)

    def set_converter_enabled(*args):
        """set_converter_enabled(self, bool enable_converter)"""
        return _opensync.Group_set_converter_enabled(*args)

    name = property(get_name, set_name)
    configdir = property(get_configdir, set_configdir)
    last_synchronization = property(get_last_synchronization, set_last_synchronization)
    merger_enabled = property(get_merger_enabled, set_merger_enabled)
    converter_enabled = property(get_converter_enabled, set_converter_enabled)

    # extend the SWIG-generated constructor, so that we can setup our list-wrapper classes
    __oldinit = __init__
    def __init__(self, *args):
    	self.__oldinit(*args)
    	self.members = _ListWrapper(self.num_members, self.nth_member)
    	self.objtypes = _ListWrapper(self.num_objtypes, self.nth_objtype)
    	self.filters = _ListWrapper(self.num_filters, self.nth_filter)

Group_swigregister = _opensync.Group_swigregister
Group_swigregister(Group)

START_TYPE_UNKNOWN = _opensync.START_TYPE_UNKNOWN
START_TYPE_PROCESS = _opensync.START_TYPE_PROCESS
START_TYPE_THREAD = _opensync.START_TYPE_THREAD
START_TYPE_EXTERNAL = _opensync.START_TYPE_EXTERNAL
class Member(object):
    """Proxy of C Member struct"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self) -> Member"""
        this = _opensync.new_Member(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _opensync.delete_Member
    __del__ = lambda self : None;
    def get_pluginname(*args):
        """get_pluginname(self) -> char"""
        return _opensync.Member_get_pluginname(*args)

    def set_pluginname(*args):
        """set_pluginname(self, char pluginname)"""
        return _opensync.Member_set_pluginname(*args)

    def get_name(*args):
        """get_name(self) -> char"""
        return _opensync.Member_get_name(*args)

    def set_name(*args):
        """set_name(self, char name)"""
        return _opensync.Member_set_name(*args)

    def get_configdir(*args):
        """get_configdir(self) -> char"""
        return _opensync.Member_get_configdir(*args)

    def set_configdir(*args):
        """set_configdir(self, char configdir)"""
        return _opensync.Member_set_configdir(*args)

    def get_config_or_default(*args):
        """get_config_or_default(self) -> char"""
        return _opensync.Member_get_config_or_default(*args)

    def has_config(*args):
        """has_config(self) -> bool"""
        return _opensync.Member_has_config(*args)

    def get_config(*args):
        """get_config(self) -> char"""
        return _opensync.Member_get_config(*args)

    def set_config(*args):
        """set_config(self, char data)"""
        return _opensync.Member_set_config(*args)

    def load(*args):
        """load(self, char path)"""
        return _opensync.Member_load(*args)

    def save(*args):
        """save(self)"""
        return _opensync.Member_save(*args)

    def delete(*args):
        """delete(self)"""
        return _opensync.Member_delete(*args)

    def get_id(*args):
        """get_id(self) -> long long"""
        return _opensync.Member_get_id(*args)

    def add_objformat(*args):
        """add_objformat(self, char objtype, char format)"""
        return _opensync.Member_add_objformat(*args)

    def get_objformats(*args):
        """get_objformats(self, char objtype) -> PyObject"""
        return _opensync.Member_get_objformats(*args)

    def add_objtype_sink(*args):
        """add_objtype_sink(self, ObjTypeSink sink)"""
        return _opensync.Member_add_objtype_sink(*args)

    def num_objtypes(*args):
        """num_objtypes(self) -> int"""
        return _opensync.Member_num_objtypes(*args)

    def nth_objtype(*args):
        """nth_objtype(self, int nth) -> char"""
        return _opensync.Member_nth_objtype(*args)

    def objtype_enabled(*args):
        """objtype_enabled(self, char objtype) -> bool"""
        return _opensync.Member_objtype_enabled(*args)

    def set_objtype_enabled(*args):
        """set_objtype_enabled(self, char objtype, bool enabled)"""
        return _opensync.Member_set_objtype_enabled(*args)

    def get_capabilities(*args):
        """get_capabilities(self) -> Capabilities"""
        return _opensync.Member_get_capabilities(*args)

    def set_capabilities(*args):
        """set_capabilities(self, Capabilities capabilities)"""
        return _opensync.Member_set_capabilities(*args)

    def get_merger(*args):
        """get_merger(self) -> Merger"""
        return _opensync.Member_get_merger(*args)

    def flush_objtypes(*args):
        """flush_objtypes(self)"""
        return _opensync.Member_flush_objtypes(*args)

    pluginname = property(get_pluginname, set_pluginname)
    name = property(get_name, set_name)
    configdir = property(get_configdir, set_configdir)
    config = property(get_config, set_config)
    id = property(get_id)
    capabilities = property(get_capabilities, set_capabilities)
    merger = property(get_merger)

    # extend the SWIG-generated constructor, so that we can setup our list-wrapper classes
    __oldinit = __init__
    def __init__(self, *args):
    	self.__oldinit(*args)
    	self.objtypes = _ListWrapper(self.num_objtypes, self.nth_objtype)

Member_swigregister = _opensync.Member_swigregister
Member_swigregister(Member)


def anchor_compare(*args):
  """anchor_compare(char anchordb, char key, char new_anchor) -> bool"""
  return _opensync.anchor_compare(*args)

def anchor_update(*args):
  """anchor_update(char anchordb, char key, char new_anchor)"""
  return _opensync.anchor_update(*args)

def anchor_retrieve(*args):
  """anchor_retrieve(char anchordb, char key) -> char"""
  return _opensync.anchor_retrieve(*args)
class HashTable(object):
    """Proxy of C HashTable struct"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, char path, char objtype) -> HashTable"""
        this = _opensync.new_HashTable(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _opensync.delete_HashTable
    __del__ = lambda self : None;
    def reset(*args):
        """reset(self)"""
        return _opensync.HashTable_reset(*args)

    def num_entries(*args):
        """num_entries(self) -> int"""
        return _opensync.HashTable_num_entries(*args)

    def nth_entry(*args):
        """nth_entry(self, int nth) -> PyObject"""
        return _opensync.HashTable_nth_entry(*args)

    def write(*args):
        """write(self, char uid, char hash)"""
        return _opensync.HashTable_write(*args)

    def delete(*args):
        """delete(self, char uid)"""
        return _opensync.HashTable_delete(*args)

    def update_hash(*args):
        """update_hash(self, ChangeType type, char uid, char hash)"""
        return _opensync.HashTable_update_hash(*args)

    def report(*args):
        """report(self, char uid)"""
        return _opensync.HashTable_report(*args)

    def get_deleted(*args):
        """get_deleted(self) -> PyObject"""
        return _opensync.HashTable_get_deleted(*args)

    def get_changetype(*args):
        """get_changetype(self, char uid, char hash) -> ChangeType"""
        return _opensync.HashTable_get_changetype(*args)

    # extend the SWIG-generated constructor, so that we can setup our list-wrapper classes
    __oldinit = __init__
    def __init__(self, *args):
    	self.__oldinit(*args)
    	self.entries = _ListWrapper(self.num_entries, self.nth_entry)

HashTable_swigregister = _opensync.HashTable_swigregister
HashTable_swigregister(HashTable)

class Capability(object):
    """Proxy of C Capability struct"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, Capabilities capabilities, char objtype, char name) -> Capability"""
        this = _opensync.new_Capability(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _opensync.delete_Capability
    __del__ = lambda self : None;
    def get_name(*args):
        """get_name(self) -> char"""
        return _opensync.Capability_get_name(*args)

    def get_next(*args):
        """get_next(self) -> Capability"""
        return _opensync.Capability_get_next(*args)

    def has_key(*args):
        """has_key(self) -> bool"""
        return _opensync.Capability_has_key(*args)

    def get_key_count(*args):
        """get_key_count(self) -> int"""
        return _opensync.Capability_get_key_count(*args)

    def get_nth_key(*args):
        """get_nth_key(self, int nth) -> char"""
        return _opensync.Capability_get_nth_key(*args)

    def add_key(*args):
        """add_key(self, char name)"""
        return _opensync.Capability_add_key(*args)

    name = property(get_name)

    # extend the SWIG-generated constructor, so that we can setup our list-wrapper classes
    __oldinit = __init__
    def __init__(self, *args):
    	self.__oldinit(*args)
    	self.keys = _ListWrapper(self.get_key_count, self.get_nth_key)

Capability_swigregister = _opensync.Capability_swigregister
Capability_swigregister(Capability)

class Capabilities(object):
    """Proxy of C Capabilities struct"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self) -> Capabilities"""
        this = _opensync.new_Capabilities(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _opensync.delete_Capabilities
    __del__ = lambda self : None;
    def get_first(*args):
        """get_first(self, char objtype) -> Capability"""
        return _opensync.Capabilities_get_first(*args)

    def assemble(*args):
        """assemble(self) -> PyObject"""
        return _opensync.Capabilities_assemble(*args)

    def sort(*args):
        """sort(self)"""
        return _opensync.Capabilities_sort(*args)

Capabilities_swigregister = _opensync.Capabilities_swigregister
Capabilities_swigregister(Capabilities)


def capabilities_parse(*args):
  """capabilities_parse(char buffer) -> Capabilities"""
  return _opensync.capabilities_parse(*args)

def capabilities_load(*args):
  """capabilities_load(char file) -> Capabilities"""
  return _opensync.capabilities_load(*args)

def capabilities_member_get_capabilities(*args):
  """capabilities_member_get_capabilities(Member member) -> Capabilities"""
  return _opensync.capabilities_member_get_capabilities(*args)

def capabilities_member_set_capabilities(*args):
  """capabilities_member_set_capabilities(Member member, Capabilities caps)"""
  return _opensync.capabilities_member_set_capabilities(*args)
class XMLFormat(object):
    """Proxy of C XMLFormat struct"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, char objtype) -> XMLFormat"""
        this = _opensync.new_XMLFormat(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _opensync.delete_XMLFormat
    __del__ = lambda self : None;
    def get_objtype(*args):
        """get_objtype(self) -> char"""
        return _opensync.XMLFormat_get_objtype(*args)

    def get_first_field(*args):
        """get_first_field(self) -> XMLField"""
        return _opensync.XMLFormat_get_first_field(*args)

    def search_field(*args):
        """search_field(self, char name) -> PyObject"""
        return _opensync.XMLFormat_search_field(*args)

    def assemble(*args):
        """assemble(self) -> PyObject"""
        return _opensync.XMLFormat_assemble(*args)

    def validate(*args):
        """validate(self) -> bool"""
        return _opensync.XMLFormat_validate(*args)

    def sort(*args):
        """sort(self)"""
        return _opensync.XMLFormat_sort(*args)

    objtype = property(get_objtype)

XMLFormat_swigregister = _opensync.XMLFormat_swigregister
XMLFormat_swigregister(XMLFormat)


def xmlformat_parse(*args):
  """xmlformat_parse(char buffer) -> XMLFormat"""
  return _opensync.xmlformat_parse(*args)
class XMLField(object):
    """Proxy of C XMLField struct"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, XMLFormat xmlformat, char name) -> XMLField"""
        this = _opensync.new_XMLField(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _opensync.delete_XMLField
    __del__ = lambda self : None;
    def adopt_xmlfield_before_field(*args):
        """adopt_xmlfield_before_field(self, XMLField to_link)"""
        return _opensync.XMLField_adopt_xmlfield_before_field(*args)

    def adopt_xmlfield_after_field(*args):
        """adopt_xmlfield_after_field(self, XMLField to_link)"""
        return _opensync.XMLField_adopt_xmlfield_after_field(*args)

    def get_name(*args):
        """get_name(self) -> char"""
        return _opensync.XMLField_get_name(*args)

    def get_next(*args):
        """get_next(self) -> XMLField"""
        return _opensync.XMLField_get_next(*args)

    def get_attr(*args):
        """get_attr(self, char attr) -> char"""
        return _opensync.XMLField_get_attr(*args)

    def set_attr(*args):
        """set_attr(self, char attr, char value)"""
        return _opensync.XMLField_set_attr(*args)

    def get_attr_count(*args):
        """get_attr_count(self) -> int"""
        return _opensync.XMLField_get_attr_count(*args)

    def get_nth_attr_name(*args):
        """get_nth_attr_name(self, int nth) -> char"""
        return _opensync.XMLField_get_nth_attr_name(*args)

    def get_nth_attr_value(*args):
        """get_nth_attr_value(self, int nth) -> char"""
        return _opensync.XMLField_get_nth_attr_value(*args)

    def get_key_value(*args):
        """get_key_value(self, char key) -> char"""
        return _opensync.XMLField_get_key_value(*args)

    def set_key_value(*args):
        """set_key_value(self, char key, char value)"""
        return _opensync.XMLField_set_key_value(*args)

    def add_key_value(*args):
        """add_key_value(self, char key, char value)"""
        return _opensync.XMLField_add_key_value(*args)

    def get_key_count(*args):
        """get_key_count(self) -> int"""
        return _opensync.XMLField_get_key_count(*args)

    def get_nth_key_name(*args):
        """get_nth_key_name(self, int nth) -> char"""
        return _opensync.XMLField_get_nth_key_name(*args)

    def get_nth_key_value(*args):
        """get_nth_key_value(self, int nth) -> char"""
        return _opensync.XMLField_get_nth_key_value(*args)

    def set_nth_key_value(*args):
        """set_nth_key_value(self, int nth, char value)"""
        return _opensync.XMLField_set_nth_key_value(*args)

    def compare(*args):
        """compare(self, XMLField xmlfield) -> bool"""
        return _opensync.XMLField_compare(*args)

    name = property(get_name)
    next = property(get_next)
    __cmp__ = compare

    # map attributes and keys to two properties of the XMLField object
    class Attrs:
    	def __init__(self, xmlfield):
    		self.xmlfield = xmlfield
    	def __len__(self):
    		return self.xmlfield.get_attr_count()
    	def __getitem__(self, key):
    		return self.xmlfield.get_attr(key)
    	def __setitem__(self, key, value):
    		self.xmlfield.set_attr(key, value)
    	def __iter__(self):
    		class Iter:
    			def __init__(self, xmlfield):
    				self.xmlfield = xmlfield
    				self.pos = 0
    				self.maxpos = self.xmlfield.get_attr_count()
    			def __iter__(self):
    				return self
    			def next(self):
    				if self.pos > self.maxpos:
    					raise StopIteration
    				name = self.xmlfield.get_nth_attr_name(self.pos)
    				value = self.xmlfield.get_nth_attr_value(self.pos)
    				self.pos += 1
    				return (name, value)
    		return Iter(self.xmlfield)

    class Keys:
    	def __init__(self, xmlfield):
    		self.xmlfield = xmlfield
    	def __len__(self):
    		return self.xmlfield.get_key_count()
    	def __getitem__(self, key):
    		return self.xmlfield.get_key_value(key)
    	def __setitem__(self, key, value):
    		self.xmlfield.set_key_value(key, value)
    	def __iter__(self):
    		class Iter:
    			def __init__(self, xmlfield):
    				self.xmlfield = xmlfield
    				self.pos = 0
    				self.maxpos = self.xmlfield.get_key_count()
    			def __iter__(self):
    				return self
    			def next(self):
    				if self.pos > self.maxpos:
    					raise StopIteration
    				name = self.xmlfield.get_nth_key_name(self.pos)
    				value = self.xmlfield.get_nth_key_value(self.pos)
    				self.pos += 1
    				return (name, value)
    		return Iter(self.xmlfield)

    attrs = property(Attrs)
    keys = property(Keys)

XMLField_swigregister = _opensync.XMLField_swigregister
XMLField_swigregister(XMLField)

class Merger(object):
    """Proxy of C Merger struct"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, Capabilities capabilities) -> Merger"""
        this = _opensync.new_Merger(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _opensync.delete_Merger
    __del__ = lambda self : None;
    def merge(*args):
        """merge(self, XMLFormat xmlformat, XMLFormat entire)"""
        return _opensync.Merger_merge(*args)

    def demerge(*args):
        """demerge(self, XMLFormat xmlformat)"""
        return _opensync.Merger_demerge(*args)

Merger_swigregister = _opensync.Merger_swigregister
Merger_swigregister(Merger)

PLUGIN_NO_CONFIGURATION = _opensync.PLUGIN_NO_CONFIGURATION
PLUGIN_OPTIONAL_CONFIGURATION = _opensync.PLUGIN_OPTIONAL_CONFIGURATION
PLUGIN_NEEDS_CONFIGURATION = _opensync.PLUGIN_NEEDS_CONFIGURATION
class Plugin(object):
    """Proxy of C Plugin struct"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self, PyObject obj) -> Plugin
        __init__(self) -> Plugin
        """
        this = _opensync.new_Plugin(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _opensync.delete_Plugin
    __del__ = lambda self : None;
    def get_name(*args):
        """get_name(self) -> char"""
        return _opensync.Plugin_get_name(*args)

    def set_name(*args):
        """set_name(self, char name)"""
        return _opensync.Plugin_set_name(*args)

    def get_longname(*args):
        """get_longname(self) -> char"""
        return _opensync.Plugin_get_longname(*args)

    def set_longname(*args):
        """set_longname(self, char longname)"""
        return _opensync.Plugin_set_longname(*args)

    def get_description(*args):
        """get_description(self) -> char"""
        return _opensync.Plugin_get_description(*args)

    def set_description(*args):
        """set_description(self, char description)"""
        return _opensync.Plugin_set_description(*args)

    def get_config_type(*args):
        """get_config_type(self) -> ConfigurationType"""
        return _opensync.Plugin_get_config_type(*args)

    def set_config_type(*args):
        """set_config_type(self, ConfigurationType config_type)"""
        return _opensync.Plugin_set_config_type(*args)

    def initialize(*args):
        """initialize(self, PluginInfo info) -> void"""
        return _opensync.Plugin_initialize(*args)

    def finalize(*args):
        """finalize(self, void data)"""
        return _opensync.Plugin_finalize(*args)

    def discover(*args):
        """discover(self, void data, PluginInfo info)"""
        return _opensync.Plugin_discover(*args)

    def is_usable(*args):
        """is_usable(self) -> bool"""
        return _opensync.Plugin_is_usable(*args)

    name = property(get_name, set_name)
    longname = property(get_longname, set_longname)
    description = property(get_description, set_description)
    config_type = property(get_config_type, set_config_type)
    is_usable = property(is_usable)

Plugin_swigregister = _opensync.Plugin_swigregister
Plugin_swigregister(Plugin)

class PluginEnv(object):
    """Proxy of C PluginEnv struct"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self) -> PluginEnv"""
        this = _opensync.new_PluginEnv(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _opensync.delete_PluginEnv
    __del__ = lambda self : None;
    def load(*args):
        """load(self, char path=None)"""
        return _opensync.PluginEnv_load(*args)

    def register_plugin(*args):
        """register_plugin(self, Plugin plugin)"""
        return _opensync.PluginEnv_register_plugin(*args)

    def load_module(*args):
        """load_module(self, char filename)"""
        return _opensync.PluginEnv_load_module(*args)

    def find_plugin(*args):
        """find_plugin(self, char name) -> Plugin"""
        return _opensync.PluginEnv_find_plugin(*args)

    def num_plugins(*args):
        """num_plugins(self) -> int"""
        return _opensync.PluginEnv_num_plugins(*args)

    def nth_plugin(*args):
        """nth_plugin(self, int nth) -> Plugin"""
        return _opensync.PluginEnv_nth_plugin(*args)

    def plugin_is_usable(*args):
        """plugin_is_usable(self, char pluginname) -> bool"""
        return _opensync.PluginEnv_plugin_is_usable(*args)

    # extend the SWIG-generated constructor, so that we can setup our list-wrapper classes
    __oldinit = __init__
    def __init__(self, *args):
    	self.__oldinit(*args)
    	self.plugins = _ListWrapper(self.num_plugins, self.nth_plugin)

PluginEnv_swigregister = _opensync.PluginEnv_swigregister
PluginEnv_swigregister(PluginEnv)

class PluginInfo(object):
    """Proxy of C PluginInfo struct"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self, PyObject obj) -> PluginInfo
        __init__(self) -> PluginInfo
        """
        this = _opensync.new_PluginInfo(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _opensync.delete_PluginInfo
    __del__ = lambda self : None;
    def set_loop(*args):
        """set_loop(self, void loop)"""
        return _opensync.PluginInfo_set_loop(*args)

    def get_loop(*args):
        """get_loop(self) -> void"""
        return _opensync.PluginInfo_get_loop(*args)

    def set_config(*args):
        """set_config(self, char config)"""
        return _opensync.PluginInfo_set_config(*args)

    def get_config(*args):
        """get_config(self) -> char"""
        return _opensync.PluginInfo_get_config(*args)

    def set_configdir(*args):
        """set_configdir(self, char configdir)"""
        return _opensync.PluginInfo_set_configdir(*args)

    def get_configdir(*args):
        """get_configdir(self) -> char"""
        return _opensync.PluginInfo_get_configdir(*args)

    def find_objtype(*args):
        """find_objtype(self, char name) -> ObjTypeSink"""
        return _opensync.PluginInfo_find_objtype(*args)

    def add_objtype(*args):
        """add_objtype(self, ObjTypeSink sink)"""
        return _opensync.PluginInfo_add_objtype(*args)

    def num_objtypes(*args):
        """num_objtypes(self) -> int"""
        return _opensync.PluginInfo_num_objtypes(*args)

    def nth_objtype(*args):
        """nth_objtype(self, int nth) -> ObjTypeSink"""
        return _opensync.PluginInfo_nth_objtype(*args)

    def get_main_sink(*args):
        """get_main_sink(self) -> ObjTypeSink"""
        return _opensync.PluginInfo_get_main_sink(*args)

    def set_main_sink(*args):
        """set_main_sink(self, ObjTypeSink sink)"""
        return _opensync.PluginInfo_set_main_sink(*args)

    def get_format_env(*args):
        """get_format_env(self) -> FormatEnv"""
        return _opensync.PluginInfo_get_format_env(*args)

    def set_format_env(*args):
        """set_format_env(self, FormatEnv env)"""
        return _opensync.PluginInfo_set_format_env(*args)

    def get_sink(*args):
        """get_sink(self) -> ObjTypeSink"""
        return _opensync.PluginInfo_get_sink(*args)

    def set_sink(*args):
        """set_sink(self, ObjTypeSink sink)"""
        return _opensync.PluginInfo_set_sink(*args)

    def set_groupname(*args):
        """set_groupname(self, char groupname)"""
        return _opensync.PluginInfo_set_groupname(*args)

    def get_groupname(*args):
        """get_groupname(self) -> char"""
        return _opensync.PluginInfo_get_groupname(*args)

    def set_version(*args):
        """set_version(self, Version version)"""
        return _opensync.PluginInfo_set_version(*args)

    def get_version(*args):
        """get_version(self) -> Version"""
        return _opensync.PluginInfo_get_version(*args)

    def set_capabilities(*args):
        """set_capabilities(self, Capabilities capabilities)"""
        return _opensync.PluginInfo_set_capabilities(*args)

    def get_capabilities(*args):
        """get_capabilities(self) -> Capabilities"""
        return _opensync.PluginInfo_get_capabilities(*args)

    loop = property(get_loop, set_loop)
    config = property(get_config, set_config)
    configdir = property(get_configdir, set_configdir)
    main_sink = property(get_main_sink, set_main_sink)
    format_env = property(get_format_env, set_format_env)
    sink = property(get_sink, set_sink)
    groupname = property(get_groupname, set_groupname)
    version = property(get_version, set_version)
    capabilities = property(get_capabilities, set_capabilities)

    # extend the SWIG-generated constructor, so that we can setup our list-wrapper classes
    __oldinit = __init__
    def __init__(self, *args):
    	self.__oldinit(*args)
    	self.objtypes = _ListWrapper(self.num_objtypes, self.nth_objtype)

PluginInfo_swigregister = _opensync.PluginInfo_swigregister
PluginInfo_swigregister(PluginInfo)

class ObjTypeSink(object):
    """Proxy of C ObjTypeSink struct"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, char objtype, PyObject callback_obj=None) -> ObjTypeSink"""
        this = _opensync.new_ObjTypeSink(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _opensync.delete_ObjTypeSink
    __del__ = lambda self : None;
    def get_name(*args):
        """get_name(self) -> char"""
        return _opensync.ObjTypeSink_get_name(*args)

    def set_name(*args):
        """set_name(self, char name)"""
        return _opensync.ObjTypeSink_set_name(*args)

    def num_objformats(*args):
        """num_objformats(self) -> int"""
        return _opensync.ObjTypeSink_num_objformats(*args)

    def nth_objformat(*args):
        """nth_objformat(self, int nth) -> char"""
        return _opensync.ObjTypeSink_nth_objformat(*args)

    def add_objformat(*args):
        """add_objformat(self, char format)"""
        return _opensync.ObjTypeSink_add_objformat(*args)

    def remove_objformat(*args):
        """remove_objformat(self, char format)"""
        return _opensync.ObjTypeSink_remove_objformat(*args)

    def get_userdata(*args):
        """get_userdata(self) -> void"""
        return _opensync.ObjTypeSink_get_userdata(*args)

    def get_callback_obj(*args):
        """get_callback_obj(self) -> PyObject"""
        return _opensync.ObjTypeSink_get_callback_obj(*args)

    def get_changes(*args):
        """get_changes(self, void plugindata, PluginInfo info, Context ctx)"""
        return _opensync.ObjTypeSink_get_changes(*args)

    def read_change(*args):
        """read_change(self, void plugindata, PluginInfo info, Change change, Context ctx)"""
        return _opensync.ObjTypeSink_read_change(*args)

    def connect(*args):
        """connect(self, void plugindata, PluginInfo info, Context ctx)"""
        return _opensync.ObjTypeSink_connect(*args)

    def disconnect(*args):
        """disconnect(self, void plugindata, PluginInfo info, Context ctx)"""
        return _opensync.ObjTypeSink_disconnect(*args)

    def sync_done(*args):
        """sync_done(self, void plugindata, PluginInfo info, Context ctx)"""
        return _opensync.ObjTypeSink_sync_done(*args)

    def commit_change(*args):
        """commit_change(self, void plugindata, PluginInfo info, Change change, Context ctx)"""
        return _opensync.ObjTypeSink_commit_change(*args)

    def committed_all(*args):
        """committed_all(self, void plugindata, PluginInfo info, Context ctx)"""
        return _opensync.ObjTypeSink_committed_all(*args)

    def is_enabled(*args):
        """is_enabled(self) -> bool"""
        return _opensync.ObjTypeSink_is_enabled(*args)

    def set_enabled(*args):
        """set_enabled(self, bool enabled)"""
        return _opensync.ObjTypeSink_set_enabled(*args)

    def is_available(*args):
        """is_available(self) -> bool"""
        return _opensync.ObjTypeSink_is_available(*args)

    def set_available(*args):
        """set_available(self, bool available)"""
        return _opensync.ObjTypeSink_set_available(*args)

    def get_write(*args):
        """get_write(self) -> bool"""
        return _opensync.ObjTypeSink_get_write(*args)

    def set_write(*args):
        """set_write(self, bool write)"""
        return _opensync.ObjTypeSink_set_write(*args)

    def get_read(*args):
        """get_read(self) -> bool"""
        return _opensync.ObjTypeSink_get_read(*args)

    def set_read(*args):
        """set_read(self, bool read)"""
        return _opensync.ObjTypeSink_set_read(*args)

    def get_slowsync(*args):
        """get_slowsync(self) -> bool"""
        return _opensync.ObjTypeSink_get_slowsync(*args)

    def set_slowsync(*args):
        """set_slowsync(self, bool slowsync)"""
        return _opensync.ObjTypeSink_set_slowsync(*args)

    name = property(get_name, set_name)
    enabled = property(is_enabled, set_enabled)
    available = property(is_available, set_available)
    write = property(get_write, set_write)
    read = property(get_read, set_read)
    slowsync = property(get_slowsync, set_slowsync)
    callback_obj = property(get_callback_obj)

    # extend the SWIG-generated constructor, so that we can setup our list-wrapper classes
    __oldinit = __init__
    def __init__(self, *args):
    	self.__oldinit(*args)
    	self.objformats = _ListWrapper(self.num_objformats, self.nth_objformat)

ObjTypeSink_swigregister = _opensync.ObjTypeSink_swigregister
ObjTypeSink_swigregister(ObjTypeSink)

class ObjTypeSinkCallbacks:
	"""A purely-Python class that should be subclassed by plugins implementing their own sinks."""
	def __init__(self, objtype):
		# construct ObjTypeSink object and pass it our reference
		self.sink = ObjTypeSink(objtype, self)

	def connect(self, info, ctx):
		pass

	def get_changes(self, info, ctx):
		pass

	def commit(self, info, ctx, chg):
		pass

	def committed_all(self, info, ctx):
		pass

	def read(self, info, ctx, chg):
		pass

	def write(self, info, ctx, chg):
		pass

	def disconnect(self, info, ctx):
		pass

	def sync_done(self, info, ctx):
		pass

TRACE_ENTRY = _opensync.TRACE_ENTRY
TRACE_EXIT = _opensync.TRACE_EXIT
TRACE_INTERNAL = _opensync.TRACE_INTERNAL
TRACE_SENSITIVE = _opensync.TRACE_SENSITIVE
TRACE_EXIT_ERROR = _opensync.TRACE_EXIT_ERROR
TRACE_ERROR = _opensync.TRACE_ERROR

def rand_str(*args):
  """rand_str(int maxlength) -> char"""
  return _opensync.rand_str(*args)

def trace_reset_indent(*args):
  """trace_reset_indent()"""
  return _opensync.trace_reset_indent(*args)

def trace(*args):
  """trace(TraceType type, char message)"""
  return _opensync.trace(*args)

def trace_disable(*args):
  """trace_disable()"""
  return _opensync.trace_disable(*args)

def trace_enable(*args):
  """trace_enable()"""
  return _opensync.trace_enable(*args)

def get_version(*args):
  """get_version() -> char"""
  return _opensync.get_version(*args)
# this won't change, so just call it once at module load time
version = get_version()


def version_load_from_descriptions(*args):
  """version_load_from_descriptions() -> PyObject"""
  return _opensync.version_load_from_descriptions(*args)
class Version(object):
    """Proxy of C Version struct"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self) -> Version"""
        this = _opensync.new_Version(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _opensync.delete_Version
    __del__ = lambda self : None;
    def get_plugin(*args):
        """get_plugin(self) -> char"""
        return _opensync.Version_get_plugin(*args)

    def set_plugin(*args):
        """set_plugin(self, char plugin)"""
        return _opensync.Version_set_plugin(*args)

    def get_priority(*args):
        """get_priority(self) -> char"""
        return _opensync.Version_get_priority(*args)

    def set_priority(*args):
        """set_priority(self, char priority)"""
        return _opensync.Version_set_priority(*args)

    def get_vendor(*args):
        """get_vendor(self) -> char"""
        return _opensync.Version_get_vendor(*args)

    def set_vendor(*args):
        """set_vendor(self, char vendor)"""
        return _opensync.Version_set_vendor(*args)

    def get_modelversion(*args):
        """get_modelversion(self) -> char"""
        return _opensync.Version_get_modelversion(*args)

    def set_modelversion(*args):
        """set_modelversion(self, char modelversion)"""
        return _opensync.Version_set_modelversion(*args)

    def get_firmwareversion(*args):
        """get_firmwareversion(self) -> char"""
        return _opensync.Version_get_firmwareversion(*args)

    def set_firmwareversion(*args):
        """set_firmwareversion(self, char firmwareversion)"""
        return _opensync.Version_set_firmwareversion(*args)

    def get_softwareversion(*args):
        """get_softwareversion(self) -> char"""
        return _opensync.Version_get_softwareversion(*args)

    def set_softwareversion(*args):
        """set_softwareversion(self, char softwareversion)"""
        return _opensync.Version_set_softwareversion(*args)

    def get_hardwareversion(*args):
        """get_hardwareversion(self) -> char"""
        return _opensync.Version_get_hardwareversion(*args)

    def set_hardwareversion(*args):
        """set_hardwareversion(self, char hardwareversion)"""
        return _opensync.Version_set_hardwareversion(*args)

    def get_identifier(*args):
        """get_identifier(self) -> char"""
        return _opensync.Version_get_identifier(*args)

    def set_identifier(*args):
        """set_identifier(self, char identifier)"""
        return _opensync.Version_set_identifier(*args)

    def matches(*args):
        """matches(self, Version pattern) -> int"""
        return _opensync.Version_matches(*args)

    def find_capabilities(*args):
        """find_capabilities(self) -> Capabilities"""
        return _opensync.Version_find_capabilities(*args)

    plugin = property(get_plugin, set_plugin)
    priority = property(get_priority, set_priority)
    vendor = property(get_vendor, set_vendor)
    modelversion = property(get_modelversion, set_modelversion)
    firmwareversion = property(get_firmwareversion, set_firmwareversion)
    softwareversion = property(get_softwareversion, set_softwareversion)
    hardwareversion = property(get_hardwareversion, set_hardwareversion)
    identifier = property(get_identifier, set_identifier)

Version_swigregister = _opensync.Version_swigregister
Version_swigregister(Version)



