/***************************************************************************
    smb4kfileio  -  Does file IO operations for Smb4K
                             -------------------
    begin                : Do Jan 1 2004
    copyright            : (C) 2004-2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

// Qt includes
#include <qdir.h>
#include <qfile.h>
#include <qtextstream.h>

// KDE includes
#include <kapplication.h>
#include <kdebug.h>
#include <klocale.h>
#include <kuser.h>

// system specific includes
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <grp.h>
#include <pwd.h>

// application specific includes
#include "smb4kfileio.h"
#include "smb4kdefs.h"
#include "smb4kerror.h"
#include "smb4kglobal.h"
#include "smb4ksettings.h"

using namespace Smb4KGlobal;



Smb4KFileIO::Smb4KFileIO( QObject *parent, const char *name ) : QObject( parent, name )
{
  m_proc = new KProcess( this, "FileIOProcess" );
  m_proc->setUseShell( true );

  connect( m_proc, SIGNAL( receivedStderr( KProcess *, char *, int ) ),
           this,   SLOT( slotReceivedStderr( KProcess *, char *, int ) ) );

  connect( m_proc, SIGNAL( receivedStdout( KProcess *, char *, int ) ),
           this,   SLOT( slotReceivedStdout( KProcess *, char *, int ) ) );

  connect( m_proc, SIGNAL( processExited( KProcess * ) ),
           this,   SLOT( slotProcessExited( KProcess * ) ) );
}


Smb4KFileIO::~Smb4KFileIO()
{
}


bool Smb4KFileIO::writeSudoers( Smb4KFileIO::Operation operation )
{
  KUser user = KUser( getuid() );
  
  if ( user.isValid() )
  {
    QString command;
  
    switch ( operation )
    {
      case Insert:
      {
        command.append( "kdesu -t -c \"smb4k_sudowriter --adduser "+user.loginName()+"\"" );
        break;
      }
      case Remove:
      {
        command.append( "kdesu -t -c \"smb4k_sudowriter --removeuser "+user.loginName()+"\"" );
        break;
      }
      default:
      {
        emit finished();
        return false;
      }
    }
  
    *m_proc << command;
    m_proc->start( KProcess::NotifyOnExit, KProcess::AllOutput );
  }
  else
  {
    return false;
  }
  
  return true;
}


void Smb4KFileIO::processSudoers()
{
  // When the output does not contain the string 'smb4k_sudowriter',
  // then everything went fine.
  if ( m_buffer.contains( "smb4k_sudowriter", true ) != 0 )
  {
    Smb4KError::error( ERROR_UNKNOWN, "sudoers", m_buffer );
    emit failed();
  }
  else
  {
    // Do nothing
  }
}


/////////////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////

void Smb4KFileIO::slotReceivedStderr( KProcess *, char *buf, int len )
{
  m_buffer.append( QString::fromLocal8Bit( buf, len ) );
}


void Smb4KFileIO::slotReceivedStdout( KProcess *, char *buf, int len )
{
  m_buffer.append( QString::fromLocal8Bit( buf, len ) );
}


void Smb4KFileIO::slotProcessExited( KProcess *proc )
{
  if ( proc->normalExit() )
  {
    processSudoers();
  }
  else
  {
    emit failed();
  }
    
  m_proc->clearArguments();
  m_buffer = QString::null;
  
  emit finished();
}

#include "smb4kfileio.moc"
