/***************************************************************************
    smb4kscanner_p  -  This is a private helper class for Smb4KScanner.
                             -------------------
    begin                : Do Jul 19 2007
    copyright            : (C) 2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KSCANNER_P_H
#define SMB4KSCANNER_P_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qstring.h>

class Smb4KScannerPrivate
{
  public:
    Smb4KScannerPrivate();
    ~Smb4KScannerPrivate();
    bool retry;
    void clearData();
    void setWorkgroup( const QString &w );
    void setHost( const QString &h );
    void setIP( const QString &i );
    void setShare( const QString &s );
    const QString &workgroup();
    const QString &host();
    const QString &ip();
    const QString &share();

  private:
    QString m_workgroup;
    QString m_host;
    QString m_ip;
    QString m_share;
};

#endif
