#!/bin/sh

# Heavily based on Slackware 11.0 doinst.sh scripts
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

LOGDIR="/var/log/dependencies"
MISDIR="/var/log/missing"

if [ ! -d $LOGDIR ]; then mkdir -p $LOGDIR; fi
if [ ! -d $MISDIR ]; then mkdir -p $MISDIR; fi

config /etc/tracepkg/tracepkg.conf.new