#!/bin/sh

config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

config etc/zaptel.conf.new
( cd etc/hotplug/usb ; rm -rf xpp_fxloader )
( cd etc/hotplug/usb ; ln -sf /usr/share/zaptel/xpp_fxloader xpp_fxloader )
( cd usr/lib ; rm -rf libtonezone.so )
( cd usr/lib ; ln -sf libtonezone.so.1.0 libtonezone.so )
( cd usr/lib ; rm -rf libtonezone.so.1 )
( cd usr/lib ; ln -sf libtonezone.so.1.0 libtonezone.so.1 )
