%define         name 		bibletime
%define         version 	1.6.5

# this needs to be changed depending on build number
%define		release 	1

# This should be set to your os.
# Possible values are  Mandrake, Red Hat, Turbolinux, Caldera, SuSE, Debian, etc.
# In bibletime.spec.in this is automatically filled in by configure
%define		ostype 		Debian

# This should be set to the version of your OS (6.0, 6.1, 6.2, 7.0, 7.1, 7.2, 8.0, etc.)
# Done by configure in bibletime.spec.in
%define		osversion 	lenny/sid

# This is your cpu i486, i586, i686, ppc, sparc, alpha, etc.
%define		buildarch 	i586

# This the RPM group on your system that this will installed into.
# Graphical desktop/KDE, X11/apps, etc.
%define		rpmgroup 	Graphical desktop/KDE

Summary:        BibleTime %{version} is an easy to use Bible study tool for KDE.
Name:		%{name}
Version:        %{version}
Release:        %{release}
Copyright:      GPL
Vendor:         BibleTime's developer (info@bibletime.info)
Url:            http://www.bibletime.info/
Packager:       Brook Humphrey <bah@webmedic.net>, Joachim Ansorg <junkmail@joachim.ansorgs.de>
Group:          %{rpmgroup}
BuildArch:      %{buildarch}
Source0:        %{name}-%{version}.tar.bz2
BuildRoot:      %{_tmppath}/%{name}-%{version}--rootbibletime
Prefix: 	/usr
Requires:	sword >= 1.5.8
Distribution:	%{ostype} %{osversion}
BuildRequires: 	kdelibs-devel
BuildRequires: 	sword-devel >= 1.5.8

%description
BibleTime %{version}-%{release} is a free and easy to use bible study tool for UNIX systems.

BibleTime provides easy handling of digitalized texts (Bibles, commentaries and lexicons) and powerful features to work with these texts (search in texts, write own notes, save, print etc.). BibleTime is a frontend for the  SWORD Bible Framework.

This is  a relocatable package, you can install it on different target with
rpm -Uvh bibletime-%{version}-%{release}.rpm --prefix /usr/local/opt/apps/noncommercial
default is %{_prefix}

The SWORD Project is an effort to create an ever expanding software package for research and study of God and His Word.  The SWORD Bible Framework allows easy manipulation of Bible texts, commentaries, lexicons, dictionaries, etc.  Many frontends are build using this framework.  An installed module set may be shared between any frontend using the framework.

This rpm was compiled on a %{ostype} %{osversion} system for %{buildarch} class cpu's.


%prep
rm -rf $RPM_BUILD_ROOT
rm -rf $RPM_BUILD_DIR/%{name}-%{version}

%setup -q
make -f Makefile.cvs

# Look for common rpm-options:
if [ -f /etc/opt/kde3/common_options ]; then
  . /etc/opt/kde3/common_options
  ./configure $configkde
else
  ./configure --prefix=${_prefix}
fi

# Setup for parallel builds
numprocs=`egrep -c ^cpu[0-9]+ /proc/stat || :`
if [ "$numprocs" = "0" ]; then
 numprocs=1
fi

make -j$numprocs

%install
make DESTDIR=$RPM_BUILD_ROOT install-strip

#cd $RPM_BUILD_ROOT
#find . -type d | sed '1,2d;s,^\.,\%attr(-\,root\,root) \%dir ,' > $RPM_BUILD_DIR/bt-files.list
#find . -type f | sed 's,^\.,\%attr(-\,root\,root) ,' >>  $RPM_BUILD_DIR/bt-files.list
#find . -type l | sed 's,^\.,\%attr(-\,root\,root) ,' >>  $RPM_BUILD_DIR/bt-files.list


%post
/sbin/ldconfig

%postun
/sbin/ldconfig

%clean
#rm -f $RPM_BUILD_DIR/master.list
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%{prefix}/bin/*
%{prefix}/share/applnk/Applications/bibletime.desktop
%{prefix}/share/apps/bibletime/
%{prefix}/share/doc/HTML/en/bibletime/
%{prefix}/share/icons/*

%changelog
* Sat Dec 27 2003 Joachim Ansorg <junkmail@joachim.ansorgs.de>

-We require curl 7.10 or later now

-Update to BibleTime 1.4 and Sword 1.5.7

* Sun Jun 22 2003 Joachim Ansorg <junkmail@joachim.ansorgs.de>

-Cleanup. We require no an Sword RPM file to be installed.

-Removed Mandrake menu stuff because there's an own SPEC file for this.


* Fri Feb 14 2003 Joachim Ansorg <junkmail@joachim.ansorgs.de>

-Removed locales.d source and management of Sword files because we require a Sword RPM now.


* Mon Apr 8 2002 Brook Humphrey <bah@webmedic.net> bibletime-1.1

- Added to the spec to better handle mandrake menus during compile. Now should be compatable with all os's.

- added locals.d source to build. This removes dependecy on sword being installed. Will make seperate package for this later.


* Fri Mar 31 2002 Joachim Ansorg <jansorg@gmx.de>

- Made including the book translations working finally.

- Fixed SPEC files to work with SuSE


* Thu Feb 7 2002 Brook Humphrey <bah@webmedic.net> bibletime-1.0.2

- changed compile time options to mach bibletime spec included with source files

- compiled on mandrake 8.2


* Fri Sep 7 2001 Joachim Ansorg <jansorg@gmx.de>

- Added the bookname files in the file list

* Tue Jul 10 2001 Brook Humphrey <bah@webmedic.net> bibletime-1.0.1-Mandrake8.0.4mdk

- Recompile because of dependecy problems.  

* Tue Jul 10 2001 Brook Humphrey <bah@webmedic.net> bibletime-1.0.1-Mandrake8.0.1mdk

- bug fix release bibletime-1.0.1

- adda extra compile options to spec file.

- Merged in suse changes for compileing on SuSE

* Sun May 27 2001 Brook Humphrey <bah@webmedic.net>

- Trying different variations of static compiles again.

- Still using cvs sources while waiting for 1.0 release.

* Thu May 24 2001 Brook Humphrey <bah@webmedic.net>

- Trying for x static and whatever else we can get into it.

- No X for today Got libz to compile in but it causes segfault.

* Wed May 23 2001 Brook Humphrey <bah@webmedic.net>

- Yet another try at static qt.

- Qt static works now.

* Mon May 21 2001 Brook Humphrey <bah@webmedic.net>

- Static is working for kde and a few other libs but not qt yet.

- Testing another patch today to try to get qt compiled static.

* Sun May 20 2001 Brook Humphrey <bah@webmedic.net>

- Cleaned up spec some more(stupid spelling error's)

- static compile not working today so added option to compile kde and sword as static seperately

* Sat May 19 2001 Brook Humphrey <bah@webmedic.net>

- Cleaned up spec some more and added a few more comments

- Changed spec to automaticly do parts concerning static and Mandrake menus

- All info can be set in defines at top of spec file no other changes should need to be made

- Fixed patch to compile static should now compile static with kde libs 

- Test to compile with qt as static also

* Sun May 13 2001 Brook Humphrey <bah@webmedic.net>

- cleaned up spec file and added more comments for easier reading.

- changed sword.conf instelation to check for previous versions of sword.conf

- If found a new sword.conf is not created

- Made a patch to hopefully compile kde and other libs as atatic

- static compile didn't work for today.

* Tue May 8 2001 Brook Humphrey <bah@webmedic.net>

- Updated package to be relocatable

- added sword directories and sword.conf to install

* Mon Apr 30 2001 Brook Humphrey <bah@webmedic.net>

- Changed to build staticly

- added more mandrake macros to spec file

* Mon Apr 23 2001 Brook Humphrey <bah@webmedic.net>

- made changes to enable compile of cvs tree

* Wed Mar 14 2001 Brook Humphrey <bah@webmedic.net>

- updated to use mandrake menu sysem

