/***************************************************************************
 *                                                                         *
 *   copyright (C) 2003 by Michael Buesch                                  *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/


#include <klocale.h>

#include "calcchecksumtray.h"

CalcChecksumTray::CalcChecksumTray(QWidget* parent, const char* name)
 : KSystemTray(parent, name)
{
	contextMenu()->insertItem(i18n("&Undock"), parent, SLOT(trayUndockButton_slot()));
	contextMenu()->insertSeparator();
	contextMenu()->insertItem(i18n("&Select file (for normal hash-calculation)..."),
  				  parent, SLOT(traySelectFileButton_slot()));
	contextMenu()->insertItem(i18n("S&elect hash-list..."),
				  parent, SLOT(traySelectHashListButton_slot()));
}

CalcChecksumTray::~CalcChecksumTray()
{
}

void CalcChecksumTray::contextMenuAboutToShow(KPopupMenu* menu)
{
	menu->removeItemAt(menu->count()-1);
	menu->insertItem(i18n("&Quit"), parent(), SLOT(trayQuitButton_slot()));
}
