/***************************************************************************
 *                                                                         *
 *   copyright (C) 2003 by Michael Buesch                                  *
 *   email: fsdeveloper@yahoo.de                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#include "comparewndimpl.h"

#include <qmessagebox.h>

#include <klocale.h>


CompareWndImpl::CompareWndImpl(QString _compWith, QWidget* parent,
			       const char *name, bool modal, WFlags f)
 : QDialog(parent, name, modal, f)
{
	compWith = _compWith;

	vbox1 = new QVBox(this);
	title = new QLabel(vbox1);
	compLineEdit = new QLineEdit(vbox1);
	hbox1 = new QHBox(vbox1);
	compButton = new QPushButton(i18n("Go!"), hbox1);
	closeButton = new QPushButton(i18n("Close"), hbox1);

	vbox1->setSpacing(10);
	vbox1->setMargin(10);

	resize(400, 100);

	setCaption(i18n("CalcChecksum compare"));
	title->setText(i18n("Compare selected hash with:"));
	title->setAlignment(Qt::AlignHCenter);

	connect(compButton, SIGNAL(clicked()), this, SLOT(goButton_slot()));
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
}

CompareWndImpl::~CompareWndImpl()
{
}

void CompareWndImpl::goButton_slot()
{
	compWith = compWith.lower();
	QString enteredSum(compLineEdit->text().lower());
	// remove whitespaces
	enteredSum.remove(' '); // blank space
	enteredSum.remove('	'); // tab
	enteredSum.remove('\r');
	enteredSum.remove('\n');
	int colon = enteredSum.find(':');
	if (colon != -1)
		enteredSum.remove(0, colon + 1);

	if (compWith == enteredSum) {
		QMessageBox::information(this, i18n("OK"),
					 i18n("These two checksums match exactly."),
					 QMessageBox::Ok);
	} else {
		QMessageBox::warning(this, i18n("Failed!"),
				     i18n("Sorry, these checksums don't match!"),
				     QMessageBox::Ok, QMessageBox::NoButton);
	}
}

void CompareWndImpl::resizeEvent(QResizeEvent *)
{
	vbox1->resize(size());
}
