/***************************************************************************
 *                                                                         *
 *   copyright (C) 2004 by Michael Buesch                                  *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   crc.c - Cyclic redundancy checks.                                     *
 *   Copyright (C) 2003 Free Software Foundation, Inc.                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#ifndef CRC32_H
#define CRC32_H

#include <stdlib.h>
#include <string>
#include <stdint.h>
#include "globalstuff.h"

using std::string;

#define CRC32_HASHLEN_BYTE	(32 / 8)


class Crc32
{
	struct CRC_CONTEXT
	{
		uint32_t CRC;
		byte buf[4];
	};

public:
	Crc32();
	static bool selfTest();

	/** calculate CRC32 on 'str' and return the hash (in hex format)
	  * or an empty string on error.
	  */
	string calcCrc32(const string &str);
	/** calculate CRC32 on file 'filename' and return the hash
	  * (in hex format) or an empty string on error.
	  * Progress information is given through 'commSocket'.
	  */
	string calcCrc32(const string &filename, int *commSocket);

protected: // protected, as we don't need them public in CalcChecksum.
	void crc32_write(const byte *inbuf, size_t inlen);
	void crc32_init();
	byte * crc32_final();

	void crc32rfc1510_init();
	byte * crc32rfc1510_final();

protected:
	uint32_t update_crc32(uint32_t crc, const byte *buf, size_t len);

protected:
	struct CRC_CONTEXT ctx;
};

#endif
