/***************************************************************************
 *                                                                         *
 *   copyright (C) 2003 by Michael Buesch                                  *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#include "csabout.h"

#include <kapplication.h>
#include <kaboutdata.h>
#include <kglobal.h>
#include <kurllabel.h>

#include <qlabel.h>


CsAbout::CsAbout(QWidget *parent)
 : KAboutDialog(AbtTabbed|AbtProduct,
		kapp ? kapp->caption() : QString::null,
		0, Default,
		parent)
{
	const KAboutData * const aboutData = KGlobal::instance()->aboutData();
	setProduct(aboutData->programName(), aboutData->version(),
		   QString::null, QString::null);

	QString appPageText = aboutData->shortDescription() + "\n";
	if (!aboutData->otherText().isEmpty())
		appPageText += "\n" + aboutData->otherText() + "\n";
	if (!aboutData->copyrightStatement().isEmpty())
		appPageText += "\n" + aboutData->copyrightStatement() + "\n";

	KAboutContainer *appPage = addContainerPage(i18n("&About"));
	QLabel *appPageLabel = new QLabel(appPageText, 0);
	appPage->addWidget(appPageLabel);

	if (!aboutData->homepage().isEmpty()) {
		KURLLabel *url = new KURLLabel();
		url->setText(aboutData->homepage());
		url->setURL(aboutData->homepage());
		appPage->addWidget( url );
		connect(url, SIGNAL(leftClickedURL(const QString &)),
			this, SLOT(openURLSlot(const QString &)));
	}

	int authorCount = aboutData->authors().count();
	if (authorCount) {
		QString authorPageTitle = authorCount == 1 ?
					  i18n("A&uthor") : i18n("A&uthors");
		KAboutContainer *authorPage = addScrolledContainerPage( authorPageTitle );
		QValueList<KAboutPerson>::ConstIterator it;
		for (it = aboutData->authors().begin();
		     it != aboutData->authors().end(); ++it) {
			authorPage->addPerson( (*it).name(), (*it).emailAddress(),
					      (*it).webAddress(), (*it).task() );
		}
	}

	int creditsCount = aboutData->credits().count();
	if (creditsCount) {
		KAboutContainer *creditsPage =
			addScrolledContainerPage( i18n("&Thanks To") );
		QValueList<KAboutPerson>::ConstIterator it;
		for (it = aboutData->credits().begin();
		     it != aboutData->credits().end(); ++it) {
			creditsPage->addPerson( (*it).name(), (*it).emailAddress(),
						(*it).webAddress(), (*it).task() );
		}
	}

	const QValueList<KAboutTranslator> translatorList = aboutData->translators();

	if(translatorList.count() > 0) {
		KAboutContainer *translatorPage =
			addScrolledContainerPage( i18n("T&ranslation") );

		QValueList<KAboutTranslator>::ConstIterator it;
		for(it = translatorList.begin(); it != translatorList.end(); ++it) {
			translatorPage->addPerson((*it).name(), (*it).emailAddress(), 0, 0);
		}

		QLabel *label = new QLabel(KAboutData::aboutTranslationTeam()
					   ,translatorPage);
		label->adjustSize();
		label->setMinimumSize(label->sizeHint());
		translatorPage->addWidget(label);
	}

	if (!aboutData->license().isEmpty() )
		addLicensePage(i18n("&License Agreement"), aboutData->license());

	setInitialSize( QSize(400,1) );
}

CsAbout::~CsAbout()
{
}
