 /***************************************************************************
 *                                                                         *
 *   copyright (C) 2004 by Michael Buesch                                  *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#ifndef GROWVAL_H
#define GROWVAL_H

/** Implements a value that can only grow (not shrink).
  * This class is written to be small and not feature rich or flexible,
  * because we don't need more features here (yet?).
  * That's the reason why templates or something like that are not
  * being used.
  */
class GrowVal
{
public:
	GrowVal()
		{ value = 0; }
	~GrowVal() {}

	/** returns the current value */
	int get()
		{ return value; }
	/** set the value to "val" and _don't_ check for
	  * growing. You may use this function to set the initial value
	  */
	void set(int val)
		{ value = val; }
	/** set the value and look for _never_ shrinking the value */
	GrowVal & operator=(int val);

protected:
	/** holds the value */
	int value;
};

#endif
