/***************************************************************************
 *                                                                         *
 *   copyright (C) 2002, 2003, 2004 by Michael Buesch                      *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/


#include <kaboutdata.h>
#include <klocale.h>
#include "uniqueapp.h"

#include "calcchecksum.h"
#include "calcchecksumlicense.h"

#define PROJECT_HOMEPAGE	"http://calcchecksum.sourceforge.net"

static const char *description = I18N_NOOP("CalcChecksum\n\n"
	"A small tool for calculating various checksums (hashes).\n"
	"Thanks to all people, that have written the algorithms.\n"
	"Most code of the hash-algorithms is copyrighted by these people.");

static KCmdLineOptions options[] =
{
	{ "md5",	"calculate MD5 on \"file\"",			0 },
	{ "crc32",	"calculate CRC32 on \"file\"",			0 },
	{ "sha1",	"calculate SHA1 on \"file\"",			0 },
	{ "rmd160",	"calculate RIPE-MD160 on \"file\"",		0 },
	{ "tiger",	"calculate TIGER on \"file\"",			0 },
	{ "docked",	"start docked into system-tray and minimized",	0 },
	{ "skip-self-test", "don't make a self-test on startup",	0 },
	{ "+[file]",	"calculate sum on this file",			0 },
	{ 0, 0, 0 }
};

int main(int argc, char *argv[])
{
	KAboutData *aboutData = new KAboutData( "calcchecksum", "CalcChecksum",
		VERSION, description, KAboutData::License_Custom,
		"Copyright (C) 2002, 2003, 2004  Michael Buesch", 0,
		PROJECT_HOMEPAGE, "mbuesch@freenet.de");
	aboutData->setLicenseText(calcChecksumLicense);
	aboutData->addAuthor("Michael Buesch",0, "mbuesch@freenet.de");
	KCmdLineArgs::init( argc, argv, aboutData );
	KCmdLineArgs::addCmdLineOptions( options );

	UniqueApp::addCmdLineOptions();
	UniqueApp a;

	int ret = a.exec();
	delete aboutData;
	return ret;
}
