/***************************************************************************
 *                                                                         *
 *   copyright (C) 2002, 2003, 2004 by Michael Buesch                      *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   Copyright (C) 2001 Nikos Mavroyanopoulos                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#ifndef MD4_H
#define MD4_H

#include "globalstuff.h"

#include <string>
using std::string;

#define MD4_HASHLEN_BYTE	(128 / 8)

class MD4
{
	struct MD4Context
	{
		uint32_t buf[4];
		uint32_t bits[2];
		unsigned char in[64];
	};

public: 
	MD4() {}
	virtual ~MD4() {}
	static bool selfTest();

	string calcMd4(const string &buf);
	string calcMd4(const string &filename, int *commSocket);

protected:
	void MD4Init(struct MD4Context *context);
	void MD4Update(struct MD4Context *context,
		       unsigned char const *buf, unsigned len);
	void MD4Final(struct MD4Context *context,
		      unsigned char *digest);
	void MD4Transform(uint32_t buf[4], uint32_t const in[16]);
#ifdef BIG_ENDIAN_HOST
	void byteReverse(unsigned char *buf, unsigned longs);
#endif
};

#endif
