/***************************************************************************
 *                                                                         *
 *   copyright (C) 2003, 2004 by Michael Buesch                            *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#ifndef NOTBLOCKINGCALLS_H
#define NOTBLOCKINGCALLS_H

#include <qthread.h>
#include <qfile.h>

#include <string>
using std::string;


enum checksums
{
	nothing = 0,
	md,
	crc,
	sha,
	rmd,
	tiger,
	haval
};

/** This class provides non-blocking calls to the hash algorithms */
class NotBlockingCalls : protected QThread
{
public:
	NotBlockingCalls(const int *commSocket);
	virtual ~NotBlockingCalls() {}

	/** start calculating checksum on string (function returns immediately) */
	void calcCs(const QString &str, checksums algo, int bit, int passes = 0);
	/** start calculating checksum on file (function returns immediately) */
	void calcCs(const QFile *file, checksums algo, int bit, int passes = 0);
	/** terminate the running thread */
	bool termThis();

protected:
	void run();
	/** Return calculated checksum "ret" to parent.
	  * Note: "ret" will become modified!
	  */
	void retCs(string &ret);
};

#endif
