/***************************************************************************
 *                                                                         *
 *   copyright (C) 2003 by Michael Buesch                                  *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/


#include "outputwndimpl.h"
#include "comparewndimpl.h"
#include "err.h"

#include <qclipboard.h>
#include <qapplication.h>
#include <qmessagebox.h>
#include <qfile.h>

#include <klocale.h>
#include <kfiledialog.h>


OutputWndImpl::OutputWndImpl(bool showCompareButton, led_stat showLED,
			     QWidget *parent, const char  *name,
			     WFlags f)
 : QVBox(parent, name, f)
{
	title = new QLabel(this);
	if (showLED != led_dont_show) {
		QColor ledColor;
		switch (showLED) {
		case led_green:
			ledColor.setRgb(0, 255, 0);
			break;
		case led_yellow:
			ledColor.setRgb(255, 255, 0);
			break;
		case led_red:
			ledColor.setRgb(255, 0, 0);
			break;
		default:
			BUG();
		}
		statLED = new KLed(ledColor, this);
		statLED->on();
	} else {
		statLED = 0;
	}
	out = new QTextEdit(this);
	hbox2 = new QHBox(this);
	copyButton = new QPushButton(i18n("copy to clipboard"), hbox2);
	saveButton = new QPushButton(i18n("save to file"), hbox2);
	hbox1 = new QHBox(this);
	if (showCompareButton) {
		compButton = new QPushButton(i18n("compare"), hbox1);
		connect(compButton, SIGNAL(clicked()), this, SLOT(compButton_slot()));
	} else {
		compButton = 0;
	}
	closeButton = new QPushButton(i18n("close"), hbox1);

	setSpacing(10);
	setMargin(10);
	hbox1->setSpacing(10);
	hbox2->setSpacing(10);

	setCaption(i18n("CalcChecksum results"));
	title->setText(i18n("Results:"));
	title->setAlignment(Qt::AlignHCenter);

	out->setReadOnly(true);
	out->setWordWrap(QTextEdit::NoWrap);
	QFont cf = out->currentFont();
	cf.setFixedPitch(true);
	out->setCurrentFont(cf);

	connect(closeButton, SIGNAL(clicked()),
		this, SLOT(close()));
	connect(copyButton, SIGNAL(clicked()),
		this, SLOT(copyButton_slot()));
	connect(saveButton, SIGNAL(clicked()),
		this, SLOT(saveButton_slot()));
}

OutputWndImpl::~OutputWndImpl()
{
}

void OutputWndImpl::copyButton_slot()
{
	QClipboard *cb = QApplication::clipboard();
	cb->setText(out->text());
}

void OutputWndImpl::compButton_slot()
{
	int paraFrom = 0, indexFrom = 0, paraTo = 0, indexTo = 0;

	// check which checksum is selected
	if (!out->hasSelectedText()) {
		// if there is only one cs, take that one
		if (out->lines() == 1) {
			paraFrom = -1;
		} else {
			QMessageBox::information(this, i18n("Please select one hash"),
						 i18n("Please first select the hash, you want "
						      "to compare another hash with,\nby selecting "
						      "at least one character in the line of the "
						      "hash you want to compare."),
						 QMessageBox::Ok, 0, 0);
			return;
		}
	}
	if (paraFrom == -1) {
		paraFrom = 0;
	} else {
		out->getSelection(&paraFrom, &indexFrom, &paraTo, &indexTo);
	}
	QString selLine(out->text(paraFrom));
	selLine.remove(' '); // blank space
	selLine.remove('	'); // tab
	selLine.remove('\r');
	selLine.remove('\n');
	int colon = selLine.find(':');
	if (colon != -1)
		selLine.remove(0, colon + 1);

	CompareWndImpl cw(selLine, this);
	cw.exec();
}

void OutputWndImpl::closeEvent(QCloseEvent *e)
{
	e->accept();
	delete this;
}

void OutputWndImpl::saveButton_slot()
{
	QString fn(KFileDialog::getSaveFileName(QString::null,
						i18n("*|Text-file"),
						this));
	if (fn == "")
		return;
	QFile fd(fn);
	fd.open(IO_ReadWrite);
	fd.writeBlock(out->text().latin1(), out->text().length());
	fd.close();
}
