/***************************************************************************
 *                                                                         *
 *   copyright (C) 2003 by Michael Buesch                                  *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/


#ifndef OUTPUTWNDIMPL_H
#define OUTPUTWNDIMPL_H

#include <qhbox.h>
#include <qvbox.h>
#include <qtextedit.h>
#include <qpushbutton.h>
#include <qlabel.h>

#include <kled.h>


class OutputWndImpl : public QVBox  {
	Q_OBJECT

public:
	enum led_stat
	{
		led_dont_show = 0,
		led_green,
		led_yellow,
		led_red
	};

	OutputWndImpl(bool showCompareButton, led_stat showLED,
		      QWidget *parent = 0, const char  *name = 0,
		      WFlags f = 0);
	~OutputWndImpl();

	/** set output-text */
	void setOutput(QString t)
			{ out->setText(t); }
	/** get output-text */
	QString getOutput()
			{ return out->text(); }

protected:
	QLabel *title;
	QTextEdit *out;
	QPushButton *copyButton;
	QPushButton *compButton;
	QPushButton *closeButton;
	QPushButton *saveButton;
	QHBox *hbox1;
	QHBox *hbox2;
	KLed *statLED;

protected:
	void closeEvent(QCloseEvent *e);

protected slots:
	/** copy button clicked */
	void copyButton_slot();
	/** comp button clicked */
	void compButton_slot();
	/** save to file button clicked */
	void saveButton_slot();
};

#endif
