/***************************************************************************
 *                                                                         *
 *   copyright (C) 2004 by Michael Buesch                                  *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#include "selftest.h"
#include "crc32.h"
#include "haval.h"
#include "md4.h"
#include "md5.h"
#include "rmd160.h"
#include "sha1.h"
#include "sha256.h"
#include "sha512.h"
#include "tiger.h"
#include "globalstuff.h"
#include "err.h"

#include <kmessagebox.h>

#include <iostream>

using std::cerr;
using std::endl;


void SelfTest::doSelfTest()
{
	printDebug("running self-test...");

	if (unlikely(!Crc32::selfTest()))
		failed("CRC32");
	if (unlikely(!Haval::selfTest()))
		failed("HAVAL");
	if (unlikely(!MD4::selfTest()))
		failed("MD4");
	if (unlikely(!Md5::selfTest()))
		failed("MD5");
	if (unlikely(!Rmd160::selfTest()))
		failed("RMD160");
	if (unlikely(!Sha1::selfTest()))
		failed("SHA1");
	if (unlikely(!Sha256::selfTest()))
		failed("SHA256");
	if (unlikely(!Sha512::selfTest()))
		failed("SHA384/512");
	if (unlikely(!Tiger::selfTest()))
		failed("TIGER");

	printDebug("self-test done.");
}

void SelfTest::failed(const char *algo)
{
	QString msg("CalcChecksum FATAL ERROR:\n"
		    "Self-test for algorithm \"");
	msg += algo;
	msg += "\" failed!\n\n";
	msg += "It's likely to be either a CalcChecksum BUG or "
	       "bad hardware in your machine. Please contact the "
	       "maintainer of CalcChecksum for this issue.";
	cerr << "\n\n\n" << msg.latin1() << endl;
	KMessageBox::error(0, msg, "CalcChecksum FATAL ERROR");
	exit(21);
}
