/***************************************************************************
 *                                                                         *
 *   copyright (C) 2002, 2003, 2004 by Michael Buesch                      *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   sha1.c - SHA1 hash function                                           *
 *	Copyright (C) 1998, 2001, 2002 Free Software Foundation, Inc.      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#ifndef SHA1_H
#define SHA1_H

#include "globalstuff.h"

#include <string>
using std::string;

#define SHA1_HASHLEN_BYTE	(160 / 8)

class Sha1
{
	struct SHA1_CONTEXT
	{
		uint32_t	h0,h1,h2,h3,h4;
		uint32_t	nblocks;
		byte		buf[64];
		int		count;
	};

public:
	Sha1();
	virtual ~Sha1();
	static bool selfTest();

	string calcSha1(const string &buf);
	string calcSha1(const string &filename, int *commSocket);

protected:
	void burn_stack(int bytes);
	void sha1_init();
	void transform(const byte *data);
	void sha1_write(const byte *inbuf, size_t inlen);
	byte * sha1_final();

protected:
	SHA1_CONTEXT *context;
};

#endif
