/***************************************************************************
 *                                                                         *
 *   copyright (C) 2002, 2003, 2004 by Michael Buesch                      *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   nettle, low-level cryptographics library                              *
 *   Copyright (C) 2001 Niels Mller                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#ifndef SHA256_H
#define SHA256_H

#include "globalstuff.h"

#include <string>
using std::string;

#define SHA256_DIGEST_SIZE 32
#define SHA256_DATA_SIZE 64
/* Digest is kept internally as 8 32-bit words. */
#define _SHA256_DIGEST_LENGTH 8

class Sha256
{
	struct sha256_ctx
	{
		uint32_t state[_SHA256_DIGEST_LENGTH];	/* State variables */
		uint32_t count_low, count_high;		/* 64-bit block count */
		byte block[SHA256_DATA_SIZE];		/* SHA256 data buffer */
		unsigned int index;			/* index into buffer */
	};

public: 
	Sha256() {}
	virtual ~Sha256() {}
	static bool selfTest();

	string calcSha256(const string &buf);
	string calcSha256(const string &filename, int *commSocket);

protected:
	void sha256_init(struct sha256_ctx *ctx);
	void sha256_update(struct sha256_ctx *ctx, const byte *data, unsigned length);
	void sha256_final(struct sha256_ctx *ctx);
	void sha256_digest(const struct sha256_ctx *ctx, byte *s);
	void sha256_block(struct sha256_ctx *ctx, const byte *block);
	void sha256_transform(uint32_t *state, uint32_t *data);
};

#endif
