/***************************************************************************
 *                                                                         *
 *   copyright (C) 2003, 2004 by Michael Buesch                            *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   SHA-512 code by Jean-Luc Cooke <jlcooke@certainkey.com>               *
 *   Copyright (c) Jean-Luc Cooke <jlcooke@certainkey.com>                 *
 *   Copyright (c) Andrew McDonald <andrew@mcdonald.org.uk>                *
 *   Copyright (c) 2003 Kyle McMartin <kyle@debian.org>                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#ifndef SHA512_H
#define SHA512_H

#include "globalstuff.h"

#include <stdint.h>
#include <string>
using std::string;


/** SHA512 and SHA384 hash algorithms */
class Sha512
{
	struct sha512_ctx
	{
		uint64_t state[8];
		uint32_t count[4];
		uint8_t buf[128];
	};

public: 
	Sha512() {}
	virtual ~Sha512() {}
	static bool selfTest();

	string calcSha384(const string &buf);
	string calcSha384(const string &filename, int *commSocket);

	string calcSha512(const string &buf);
	string calcSha512(const string &filename, int *commSocket);

protected:
	uint64_t Ch(uint64_t x, uint64_t y, uint64_t z)
		{ return ((x & y) ^ (~x & z)); }
	uint64_t Maj(uint64_t x, uint64_t y, uint64_t z)
		{ return ((x & y) ^ (x & z) ^ (y & z)); }
	uint64_t RORuint64_t(uint64_t x, uint64_t y)
		{ return (x >> y) | (x << (64 - y)); }
	inline void LOAD_OP(int I, uint64_t *W, const uint8_t *input);
	inline void BLEND_OP(int I, uint64_t *W);
	void sha512_transform(uint64_t *state, const uint8_t *input);
	void sha512_init(struct sha512_ctx *ctx);
	void sha384_init(struct sha512_ctx *ctx);
	void sha512_update(struct sha512_ctx *ctx, const uint8_t *data, unsigned int len);
	void sha512_final(struct sha512_ctx *ctx, uint8_t *hash);
	void sha384_final(struct sha512_ctx *ctx, uint8_t *hash);
	bool sha384_selfTest();
	bool sha512_selfTest();
};

#endif
