/***************************************************************************
 *                                                                         *
 *   copyright (C) 2002-2003 by Michael Buesch                             *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/


#include "threadcomm.h"


ThreadComm::ThreadComm()
{
	if(socketpair(AF_LOCAL, SOCK_STREAM, 0, sock)){
		ex = 1;
		throw ex;
		return;
	}
	buff = new char[READ_BUFF_SIZE];
	notifier = 0;
	isHost = true;
	initNotifier(sock[1]);
}

ThreadComm::ThreadComm(const int *otherEnd, bool duplex)
{
	notifier = 0;
	buff = 0;
	isHost = false;
	sock[0] = otherEnd[1];
	sock[1] = otherEnd[0];
	if(duplex){
		initNotifier(sock[1]);
		buff = new char[READ_BUFF_SIZE];
	}
}

ThreadComm::~ThreadComm()
{
	if(notifier){ // is client with duplex-conn?
		delete notifier;
		notifier = 0;
		delete buff;
		buff = 0;
	}
	if(isHost){
		close(sock[0]);
		close(sock[1]);
	}
}

void ThreadComm::initNotifier(int socket)
{
	notifier = new QSocketNotifier(socket, QSocketNotifier::Read);
	if(!notifier){
		ex = 2;
		throw ex;
		return;
	}
	connect(notifier, SIGNAL(activated(int)), this, SLOT(handleSockRequest_slot(int)));
}

void ThreadComm::handleSockRequest_slot(int socket)
{
	string received;	// received data
	ssize_t rd;		// bytes read
	do {			// read until socket-buffer is empty
		rd = read(socket, buff, READ_BUFF_SIZE);
		received.append(buff, rd);
	} while (rd == READ_BUFF_SIZE);

	size_t i = 0, len = received.length(), lastAt = 0;
	string line;
	for (; i < len; ++i){	// split received string into lines and emit signal for every line
		if (received[i] == REQ_EOL) {
			line = received.substr(lastAt, i - lastAt);
			lastAt = i + 1;
			emit lineAvailable_signal(&line);
		}
	}
}
