/***************************************************************************
 *                                                                         *
 *   copyright (C) 2002-2003 by Michael Buesch                             *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/


#ifndef THREADCOMM_H
#define THREADCOMM_H

/** ThreadComm v20030831
  * linebased fast communication between threads.
  * Duplex-communication is not fully debugged yet,
  * but CalcChecksum doesn't use duplex, so this is not a problem.
  */

#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>

#include <qsocketnotifier.h>

#include <string>
using std::string;

#define READ_BUFF_SIZE 512
#define REQ_EOL '\n' // end of line


class ThreadComm : public QObject{
	Q_OBJECT
public:
	/** create communication-host */
	ThreadComm();
	/** create communication-client */
	ThreadComm(const int *otherEnd, bool duplex = false);
	~ThreadComm();
	/** get already created socket (int array[2]) */
	const int* getSock()
			{ return sock; }
	/** send data to other thread */
	void send(const string *data)
			{ write(sock[1], data->c_str(), data->length()); }

protected:
	/** full-duplex communication-socket */
	int sock[2];
	/** notifier for socket */
	QSocketNotifier *notifier;
	/** this is the connection-initiating host */
	bool isHost;
	/** tmp-buffer for receiving data */
	char *buff;
	/** exception */
	int ex;
protected slots:
	/** handle a request from socket (from other thread) */
	void handleSockRequest_slot(int socket);
protected:
	/** initialize socketNotifier */
	void initNotifier(int socket);
signals:
	/** one line of new data is available from other thread */
	void lineAvailable_signal(const string *line);
};

#endif
