/***************************************************************************
 *                                                                         *
 *   copyright (C) 2003, 2004 by Michael Buesch                            *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#include "uniqueapp.h"
#include "err.h"
#include "selftest.h"


UniqueApp::UniqueApp(bool allowStyles, bool GUIenabled)
 : KUniqueApplication(allowStyles, GUIenabled)
{
	initialInstance = true;
}

UniqueApp::~UniqueApp()
{
	delete calcchecksum;
}

void UniqueApp::runSelfTest()
{
	SelfTest st;
	st.doSelfTest();
}

int UniqueApp::newInstance()
{
	KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
	if (initialInstance) {
		initialInstance = false;
		if (args->isSet("skip-self-test")) {
			printInfo("Skipping self-test.");
		} else {
			runSelfTest();
		}
		calcchecksum = new CalcChecksum(args);
		if (!calcchecksum) {
			printError("(calcchecksum = new CalcChecksum(args)) == 0\n"
				   "Out of Memory!");
			exit(1);
		}
		setMainWidget(calcchecksum);
		if (!args->isSet("docked"))
			calcchecksum->show();
	} else {
		/* the user has started a new instance of CalcChecksum.
		 * No new instance will be initialized, but the old one will get informed
		 * and args will be transmitted to it
		 */
		printInfo("Already running! Switching to old instance.");
		calcchecksum->newProcCalc(args);
	}
	return 0;
}
