%define name calcchecksum
%define version 1.5
%define release 0

Summary: Checksum (Hash) calculator
Name: %{name}
Version: %{version}
Release: %{release}
Copyright: GPL
Vendor: Michael Buesch <mbuesch@freenet.de>
Url: http://calcchecksum.sourceforge.net
Packager: Michael Buesch <mbuesch@freenet.de>
Group: Office
Source: %{name}-%{version}.tar.bz2
BuildRoot: %{_tmppath}/%{name}-%{version}

%description
CalcChecksum is a tool for calculating MD5, MD4, CRC32, SHA1 (SHA160), SHA256, RIPE-MD-160, TIGER, HAVAL (128, 160, 192, 224, 256 with 3, 4 or 5 passes) on files, text-strings or hash-lists generated by md5sum or sha1sum.

%prep
%setup
./configure --prefix=/usr

%build
# Setup for parallel builds
numprocs=`egrep -c ^cpu[0-9]+ /proc/stat || :`
if [ "$numprocs" = "0" ]; then
	numprocs=1
fi

make -j$numprocs

%install
make install DESTDIR=$RPM_BUILD_ROOT

cd $RPM_BUILD_ROOT
find . -type d | sed '1,2d;s,^\.,\%attr(-\,root\,root) \%dir ,' > /var/tmp/file.list.%{name}
find . -type f | sed 's,^\.,\%attr(-\,root\,root) ,' >>  /var/tmp/file.list.%{name}
find . -type l | sed 's,^\.,\%attr(-\,root\,root) ,' >>  /var/tmp/file.list.%{name}

%clean
rm -rf $RPM_BUILD_ROOT/*
rm -rf $RPM_BUILD_DIR/%{name}-%{version}
rm -rf /var/tmp/file.list.%{name}

%files -f /var/tmp/file.list.%{name}
%doc README COPYING COPYING.LIB AUTHORS BUGS TODO ChangeLog VERSION
