#include "calendar.h"
#include "gui_al.h"
#include "settings.h"
#include "gui_io.h"
#include <gtk/gtk.h>
#include "srch_pane.h"
#include "second.h"
#include "search.h"
#include "journal.h"

const char *elog_tab_cal_term = NULL;

char **elog_tab_cal_results = NULL;
int elog_tab_cal_cur = 0;


void _elog_tab_cal_res(void *p)
{
	struct elog_srch_result *res = (struct elog_srch_result *) p;

	if (elog_tab_cal_cur >= 128)
		return;

	elog_sp_cat(&(elog_tab_cal_results[elog_tab_cal_cur]),
		    res->fileName, NULL);
	++elog_tab_cal_cur;

	elog_gui_al_lock();
	elog_srch_pane_add_item(res->name, elog_tab_cal_cur - 1);
	elog_status_progress_pulse();
	elog_gui_al_unlock();
}

int _elog_tab_cal_do_srch(void *p)
{
	if (elog_tab_cal_results) {
		int c;
		for (c = 0; elog_tab_cal_results[c]; ++c)
			free(elog_tab_cal_results[c]);

		free(elog_tab_cal_results);
	}
	elog_tab_cal_results =
	    malloc((sizeof *elog_tab_cal_results) * 128);
	elog_tab_cal_cur = 0;

	elog_gui_al_lock();
	struct cal_date *date = elog_gui_al_calendarDate(NULL);
	elog_gui_al_unlock();

	char *month;
	char *year;
	month = elog_sp_shortToString(date->month);
	year = elog_sp_shortToString(date->year);
	char *path = elog_journ_current()->settings->path;
	char *dir;
	elog_sp_cat(&dir, path, "/", year, "/", month, NULL);


	elog_gui_al_lock();
	elog_srch_pane_clear();
	elog_gui_al_unlock();

	char *term = elog_sp_strReplace(elog_tab_cal_term, " ", "+");
	elog_srch_search(dir, term, _elog_tab_cal_res);
	elog_tab_cal_results[elog_tab_cal_cur] = NULL;

	elog_gui_al_lock();
	elog_status_progress_set(0.0);
	elog_gui_al_unlock();

	free(month);
	free(year);
	free(date);
	return 0;
}

int elog_tab_cal_srch()
{
	const char *term = gtk_entry_get_text(GTK_ENTRY(_menu_srch_entry));
	if (term) {
		if (strlen(term) > 0) {
			 elog_gui_al_lock();
			 gtk_widget_show(_res_srch_window);
			 elog_gui_al_unlock();
		} else {
			 elog_gui_al_lock();
			 gtk_widget_hide(_res_srch_window);
			 elog_gui_al_unlock();
		}
	} else {
		 elog_gui_al_lock();
		 gtk_widget_hide(_res_srch_window);
		 elog_gui_al_unlock();
	}


	elog_tab_cal_term = term;
	if (term)
		if (strlen(term) > 0)
			elog_scnd_run(_elog_tab_cal_do_srch, "cal_srch");
	return 0;
}

int elog_tab_cal_res(const char *name, int n)
{
	if (n < 128) {
		elog_gui_io_dispLocation(elog_tab_cal_results[n]);
		//elog_gui_io_open(elog_tab_cal_results[n], NULL);
	}
	else
		return 1;
	return 0;
}

int elog_tab_cal_cut()
{
	char *day = elog_cal_getDay();
	if (!day)
		return 1;

	char *clip;
	elog_sp_cat(&clip, "LOCATION://", day, NULL);

	elog_gui_al_clipBoard(clip);
	free(clip);
	free(day);
	return 0;
}

int elog_tab_cal_copy()
{
	return elog_tab_cal_cut();
}

int elog_tab_cal_paste()
{
	return 0;		//blank function.  Placeholder.
}

int elog_tab_cal_delete()
{
	return 0;		//blank function.  Placeholder!
}

char *elog_cal_getDay()
{
	GtkTreeModel *model = (GtkTreeModel *) _mainDayList;
	GtkTreePath *tree_path;
	GtkTreeViewColumn *trash;
	gtk_tree_view_get_cursor(GTK_TREE_VIEW(_mainDayView), &tree_path,
				 &trash);
	if (!tree_path)
		return NULL;

	char *str_path = (char *) gtk_tree_path_to_string(tree_path);
	gtk_tree_path_free(tree_path);
	GtkTreeIter iter;
	gtk_tree_model_get_iter_from_string(model, &iter, str_path);
	free(str_path);

	char *title;
	char *path;
	gtk_tree_model_get(model, &iter, 0, &title, 1, &path, -1);
	free(title);
	return path;
}
gboolean    _day_list_foreach		      (GtkTreeModel *model,
                                             GtkTreePath *path,
                                             GtkTreeIter *iter,
                                             gpointer data)
{
	char *p;
	char *check = (char *)data;
	gtk_tree_model_get(model, iter, 1, &p, -1);
	
	if (strcmp(p, check) == 0) {
		free(p);
		gtk_tree_view_set_cursor(GTK_TREE_VIEW(_mainDayView),
								path, NULL, FALSE);
		return TRUE;
	}
	free(p);
	return FALSE;                                   	
}
int elog_cal_highlightEntry(const char *fileName)
{
	gtk_tree_model_foreach(GTK_TREE_MODEL(_mainDayList),
							_day_list_foreach, (gpointer) fileName);
	return 0;
}


void on_cal_day_selected(GtkCalendar * calendar, gpointer user_data)
{

	struct cal_date *nue = elog_gui_al_calendarDate(NULL);
	char *year = elog_sp_shortToString(nue->year);
	char *month = elog_sp_shortToString(nue->month);
	char *day = elog_sp_shortToString(nue->day);

	char *path;
	elog_sp_cat(&path, elog_set_path(NULL), "/", year, "/", month, "/",
		    day, "/", NULL);

	elog_gui_io_dispDay(path);

	free(path);
	free(year);
	free(month);
	free(day);
	free(nue);
}



void on_cal_month_changed(GtkCalendar * calendar, gpointer user_data)
{
//	 elog_gui_al_setLockMode(ELOG_GUI_AL_LOCK_CALLBACK);
	 elog_gui_io_markCalendar();
	 elog_tab_cal_srch();
//	 elog_gui_al_setLockMode(ELOG_GUI_AL_LOCKED);
}

void on_dayList_activate(GtkTreeView * treeview,
			 GtkTreePath * arg1,
			 GtkTreeViewColumn * arg2, gpointer user_data)
{
	char *path = elog_cal_getDay();
	struct cal_date *date = elog_gui_al_calendarDate(NULL);
	elog_gui_io_open(path, date);
	free(date);
	elog_gui_al_page(ELOG_GUI_AL_PAGE_EDIT);	//in case it's a non-existant file.
}
