/* AUTHOR: Chris <MA_D> Hilton
 * LICENSE:  GPL Version 2
 *
 */
 
 /* Why me?
  * This file exists to wrap up typical tab operations for
  * the calendar tab, you'll find similar files for other tabs:
  * search_tab.h and edit.h.  This one is named funny because
  * searching code is in search.h
 */

#ifndef CAL_H
#define CAL_H
#include <gtk/gtk.h>

int elog_tab_cal_srch();
//Pre:
//Post:  This pulls the text from the menubar srch entry
//Then it lists the available entries that meet the search in the current month and day.

int elog_tab_cal_res(const char *name, int n);
//Pre: name is a c string
//Post:  this probably opens the result associated with n.
  
int elog_tab_cal_cut();
//Pre:
//Post:  This will do a cut.  

int elog_tab_cal_copy();
//Pre:
//Post:  This is the same as cut.

int elog_tab_cal_paste();
//Pre:
//Post:  This does nothing.

int elog_tab_cal_delete();
//Pre:
//Post:  This will move the current item in the list to
//  the trash.

char *elog_cal_getDay();
//Pre:
//Post:  Returns the filename for the selected day.

/*Accessors/Modifiers*/
int elog_cal_highlightEntry(const char *fileName);
//Pre:  fileName is an str, the gui is made.
//Post:  highlights this entry on the entry selector.

/**********************************/

/********** CALLBACKS ************/
void
on_cal_day_selected                    (GtkCalendar     *calendar,
                                        gpointer         user_data);

void
on_cal_day_selected_double_click       (GtkCalendar     *calendar,
                                        gpointer         user_data);

void
on_cal_month_changed                   (GtkCalendar     *calendar,
                                        gpointer         user_data);

void on_dayList_activate               (GtkTreeView *treeview,
					GtkTreePath *arg1,
					GtkTreeViewColumn *arg2,
					gpointer user_data);


#endif
