#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "crypt.h"
#include "gui_al.h"
#include "gui_io.h"
#include "error.h"
#include "about.h"
#include "fileChooser.h"
#include "months.h"
#include "prefDialogue.h"
#include "fileChooser.h"
#include "structure.h"
#include "tabs.h" 
#include <gdk/gdkkeysyms.h>
#include "journal.h"
#include "calendar.h"
#include "second.h"
#include "cryptography.h"


gboolean on_main_pane_set(GtkWidget * widget,
			  GdkEventButton * event, gpointer user_data)
{
	elog_set_set_int("tree_divider", elog_gui_al_pane(-1));

	elog_gui_al_setImage(elog_gui_al_mood(-1),
			     elog_gui_al_weather(-1));

	return FALSE;
}

int __srchWait(void *p)
{
	char *txt = (char *) p;
	usleep(205000);
	elog_gui_al_lock();
	const char *txt2 =
	    (const char *) gtk_entry_get_text(GTK_ENTRY(_menu_srch_entry));
	if (strcmp(txt, txt2) == 0) {
		 elog_gui_al_unlock();
		elog_tab_act_search();
	} else
		 elog_gui_al_unlock();
	free(txt);
	return 0;
}

gboolean on_srch_bar_key_release(GtkWidget * widget,
				 GdkEventKey * event, gpointer user_data)
{
	elog_gui_al_setLockMode(ELOG_GUI_AL_LOCK_CALLBACK);

	char *txt;
	elog_sp_cat(&txt,
		    (char *)
		    gtk_entry_get_text(GTK_ENTRY(_menu_srch_entry)), NULL);
	elog_scnd_run_arg(__srchWait, "key wait", txt);

	elog_gui_al_setLockMode(ELOG_GUI_AL_LOCKED);
	return FALSE;
}

gboolean on_srch_bar_btn_release(GtkEntry * entry,
				 gchar * arg1, gpointer user_data)
{
	//gtk is screwy and stupid about this.
	elog_gui_al_setLockMode(ELOG_GUI_AL_LOCK_CALLBACK);
	elog_tab_act_search();
	elog_gui_al_setLockMode(ELOG_GUI_AL_LOCKED);
	return FALSE;
}


void on_save1_activate(GtkMenuItem * menuitem, gpointer user_data)
{
	elog_gui_al_setLockMode(ELOG_GUI_AL_LOCK_CALLBACK);
	printf("saving\n");
	elog_gui_io_save();
	elog_gui_al_setLockMode(ELOG_GUI_AL_LOCKED);
}

void on_undo_activate(GtkMenuItem * menuitem, gpointer user_data)
{
	elog_gui_al_setLockMode(ELOG_GUI_AL_LOCK_CALLBACK);
	elog_gui_io_undo();
	elog_gui_al_setLockMode(ELOG_GUI_AL_LOCKED);
}

void on_redo_activate(GtkMenuItem * menuitem, gpointer user_data)
{
	elog_gui_al_setLockMode(ELOG_GUI_AL_LOCK_CALLBACK);
	elog_gui_io_redo();
	elog_gui_al_setLockMode(ELOG_GUI_AL_LOCKED);
}



void on_window_main_resize(GtkContainer * container, gpointer user_data)
{
	int width, height;
	gtk_window_get_size(GTK_WINDOW(container), &width, &height);
	elog_set_mainHeight(&height);
	elog_set_mainWidth(&width);
}


void on_quit1_activate(GtkMenuItem * menuitem, gpointer user_data)
{
	gtk_main_quit();
	gtk_main_quit();
	gtk_main_quit();	//is 6 enough?! Gee I hope so ;).
	gtk_main_quit();
	gtk_main_quit();
	gtk_main_quit();
}


void on_cut1_activate(GtkMenuItem * menuitem, gpointer user_data)
{
	elog_gui_al_setLockMode(ELOG_GUI_AL_LOCK_CALLBACK);
	elog_tab_act_cut();
	elog_gui_al_setLockMode(ELOG_GUI_AL_LOCKED);
}


void on_copy1_activate(GtkMenuItem * menuitem, gpointer user_data)
{
	elog_gui_al_setLockMode(ELOG_GUI_AL_LOCK_CALLBACK);
	elog_tab_act_copy();
	elog_gui_al_setLockMode(ELOG_GUI_AL_LOCKED);
}


void on_paste1_activate(GtkMenuItem * menuitem, gpointer user_data)
{
	elog_gui_al_setLockMode(ELOG_GUI_AL_LOCK_CALLBACK);
	elog_tab_act_paste();
	elog_gui_al_setLockMode(ELOG_GUI_AL_LOCKED);
}


void on_delete1_activate(GtkMenuItem * menuitem, gpointer user_data)
{

}


void on_about1_activate(GtkMenuItem * menuitem, gpointer user_data)
{
	create_about();
}

void on_help_activate(GtkMenuItem * menuitem, gpointer user_data)
{
	elog_gui_io_open_manual();
}

void
on_text_notebook_switch_page(GtkNotebook * notebook,
			     GtkNotebookPage * page,
			     guint page_num, gpointer user_data)
{
	elog_gui_al_setLockMode(ELOG_GUI_AL_LOCK_CALLBACK);
	elog_tab_set((int) page_num);
	/*  if (page_num == 0)
	   {
	   elog_gui_io_save();
	   elog_gui_io_dispDay(NULL);
	   }
	   else if (page_num != 1)
	   elog_gui_io_save(); */
	elog_gui_al_setLockMode(ELOG_GUI_AL_LOCKED);
}


void
on_treeview1_row_activated(GtkTreeView * treeview,
			   GtkTreePath * path,
			   GtkTreeViewColumn * column, gpointer user_data)
{
	//this is the callback for the search result list!      

	GtkTreeModel *model = gtk_tree_view_get_model(treeview);
	GtkTreeIter iter;
	gtk_tree_model_get_iter(model, &iter, path);
	char *title;
	char *pathstr;
	gtk_tree_model_get(model, &iter, 0, &title, 4, &pathstr, -1);
	elog_gui_al_setLockMode(ELOG_GUI_AL_LOCK_CALLBACK);
	elog_gui_io_open(pathstr, NULL);
	elog_gui_al_setLockMode(ELOG_GUI_AL_LOCKED);
}

void on_mood_changed(GtkComboBox * widget, gpointer user_data)
{

	if (elog_gui_io_lock())
		return;
	if (elog_gui_al_weather(-1) >= 0)
		elog_gui_al_setImage(elog_gui_al_mood(-1),
				     elog_gui_al_weather(-1));

}

void on_weather_changed(GtkComboBox * widget, gpointer user_data)
{

	if (elog_gui_io_lock())
		return;
	if (elog_gui_al_mood(-1) >= 0)
		elog_gui_al_setImage(elog_gui_al_mood(-1),
				     elog_gui_al_weather(-1));

}

void on_preferences_activate(GtkMenuItem * menuitem, gpointer user_data)
{
	create_pref_window();

	//gtk_widget_show_all(win);

}



gboolean on_window_main_close(GtkWidget * widget,
			      GdkEvent * event, gpointer user_data)
{

	gtk_main_quit();

	return TRUE;
}




gboolean on_text_tag_click(GtkTextTag * texttag,
			   GObject * arg1,
			   GdkEvent * event,
			   GtkTextIter * arg2, gpointer user_data)
{

	if (event->type == GDK_BUTTON_PRESS) {
		if (((GdkEventButton *) event)->button == 1) {
			char *name;
			g_object_get((gpointer *) texttag, "name",
				     (gchar **) & name, NULL);
			struct elog_xml_doc *doc;
			elog_set_currentFile(NULL, &doc);	//gets current document
			const struct elog_xml_link *lnk =
			    elog_xml_lnk_find(doc, name);
			if (lnk == NULL)
				return FALSE;

			elog_gui_io_fileHandler(lnk->href);

			return TRUE;
		}
		if (((GdkEventButton *) event)->button == 3) {
			view_popup_menu((GtkWidget *) texttag,
					(GdkEventButton *) event,
					user_data);
			return TRUE;
		} else
			return TRUE;
	}
	return FALSE;
}


void on_attch_btn_activate(GtkButton * button, gpointer user_data)
{
	elog_gui_io_save();

	GtkTextBuffer *buffer =
	    gtk_text_view_get_buffer(GTK_TEXT_VIEW(_textBox));
	GtkTextMark *sel1 =
	    gtk_text_buffer_get_mark(GTK_TEXT_BUFFER(buffer), "insert");
	GtkTextMark *sel2 =
	    gtk_text_buffer_get_mark(GTK_TEXT_BUFFER(buffer),
				     "selection_bound");
	GtkTextIter iter1;
	GtkTextIter iter2;
	gtk_text_buffer_get_iter_at_mark(GTK_TEXT_BUFFER(buffer), &iter1,
					 sel1);
	gtk_text_buffer_get_iter_at_mark(GTK_TEXT_BUFFER(buffer), &iter2,
					 sel2);
	guint pos1, pos2;


	pos1 = gtk_text_iter_get_offset(&iter1);


	pos2 = gtk_text_iter_get_offset(&iter2);



	if (pos2 != pos1) {
		elog_wrn_print("Unselect your text first.");
		return;
	}
	//To be written, logic/ui for attaching stuff!
	elog_wrn_print("Sorry, this feature isn't implemented yet.  Stay tuned!");
}


void on_link_btn_activate(GtkButton * button, gpointer user_data)
{
	elog_gui_io_save();

	GtkTextBuffer *buffer =
	    gtk_text_view_get_buffer(GTK_TEXT_VIEW(_textBox));
	GtkTextMark *sel1 =
	    gtk_text_buffer_get_mark(GTK_TEXT_BUFFER(buffer), "insert");
	GtkTextMark *sel2 =
	    gtk_text_buffer_get_mark(GTK_TEXT_BUFFER(buffer),
				     "selection_bound");
	GtkTextIter iter1;
	GtkTextIter iter2;
	gtk_text_buffer_get_iter_at_mark(GTK_TEXT_BUFFER(buffer), &iter1,
					 sel1);
	gtk_text_buffer_get_iter_at_mark(GTK_TEXT_BUFFER(buffer), &iter2,
					 sel2);
	guint pos1, pos2;


	pos1 = gtk_text_iter_get_offset(&iter1);


	pos2 = gtk_text_iter_get_offset(&iter2);



	if (pos2 > pos1) {
		guint pos3 = pos1;
		pos1 = pos2;
		pos2 = pos3;
	}

	if (pos1 != pos2) {
		int *locs = malloc((sizeof *locs) * 2);
		locs[0] = pos1;
		locs[1] = pos2;
		GtkWidget *link = create_link_window(locs);
		gtk_widget_show_all(link);
		gtk_main();
		free(locs);
	}

}



void on_ok_btn_activate(GtkButton * button, gpointer user_data)
{
	struct elog_xml_link *lnk = elog_xml_link_new();

	int *locs = (int *) user_data;
	lnk->start = locs[0];
	int pos1 = locs[0];
	lnk->end = locs[1];
	int pos2 = locs[1];

	//lnk->href = 
	//elog_gui_al_addLink(lnk);     
	if (gtk_expander_get_expanded(GTK_EXPANDER(_expanderLocal)) ==
	    TRUE) {
		char *tmp = elog_gui_al_getTreeSelected();
		elog_sp_cat(&(lnk->href), "local://", tmp, NULL);
		lnk->num =
		    elog_gui_al_textLink((int) pos1, (int) pos2,
					 lnk->href);
		elog_gui_io_addLink(lnk);
		elog_gui_io_addUndoActionPtr(ELOG_GUI_IO_ACTION_LINK, lnk,
					     0);
		printf("Link: %s \n", lnk->href);
	} else if (gtk_expander_get_expanded(GTK_EXPANDER(_expanderFile))
		   == TRUE) {
		char *tmp = (char *)
		    gtk_entry_get_text(GTK_ENTRY
				       (lookup_widget
					(_linkWindow, "localFIle_entry")));
		elog_sp_cat(&(lnk->href), "search://", tmp, NULL);
		lnk->num =
		    elog_gui_al_textLink((int) pos1, (int) pos2,
					 lnk->href);
		elog_gui_io_addLink(lnk);
		elog_gui_io_addUndoActionPtr(ELOG_GUI_IO_ACTION_LINK, lnk,
					     0);
	} else if (gtk_expander_get_expanded(GTK_EXPANDER(_expanderWeb)) ==
		   TRUE) {
		char *tmp = (char *)
		    gtk_entry_get_text(GTK_ENTRY
				       (lookup_widget
					(_linkWindow, "link_entry")));
		elog_sp_cat(&(lnk->href), "http://", tmp, NULL);
		lnk->num =
		    elog_gui_al_textLink((int) pos1, (int) pos2,
					 lnk->href);
		elog_gui_io_addLink(lnk);
		elog_gui_io_addUndoActionPtr(ELOG_GUI_IO_ACTION_LINK, lnk,
					     0);
	} else
		elog_err_print_console
		    ("No link option chosen, bombing out of making a link\n");

	on_cancel_btn_activate(button, user_data);	//closes window and whatnot

}


void on_cancel_btn_activate(GtkButton * button, gpointer user_data)
{

	gtk_widget_destroy(lookup_widget(_linkWindow, "vbox1"));

	gtk_widget_destroy(lookup_widget(_linkWindow, "vbox1"));
	gtk_widget_destroy(lookup_widget(_linkWindow, "main_lbl"));
	gtk_widget_destroy(lookup_widget(_linkWindow, "expand_local"));
	gtk_widget_destroy(lookup_widget(_linkWindow, "scrolledwindow1"));
	gtk_widget_destroy(lookup_widget(_linkWindow, "tree_root"));
	gtk_widget_destroy(lookup_widget(_linkWindow, "lbl_expand1"));
	gtk_widget_destroy(lookup_widget(_linkWindow, "expand_file"));
	gtk_widget_destroy(lookup_widget(_linkWindow, "hbox1"));
	gtk_widget_destroy(lookup_widget(_linkWindow, "localFIle_entry"));

	gtk_widget_destroy(lookup_widget(_linkWindow, "lbl_expand2"));
	gtk_widget_destroy(lookup_widget(_linkWindow, "web_expand"));
	gtk_widget_destroy(lookup_widget(_linkWindow, "vbox2"));
	gtk_widget_destroy(lookup_widget(_linkWindow, "hbox4"));

	gtk_widget_destroy(lookup_widget(_linkWindow, "hbox3"));
	gtk_widget_destroy(lookup_widget(_linkWindow, "hyperlink_lbl"));
	gtk_widget_destroy(lookup_widget(_linkWindow, "link_entry"));
	gtk_widget_destroy(lookup_widget(_linkWindow, "lbl_expand3"));
	gtk_widget_destroy(lookup_widget(_linkWindow, "hbox2"));
	gtk_widget_destroy(lookup_widget(_linkWindow, "ok_btn"));
	gtk_widget_destroy(lookup_widget(_linkWindow, "cancel_btn"));
	gtk_widget_destroy(_linkWindow);
	gtk_main_quit();
}


void fill_tree(GtkWidget * tree, struct elog_io_dir *list,
	       GtkTreeIter * parent, char *parentStr)
{
	GtkTreeIter child, iter;
	int c;
	int j = 0;
	for (c = 0; list->dir[c] != NULL; ++c) {
		if (list->dir[c][0] == '/') {
			const char *tmp = &(list->dir[c][3]);	// --"///"

			char *full;
			elog_sp_cat(&full, parentStr, "/",
				    &(list->dir[c][3]), "/", NULL);
			if (elog_strct_mode_subdir(full) ==
			    ELOG_STRCT_MODE_MONTH)
				tmp =
				    elog_mnth_str(elog_sp_stringToShort
						  (tmp));

			else if (elog_strct_mode_subdir(full) ==
				 ELOG_STRCT_MODE_OTHER) {
				free(full);
				++j;	//this lil bugger took me a half hour to find
				// but at least I updated some old code while doing it.
				continue;
			}

			gtk_tree_store_append(GTK_TREE_STORE(tree), &iter,
					      parent);
			gtk_tree_store_set(GTK_TREE_STORE(tree), &iter, 0,
					   tmp, 1, full, -1);
			fill_tree(tree, list->subDir[j], &iter, full);
			free(full);
			++j;
		} else {
			char *full;
			elog_sp_cat(&full, list->path, list->dir[c], NULL);
			char *partial = elog_sp_strReplace(full,
							   elog_journ_current
							   ()->settings->
							   path,
							   "/");
			struct elog_xml_doc *doc = elog_crypt_open_dry_noTxt(full);
			if (doc != NULL) {	//is the file null or has a blank subjecT?!
				elog_io_close(doc->handle);
				if (doc->subject != NULL) {
					gtk_tree_store_append
					    (GTK_TREE_STORE(tree), &child,
					     parent);
					gtk_tree_store_set(GTK_TREE_STORE
							   (tree), &child,
							   0, doc->subject,
							   1, partial, -1);
				}
				elog_xml_doc_free(doc);
			}
			free(partial);
			free(full);
		}
	}
}


void on_expand_local_activate(GtkExpander * expander, gpointer user_data)
{
	const char *path = elog_set_path(NULL);
	struct elog_io_dir *journ = elog_io_recurseDir(path, path);


	gtk_tree_store_clear(GTK_TREE_STORE(_fileListTree));

	fill_tree(_fileListTree, journ, NULL, "");
	gint x, y;
	gtk_window_get_size(GTK_WINDOW(_linkWindow), &x, &y);
	y = 400;
	gtk_expander_set_expanded(GTK_EXPANDER(_expanderFile), FALSE);
	gtk_expander_set_expanded(GTK_EXPANDER(_expanderWeb), FALSE);
	gtk_window_resize(GTK_WINDOW(_linkWindow), x, y);

	elog_io_dir_free(journ);
}


void on_expand_file_activate(GtkExpander * expander, gpointer user_data)
{
	gtk_expander_set_expanded(GTK_EXPANDER(_expanderLocal), FALSE);
	gtk_expander_set_expanded(GTK_EXPANDER(_expanderWeb), FALSE);
	gint x, y;
	gtk_window_get_size(GTK_WINDOW(_linkWindow), &x, &y);
	y = 180;
	gtk_window_resize(GTK_WINDOW(_linkWindow), x, y);
}


void on_web_expand_activate(GtkExpander * expander, gpointer user_data)
{
	gtk_expander_set_expanded(GTK_EXPANDER(_expanderFile), FALSE);
	gtk_expander_set_expanded(GTK_EXPANDER(_expanderLocal), FALSE);
	gint x, y;
	gtk_window_get_size(GTK_WINDOW(_linkWindow), &x, &y);
	y = 180;
	gtk_window_resize(GTK_WINDOW(_linkWindow), x, y);
}


void
on_res_srch_row_activate(GtkTreeView *treeview, gpointer user_data)
{

	elog_gui_al_setLockMode(ELOG_GUI_AL_LOCK_CALLBACK);
	GtkTreeModel *model = (GtkTreeModel *)
	    gtk_tree_view_get_model(GTK_TREE_VIEW(_res_srch_list));
	GtkTreePath *tree_path;
	GtkTreeViewColumn *trash;
	gtk_tree_view_get_cursor(GTK_TREE_VIEW(_res_srch_list), &tree_path,
				 &trash);

	if (!tree_path)
		return ;

	char *str_path = (char *) gtk_tree_path_to_string(tree_path);

	gtk_tree_path_free(tree_path);
	GtkTreeIter iter;
	gtk_tree_model_get_iter_from_string(model, &iter, str_path);
	free(str_path);
		
	char *title;
	int n;
	gtk_tree_model_get(model, &iter, 0, &title, 1, &n, -1);

	elog_tab_act_res(title, n);
	//gtk_widget_grab_focus(_res_srch_list);

	free(title);
	elog_gui_al_setLockMode(ELOG_GUI_AL_LOCKED);
	return ;
}

gboolean on_res_pane_set(GtkWidget * widget,
			 GdkEventButton * event, gpointer user_data)
{
	elog_gui_al_setLockMode(ELOG_GUI_AL_LOCK_CALLBACK);
	char *name;
	char *n = elog_sp_shortToString(elog_tab_current());
	elog_sp_cat(&name, "SEARCH_DIVIDE_", n, NULL);
	elog_set_set_int(name,
			 gtk_paned_get_position(GTK_PANED
						(_res_srch_pane)));
	free(name);
	free(n);
	elog_gui_al_setLockMode(ELOG_GUI_AL_LOCKED);
	return FALSE;
}
