#include "listen.h"
#include "talk.h"
#include "settings.h"
#include "plugins.h"
#include "export.h"

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>

char *fifo_loc;
char *_exp_loc = NULL;
char *_exp_type = NULL;
int _exp_user = 0;

void __export(char *loc, char *type)
{
	if (loc)
		elog_sp_cat(&_exp_loc, loc, NULL);

	if (type) {
		if (strcmp(type, "html_latex") == 0)
			_exp_type =
			    elog_sp_shortToString
			    (ELOG_EXP_HTML_STYLE_LATEX);
		else {
			_exp_type = type;
			_exp_user = 1;
		}
	}

	if (_exp_type && _exp_loc) {
		char *xml = elog_xml_start("<mesg>", 1024);
		elog_xml_printf(xml, "<mesg>.%s", "<type>",
				ELOG_LSN_TYPE_EXPORT);
		elog_xml_printf(xml, "<mesg>.%s", "<location>", _exp_loc);
		if (_exp_user) {
			elog_xml_printf(xml, "<mesg>.%s", "<user>",
					_exp_type);
			char *type =
			    elog_sp_shortToString(ELOG_EXP_STYLE_USER);
			elog_xml_printf(xml, "<mesg>.%s", "<format>",
					type);
			free(type);
		} else
			elog_xml_printf(xml, "<mesg>.%s", "<format>",
					_exp_type);

		elog_tlk_say(fifo_loc, xml);
		char *fifo_reply;
		elog_sp_cat(&fifo_reply, fifo_loc, "1", NULL);
		int done = 0;
		while (!done) {
			char *msg;
			while (!(msg = elog_lsn_listen(fifo_reply)));

			char *body;
			elog_xml_scanf(msg, "<mesg>.<body>.%s", &body);
			char *print = &(body[1]);
			print[strlen(print) - 1] = '\0';	//removing surrounding pipes
			printf("%s", print);

			free(body);
			body = NULL;
			elog_xml_scanf(msg, "<mesg>.<done>.%s", &body);
			if (body) {
				done = 1;
				free(body);
			}
			free(msg);
		}

		free(fifo_reply);

		printf("\n");
		free(xml);
	}


}


void __spitout()
{
	char *msg;
	elog_tlk_ask(fifo_loc, &msg);
	printf("%s\n", msg);
	free(msg);
}


void __takein()
{
	int i = fgetc(stdin);
	while (i != EOF) {

		char buf[768];
		int c;
		for (c = 0; i != EOF && c < 767; ++c) {
			buf[c] = i;
			i = fgetc(stdin);
		}

		buf[c] = '\0';
		elog_tlk_say(fifo_loc, buf);

	}


}

void __help()
{
	printf("Welcome to eJourn 0.1 Help\n");
	printf("Option				Result\n");
	printf("/*------------------------------------------\n");
	printf("-h				This menu\n");
	printf
	    ("-d				Dump current edit of opened ejourn-gui\n");
	printf
	    ("-e                              Exports to a location following it\n");
	printf
	    ("-t                              Needed by -e, gives the type*\n");

	printf("-----------------------------------------------*/\n");
	printf("The currently accepted types for -t are:\n");
	printf("%s\n", ELOG_EXP_TYPES);
}


int __handleArgs(int argc, char *argv[])
{
	char options[] = "dhe:t:";
	if (argc == 1)
		__takein();
	else {
		int opt;
		do {
			opt = getopt(argc, argv, options);
			switch (opt) {
			case 'd':
				{
					__spitout();
					break;
				}
			case 'h':
				{
					__help();
					break;
				}
			case 'e':
				{
					__export(optarg, NULL);
					break;
				}
			case 't':
				{
					__export(NULL, optarg);
					break;
				}
			}

		} while (opt != -1);
	}
	return 0;
}



int main(int argc, char *argv[])
{
	ELOG_ERROR = malloc(1);
	/*if ((elog_plgn_open("/home/chris/eclipse/workspace/ejourn/modules/plgn_example.so")))
	   printf("Oops, failed to load\n");
	   elog_plgn_call("", "foo");
	   return 0; */

	elog_set_loadSettings(NULL);
	fifo_loc = (char *) elog_set_get_str("FIFO_LOC");
	if (fifo_loc == NULL) {
		char *usr = getenv("USER");
		elog_sp_cat(&fifo_loc, "/tmp/ejourn-", usr, NULL);
	}



	__handleArgs(argc, argv);


	free(fifo_loc);
	return 0;
}
