#ifndef CRYPT_H
#define CRYPT_H

int setBuffer(int buf);
//If buf == 0, does not set the buffer but simply returns it's value
//Otherwise it sets the buffer and returns 0

void encryptFile(const char *fileName);
//Pre: fileName is a valid c string pointing to an existing file.
//Post:  opens the file, encrypts it, and resaves it.
	//The encryption and reading is buffered.  The buffer is set

void encryptText(unsigned char *text, unsigned int len);
//Pre: text must be a valid array of size len
//Post:  encrypts it using set key.

void decryptFile(char *fileName);

void decryptText(unsigned char *text, unsigned int len);

void setEncryptionMethod(char *method);

unsigned char *createKey(char *password, int keyLen);


unsigned char *viewKey();
void setKey(unsigned char *key);
//Neither of these functions allocate memory, so no freeing!

#endif
