#include "journal.h"
#include "login.h"
#include "crypt.h"
#include "xml.h"
#include "simple.h"
#include "settings.h"
#include "cryptography.h"
#include "plugins.h"
#include "error.h"

int elog_crypt_decrypt(unsigned char *data, unsigned int len)
{
	if (!viewKey()) {	//we need to set a key!
		if (create_login_window(ELOG_LGN_MODE_SWITCH))
			return 1;
	}
	decryptText(data, len);

	return 0;
}

int elog_crypt_encrypt(unsigned char *data, unsigned int len)
{
	if (!viewKey()) {	//we need to set a key!
		if (create_login_window(ELOG_LGN_MODE_SWITCH))
			return 1;
	}
	encryptText(data, len);


	return 0;
}

struct elog_xml_doc *elog_crypt_open_dry_noTxt(const char *fileName)
{
	struct elog_xml_doc *doc = elog_xml_open(fileName, 0);
	if (!doc)
		return NULL;


	if (doc->file_info->encType) {
		if (doc->file_info->encType[0] != elog_journ_current()->settings->encryption[0] && doc->file_info->encType[0] == 'A') {	//if, file is encrypted and the journal says no encryption.
			if (create_login_window(ELOG_LGN_MODE_RECOVER)) {	//first try to recover the file
				elog_io_close(doc->handle);
				elog_xml_doc_free(doc);
				return NULL;
			} else {
				elog_set_set_str("encryption_method",
						 "AES");
				if (elog_journ_current()->settings->
				    encryption)
					free(elog_journ_current()->
					     settings->encryption);
				elog_sp_cat(&
					    (elog_journ_current()->
					     settings->encryption), "AES",
					    NULL);
			}
		}
		if (doc->file_info->encType[0] == 'A' && !viewKey()) {
			if (create_login_window(ELOG_LGN_MODE_RECOVER)) {
				elog_io_close(doc->handle);
				elog_xml_doc_free(doc);
				return NULL;
			}
		}
		//If, the file is for encryption and the journal
		//isn't then we'll make this an encrypted journal.
		//If the file is encrypted and there's no key
		//We'll generate one. 
		if (doc->version >= 3)	//backwards compat code.
		{
			 if (doc->file_info->encType) {
				  if (doc->file_info->encType[0] == 'A')
					   if (elog_crypt_decrypt
						   ((unsigned char *) doc->subject,
							doc->lenSubject)) {
							elog_xml_doc_free(doc);
							return NULL;
					   }
			 } 
		} 
	} else if (fileName) {
		 char *msg;
		 elog_sp_cat(&msg, "Entry: ", fileName, " no <encryption_type>,", 
					 " not decrypting", NULL);
		 elog_wrn_print(msg);
		 free(msg);
	}

	return doc;
}

struct elog_xml_doc *elog_crypt_open_dry(const char *fileName)
{
	struct elog_xml_doc *doc = elog_crypt_open_dry_noTxt(fileName);
	if (!doc)
		return NULL;
	unsigned int len;
	unsigned char *dat = elog_io_readRestofFile(doc->handle, &len);
	elog_io_close(doc->handle);
	if (doc->file_info->encType) {
		if (doc->file_info->encType[0] == 'A') {
			if (elog_crypt_decrypt(dat, len)) {
				elog_xml_doc_free(doc);
				free(dat);
				return NULL;
			}
		}
	} else if (elog_journ_current()->settings->encryption[0] == 'A') {
		if (elog_crypt_decrypt(dat, len)) {
			elog_xml_doc_free(doc);
			free(dat);
			return NULL;
		}
	}

	doc->text = elog_sp_toChar(dat, len);

	return doc;
}



int elog_crypt_save_dry(struct elog_crypt_save *save)
{
	unsigned int len = save->len;
	unsigned char *txt = save->txt;
	struct elog_xml_doc *current = save->doc;

	save->doc->lenSubject = strlen(save->doc->subject)+1;

	if (save->enc[0] == 'A') {
		elog_crypt_encrypt(txt, len);
		elog_crypt_encrypt(elog_sp_toUnsignedChar
				   (save->doc->subject,
				    &(save->doc->lenSubject)),
				   save->doc->lenSubject);
	}
	if (current->file_info->encType != NULL)
		free(current->file_info->encType);
	elog_sp_cat(&(current->file_info->encType), save->enc, NULL);


	/*Calling plugins */
	current->text = elog_sp_toChar(txt, len);
	struct elog_plgn_data_io *plgn = malloc(sizeof *plgn);
	plgn->doc = current;
	plgn->xml = NULL;
	elog_plgn_call_all("___save", plgn);
	free(plgn);
	current->text = NULL;
	/*end plugins */


	elog_sp_cat(&(current->last_edit), elog_io_date(), NULL);


	elog_xml_save(current->fileName, current, txt, len);


	free(txt);
	elog_xml_doc_unref(current);

	free(save);
	return 0;
}
