/*  AUTHOR:  Chris <MA_D> Hilton
 *  LICENSE:  GPLv2
 *  PURPOSE:  Make encryption more bottlenecked, better checked everywhere.
 */


/* Why me?
   This file basically exists to insure that encryption is happening right and happening when it's need.  So, I'm centralizing this logic here behind two calls:
   elog_crypt_decrypt
   elog_crypt_encrypt
   
   These functions will do things for you like checking for keys.  Setting them up if needed.  Talking to the user about problems, etc, etc, etc.
*/
#ifndef CRYPTO_H
#define CRYPTO_H

#include "xml.h"

struct elog_crypt_save
{
  unsigned char *txt;
  struct elog_xml_doc *doc;
  unsigned int len;
  const char *enc;
};


int elog_crypt_decrypt(unsigned char *data, unsigned int len);
//About:  This is a base level crypto call.  It's basically just
// gonna check for a key and get one if needed.
//Post:  returns 0 on success, 1 on failure:  Take the return seriously!

int elog_crypt_encrypt(unsigned char *data, unsigned int len);
//See decrypt.



struct elog_xml_doc *elog_crypt_open_dry(const char *fileName);
//Pre:  fileName is a c string
//Post:  opens fileName with elog_xml_open.  Tries to decrypt its subject
// if needed.  Fills in document text and decrypts it into the xml doc.
//The file handle is closed.

struct elog_xml_doc *elog_crypt_open_dry_noTxt(const char *fileName);
//Pre:  fileName is a c string
//Post:  Does the same as elog_crypt_open_dry, but:
//It does not read the text of the entry, but does decrypt the subject.
//This function is actually called by elog_crypt_open_dry.
//The file handle is left open.


int elog_crypt_save_dry(struct elog_crypt_save *save);
//Pre: save->txt should be your unencrypted text.
//Post:  saves the doc properly.  returns 0 on success
//Note:  save is freed, save->doc is unref'ed, save->txt is freed.


#endif

