/* AUTHOR: Chris <MA_D> Hilton
 * LICENSE:  GPL Version 2
 *
 */
 
 /* Why me?
  * This file exists to wrap up typical tab operations for
  * the edit tab, you'll find similar files for other tabs:
  * calendar.h and search_tab.h.  This one is named funny because
  * searching code is in search.h
 */

#ifndef EDIT_H
#define EDIT_H
#include <gtk/gtk.h>



void elog_edit_highlight_term(const char *term);
//Pre: 
//Post:  This sets the term that the main text will have highlighted.
//		Setting it to NULL will clear it.

void elog_edit_highlight_do();
//Pre:  you have set the term with elog_gui_io_highlight_term
//Post:  highlights the term in the current buffer.


void elog_edit_view_next_result();
//Pre:  
//Post:  Moves the text view to the next result

void elog_edit_view_prev_result();
//Pre:
//Post:  Moves the text view to the previous result.


int elog_tab_edit_srch();
//Pre:
//Post:  This will get the searchbar text.
//Then it will highlight the results for this in the text area.

int elog_tab_edit_res(const char *name, int n);
//Pre: name is a c string
//Post: does what edit does on a result n in the search bar.
  
int elog_tab_edit_cut();
//Pre:
//Post:  This will do a cut.
//  This is little more than the gtk cut on the main text box.

int elog_tab_edit_copy();
//Pre:
//Post:  This will do a copy.

int elog_tab_edit_paste();
//Pre:
//Post:  This will paste into the main text box

int elog_tab_edit_delete();
//Pre:
//Post:  This will move the current entry to the trash and open
//  up a blank entry.


/***********Callbacks**********/
void elog_tab_edit_ignore_signals(int t);
//sets if these signals should be ignored, t is 1 for ignore, 0 for listen.

gboolean
on_text_event		    (GtkTextView        *txt,
				     GdkEvent			*event,
                                     gpointer         user_data);	
//About:  This complex function handles virtually all events on the main edit textbox
//it's responsible for making sure things don't get messed up with the undo lists
//and etc

gboolean    on_text_cursor_move_real                  (GtkWidget      *widget,
                                            GdkEventMotion *event,
                                            gpointer        user_data);

void        on_buffer_insert      (GtkTextBuffer *textbuffer,
                                            GtkTextIter *arg1,
                                            gchar *arg2,
                                            gint arg3,
                                            gpointer user_data);
//this is a helper for the text_cursor_move, it is needed for middle click pastes
void
view_popup_menu (GtkWidget *txt, GdkEventButton *event, gpointer userdata);

void
on_link_remove_activate		(GtkButton       *button,
                                        gpointer         user_data);




void        on_text_insert                  (GtkTextBuffer *textbuffer,
                                            GtkTextIter *arg1,
                                            gchar *arg2,
                                            gint arg3,
                                            gpointer user_data);


                                       

#endif

