#include "error.h"
#ifndef NO_GUI
#include "gui_al.h"
#endif
void elog_err_print(const char *msg)
{
	elog_wrn_ask(msg, ELOG_WRN_ASK_OKONLY);
}

void elog_err_print_console(const char *msg)
{
	printf(msg);
}
void elog_wrn_print(const char *msg)
{
#ifndef NO_GUI
	 if (elog_status_ready()) 
		  elog_status_short_status(msg, 40000, 1);
	 else 
		  elog_wrn_ask(msg, ELOG_WRN_ASK_OKONLY);
	 printf("%s\n", msg);
#endif
#ifdef NO_GUI
	printf(msg);

#endif
}
int elog_wrn_ask(const char *msg, int mode)
{

#ifndef NO_GUI

	int result;
	switch (mode) {
	case ELOG_WRN_ASK_OKCANCEL:
		{
			GtkWidget *box =
			    gtk_message_dialog_new(GTK_WINDOW(_mainWindow),
						   GTK_DIALOG_DESTROY_WITH_PARENT,
						   GTK_MESSAGE_QUESTION,
						   GTK_BUTTONS_OK_CANCEL,
						   (gchar *) msg);
			result = gtk_dialog_run(GTK_DIALOG(box));
			gtk_widget_destroy(box);
			if (result == GTK_RESPONSE_OK)
				return 1;
			else
				return 0;
			break;
		}
	case ELOG_WRN_ASK_OKONLY:
		{
			GtkWidget *box =
			    gtk_message_dialog_new(GTK_WINDOW(_mainWindow),
						   GTK_DIALOG_DESTROY_WITH_PARENT,
						   GTK_MESSAGE_QUESTION,
						   GTK_BUTTONS_OK,
						   (gchar *) msg);
			result = gtk_dialog_run(GTK_DIALOG(box));
			gtk_widget_destroy(box);
			return 1;
			break;
		}
	case ELOG_WRN_ASK_YESNO:
		{
			GtkWidget *box =
			    gtk_message_dialog_new(GTK_WINDOW(_mainWindow),
						   GTK_DIALOG_DESTROY_WITH_PARENT,
						   GTK_MESSAGE_QUESTION,
						   GTK_BUTTONS_YES_NO,
						   (gchar *) msg);
			result = gtk_dialog_run(GTK_DIALOG(box));
			gtk_widget_destroy(box);
			if (result == GTK_RESPONSE_YES)
				return 1;
			else
				return 0;
			break;
		}
	}
	return 1;
#endif
}
