/*
 *AUTHOR: Chris <MA_D> Hilton
 *LICENSE: GPL v2
 *PURPOSE:  This file exports a journal to other formats
 *
 *CAVEATS:  This file provides no ability to actually export, only
 *          mechanism.  A plugin is recommended to provide ability.
 */

#include "simple.h"
#include "error.h"
#include "xml.h"
#include "io.h"
#include "meta_functions.h"
#include "crypt.h"
#include "settings.h"
#include <stdio.h>
#include <stdlib.h>
#include "prefix.h"
#include <stdarg.h>
#include "defines.h"


#define ELOG_EXP_HTML_STYLE_LATEX 0
#define ELOG_EXP_STYLE_USER 1

#define ELOG_EXP_TYPES "html_latex\n"

char *elog_exp_html(const char *dest, int style, ...);
//Pre:  dest is the location you want to make a directory for the html export
//      style is one of the defines for the look of the site made
//Post:  the current journal is exported to dest as a user viewable/navigable
//       html website.
//Caveat:  This is not a recoverable format.  That means that it doesn't save 
//         Everything.  It only saves certain things:
//        *Actual Text
//        *Links to actual things, not search links
//        *Dates, not edit dates
//        *Moods and weathers
//        *Subject/Title
//if called with dest='stdout' will return the full output

