#include "prefix.h"
#include "gui_al.h"
#include "callbacks.h"
#include "error.h"
#include "settings.h"
#include "interface.h"
#include "gui_io.h"
#include "threads.h"
#include "second.h"

int combo_box_text(int str, GtkWidget * widget);
struct elog_gui_al_tag {
	GtkTextTag *tag;
	struct elog_gui_al_tag *next;
};

struct elog_gui_al_tag *_headTag;

int _lock_status = 0;

int _lock_mode = 0;

int _al_locks[] = {0, 0, 0};
int _locked = 0;

void elog_gui_al_lock()
{
	 elog_glob_lock();
/*	 int me = elog_thrd_identify_me();
	 if (_al_locks[me]) //already locked.
		  return;
	 _al_locks[me] = 1;
	 while (_locked) {
		  usleep(100);
	 }
	 _locked = 1;*/
}

void elog_gui_al_unlock()
{
	 elog_glob_unlock();
/*	 int me = elog_thrd_identify_me();
	 if (_al_locks[me] == 0) //already unloacked
		  return;
	 _al_locks[me] = 0;
	 _locked = 0;*/
}
void elog_gui_al_setLockMode(int mode)
{
	_lock_mode = mode;
}

int _focus = 0;

int _mood_state = -1;
int _weather_state = -1;

int opened = 0;

int _lnk_indx = 0;


int elog_gui_al_attached = 0;	//whether there's something attached to view menu

static void remove_tag(GtkTextTag * tag, gpointer data)
{				//This function creates a stack of tag references.
	//For some reason, you can't remove links within a foreach.

	char *name = NULL;
	g_object_get((gpointer *) tag, "name", (gchar **) & name, NULL);
	if (name != NULL) {
		free(name);
		struct elog_gui_al_tag *nue = malloc(sizeof *nue);
		nue->tag = tag;
		if (_headTag != NULL)
			nue->next = _headTag;
		else
			nue->next = NULL;
		_headTag = nue;
	}
}

static void remove_mark(GtkTextTag * tag, gpointer data)
{				//This function creates a stack of tag references.
	//For some reason, you can't remove links within a foreach.
	char *name = NULL;
	g_object_get((gpointer *) tag, "name", (gchar **) & name, NULL);
	if (name == NULL) {
		struct elog_gui_al_tag *nue = malloc(sizeof *nue);
		nue->tag = tag;
		if (_headTag != NULL)
			nue->next = _headTag;
		else
			nue->next = NULL;
		_headTag = nue;
	}
}

void elog_gui_al_win_title(const char *title)
{
	gtk_window_set_title(GTK_WINDOW(_mainWindow), (gchar *) title);
}

int elog_gui_al_page(int page)
{

	if (page < 0) {
		int ret =
		    gtk_notebook_get_current_page(GTK_NOTEBOOK(_notebook));

		return ret;
	}
	gtk_notebook_set_current_page(GTK_NOTEBOOK(_notebook), page);

	return -1;
}

int elog_gui_al_width()
{				//checking the actual width can cause some problems at startup.
	int width = elog_set_get_int("width");
	return width;
}

int elog_gui_al_pane(int pos)
{

	if (pos == -1) {
		int ret = gtk_paned_get_position(GTK_PANED(_mainHPane));
		return ret;
	}
	gtk_paned_set_position(GTK_PANED(_mainHPane), pos);


	return -1;

}
void elog_gui_al_srch_pane(int pos)
{
	gtk_paned_set_position(GTK_PANED(_res_srch_pane), pos);
}

void elog_gui_al_clearLinks()
{

	GtkTextBuffer *buffer =
	    gtk_text_view_get_buffer(GTK_TEXT_VIEW(_textBox));
	GtkTextTagTable *table = gtk_text_buffer_get_tag_table(buffer);
	_headTag = NULL;
	gtk_text_tag_table_foreach(table, remove_tag, NULL);
	while (_headTag != NULL)	//going through the stack.
	{
		struct elog_gui_al_tag *p = _headTag;
		_headTag = p->next;
		gtk_text_tag_table_remove(table, p->tag);
		free(p);
	}

}


char *elog_gui_al_lastEdit(const char *date)
{

	if (date == NULL) {
		char *x;
		elog_sp_cat(&x,
			    (char *) gtk_label_get_text(GTK_LABEL(_date)),
			    NULL);
		return x;
	}

	gtk_label_set_text(GTK_LABEL(_date), date);

	return NULL;
}

char *elog_gui_al_creationDate(char *date)
{

	if (date == NULL) {
		char *x;
		elog_sp_cat(&x, (char *)
			    gtk_label_get_text(GTK_LABEL(_creationDate)),
			    NULL);
		return x;
	}
	//gtk_label_set_text(GTK_LABEL(_creationDate), date);
	char *markup;
	markup =
	    g_markup_printf_escaped
	    ("<span size=\"larger\" underline=\"single\"><b><i>%s</i></b></span>",
	     date);
	gtk_label_set_markup(GTK_LABEL(_creationDate), markup);
	free(markup);

	return NULL;
}

int elog_gui_al_addLink(struct elog_xml_link *lnk)
{

	return 0;		//wrong again alice.
}
struct elog_xml_link **elog_gui_al_getLinks()
{
	struct elog_xml_link **links;
	//const gchar *txt = gtk_label_get_text(GTK_LABEL(_links));
	links = NULL;		//temp line!  FEATURE DISABLED!
	return links;
}

int elog_gui_al_weather(int weather)
{
	return combo_box_text(weather, _weather);
}
int elog_gui_al_mood(int mood)
{
	return combo_box_text(mood, _mood);
}
char *elog_gui_al_title(char *title)
{

	char *tmp = NULL;
	if (title == NULL) {
		char *t = (char *)gtk_entry_get_text(GTK_ENTRY(_subject));
		if (g_utf8_validate(t, 3, NULL) == TRUE) {
			elog_sp_cat(&tmp, t, NULL);
			return tmp;
		}
		return NULL;
	}
	if (title[0]) {
		if (g_utf8_validate(title, 3, NULL) )
			gtk_entry_set_text(GTK_ENTRY(_subject), (gchar *) title);
		else
			elog_wrn_print("Error setting your subject line");
	}
	else
		gtk_entry_set_text(GTK_ENTRY(_subject), (gchar *) title);

	return NULL;
}

char *elog_gui_al_getSelectedText()
{
	GtkTextBuffer *buffer =
	    gtk_text_view_get_buffer(GTK_TEXT_VIEW(_mainTextView));
	GtkTextMark *sel1 =
	    gtk_text_buffer_get_mark(GTK_TEXT_BUFFER(buffer), "insert");
	GtkTextMark *sel2 =
	    gtk_text_buffer_get_mark(GTK_TEXT_BUFFER(buffer),
				     "selection_bound");
	GtkTextIter iter1;
	GtkTextIter iter2;
	gtk_text_buffer_get_iter_at_mark(GTK_TEXT_BUFFER(buffer), &iter1,
					 sel1);
	gtk_text_buffer_get_iter_at_mark(GTK_TEXT_BUFFER(buffer), &iter2,
					 sel2);
	return (char *) gtk_text_buffer_get_text(buffer, &iter1, &iter2,
						 TRUE);
}
char *elog_gui_al_text(char *txt)
{


	GtkTextBuffer *buffer =
	    gtk_text_view_get_buffer(GTK_TEXT_VIEW(_textBox));



	if (txt == NULL) {
		GtkTextIter start, end;
		gtk_text_buffer_get_start_iter(buffer, &start);
		gtk_text_buffer_get_end_iter(buffer, &end);
		char *ret =
		    (char *) gtk_text_buffer_get_text(buffer, &start, &end,
						      TRUE);
		return ret;
	}
	//GtkTextTagTable *nueTable = gtk_text_tag_table_new();
	//GtkTextBuffer *nueBuffer = gtk_text_buffer_new(nueTable);

	//for some reason, gtk handles all the freeing of the buffer, tag_table, and
	//the texttags, so, we don't have to worry about it!  

	//It may seem really inefficient to make a new buffer and tag table
	//But it's a LOT easier than the alternatives for getting rid off
	//the old text tags.

	GtkTextIter st, nd;
	gtk_text_buffer_get_iter_at_offset(buffer, &st, 0);
	gtk_text_buffer_get_end_iter(buffer, &nd);
	gtk_text_buffer_remove_all_tags(buffer, &st, &nd);


	elog_gui_al_clearLinks();



	gtk_text_buffer_set_text(buffer, txt, strlen(txt));

	return NULL;
}
int combo_box_text(int str, GtkWidget * widget)
{

	if (str <= -1) {
		int ret = gtk_combo_box_get_active(GTK_COMBO_BOX(widget));
		return ret;
	}

	gtk_combo_box_set_active(GTK_COMBO_BOX(widget), str);


	return -1;
	/* Instructional: how to search a combo box by char*
	   GtkTreeModel *tree = gtk_combo_box_get_model(GTK_COMBO_BOX(widget));
	   GtkTreeIter i;
	   if (gtk_tree_model_get_iter_first(tree, &i) == FALSE)
	   return NULL;
	   int c=0;
	   do
	   {
	   enum
	   {
	   COL_ONLY
	   };
	   gchar *txt;
	   gtk_tree_model_get(tree, &i, COL_ONLY, &txt);
	   if (strcmp((char *)txt, str) == 0)
	   gtk_combo_box_set_active(widget, c);
	   ++c;
	   } while (gtk_tree_model_iter_next(tree, &i) != FALSE);
	   return NULL; */
}


gboolean on_lnk_event(GtkTextTag * texttag,
		      GObject * arg1,
		      GdkEvent * event,
		      GtkTextIter * arg2, gpointer user_data)
{
	printf("event for link\n");
	return FALSE;
}

int _gui_al_textCounter = 0;

int elog_gui_al_textLink(int start, int end, char *lnk)
{
	GtkTextBuffer *buffer =
	    gtk_text_view_get_buffer(GTK_TEXT_VIEW(_textBox));

	char *name = elog_sp_shortToString(_gui_al_textCounter);
	++_gui_al_textCounter;

	gtk_text_buffer_create_tag(buffer, (gchar *) name, "foreground",
				   "blue", "underline", TRUE, NULL);
	//Note to self:
	//When the manual says that they can't have the same name twice:  BLOODY LISTEN!
	//The above line had a name before, it was a hard bug to track....

	++_lnk_indx;

	GtkTextIter st, nd;
	gtk_text_buffer_get_iter_at_offset(buffer, &st, start);
	gtk_text_buffer_get_iter_at_offset(buffer, &nd, end);

	gtk_text_buffer_apply_tag_by_name(buffer, name, &st, &nd);
	free(name);

	return _gui_al_textCounter - 1;
}
void elog_gui_al_markText(const char *text, const char *start,
			  const char *end)
{
	int s, e;
	s = g_utf8_pointer_to_offset(text, start);
	e = g_utf8_pointer_to_offset(text, end);

	GtkTextBuffer *buffer =
	    gtk_text_view_get_buffer(GTK_TEXT_VIEW(_textBox));
	GtkTextTag *n =
	    gtk_text_buffer_create_tag(buffer, NULL, "foreground", "red",
				       "scale", PANGO_SCALE_X_LARGE, NULL);
	GtkTextIter st, nd;
	gtk_text_buffer_get_iter_at_offset(buffer, &st, s);
	gtk_text_buffer_get_iter_at_offset(buffer, &nd, e);
	gtk_text_buffer_apply_tag(buffer, n, &st, &nd);
}

void elog_gui_al_clearTextMarks()
{

	GtkTextBuffer *buffer =
	    gtk_text_view_get_buffer(GTK_TEXT_VIEW(_textBox));
	GtkTextTagTable *table = gtk_text_buffer_get_tag_table(buffer);
	gtk_text_tag_table_foreach(table, remove_mark, NULL);
	while (_headTag != NULL) {
		gtk_text_tag_table_remove(table, _headTag->tag);
		struct elog_gui_al_tag *p = _headTag->next;
		free(_headTag);
		_headTag = p;
	}

}
void elog_gui_al_setVisible(int yn)
{

	GtkTextBuffer *buffer =
	    gtk_text_view_get_buffer(GTK_TEXT_VIEW(_mainTextView));
	if (0 == yn) {
		if (GTK_WIDGET_HAS_FOCUS(_textBox))
			_focus = 1;
		else
			_focus = 0;
		gtk_text_buffer_begin_user_action(buffer);
		gtk_widget_hide(_textBox);
	} else {
		gtk_text_buffer_end_user_action(buffer);
		gtk_widget_show(_textBox);
		if (_focus)
			gtk_widget_grab_focus(_textBox);
	}

}
void elog_gui_al_removeLink(const char *name)
{

	GtkTextBuffer *buffer =
	    gtk_text_view_get_buffer(GTK_TEXT_VIEW(_textBox));
	GtkTextTagTable *table = gtk_text_buffer_get_tag_table(buffer);
	GtkTextTag *tag = gtk_text_tag_table_lookup(table, name);
	gtk_text_tag_table_remove(table, tag);	//should destroy it.

}
void elog_gui_al_removeChar(int loc)
{
	elog_gui_al_removeStr(loc, 1);
}
void elog_gui_al_insertChar(int loc, unsigned int character)
{
	elog_tab_edit_ignore_signals(1);
	GtkTextBuffer *buffer =
	    gtk_text_view_get_buffer(GTK_TEXT_VIEW(_textBox));
	GtkTextIter iter;
	gtk_text_buffer_get_iter_at_offset(buffer, &iter, (gint) loc);
	gchar x[6];
	int n = g_unichar_to_utf8(character, x);

	gtk_text_buffer_insert_interactive(buffer, &iter, (gchar *) x, n,
					   TRUE);
	elog_tab_edit_ignore_signals(0);
}
void elog_gui_al_removeStr(int loc, int len)
{
	elog_tab_edit_ignore_signals(1);
	GtkTextBuffer *buffer =
	    gtk_text_view_get_buffer(GTK_TEXT_VIEW(_textBox));
	GtkTextIter iter, iter_end;
	gtk_text_buffer_get_iter_at_offset(buffer, &iter, (gint) loc);
	gtk_text_buffer_get_iter_at_offset(buffer, &iter_end,
					   (gint) loc + len);
	gtk_text_buffer_delete_interactive(buffer, &iter, &iter_end, TRUE);
	elog_tab_edit_ignore_signals(0);
}

int elog_gui_al_cursor(int n)
{
	if (n < 0) {
		GtkTextBuffer *buffer =
		    gtk_text_view_get_buffer(GTK_TEXT_VIEW(_textBox));
		GtkTextIter iter;
		GtkTextMark *mark =
		    gtk_text_buffer_get_mark(buffer, "insert");
		gtk_text_buffer_get_iter_at_mark(buffer, &iter, mark);
		return gtk_text_iter_get_offset(&iter);
	}
	return -1;
}
void elog_gui_al_insertStr(int loc, char *str)
{
	elog_tab_edit_ignore_signals(1);

	GtkTextBuffer *buffer =
	    gtk_text_view_get_buffer(GTK_TEXT_VIEW(_textBox));
	GtkTextIter iter;
	if (loc == -1) {
		GtkTextMark *mark =
		    gtk_text_buffer_get_mark(buffer, "insert");
		gtk_text_buffer_get_iter_at_mark(buffer, &iter, mark);
	} else
		gtk_text_buffer_get_iter_at_offset(buffer, &iter,
						   (gint) loc);
	gtk_text_buffer_insert_interactive(buffer, &iter, (gchar *) str,
					   -1, TRUE);
	elog_tab_edit_ignore_signals(0);
}
void elog_gui_al_setImage(int mood, int weather)
{
	if (mood == -1 || weather == -1)
		return;
	char *mood_c = elog_sp_shortToString(mood);
	char *weather_c = elog_sp_shortToString(weather);

	char *file_mood;
	elog_sp_cat(&file_mood, getenv("HOME"), "/.elog/default/Smilies/",
		    mood_c, ".png", NULL);
	char *file_weather;
	elog_sp_cat(&file_weather, getenv("HOME"),
		    "/.elog/default/Weather/", weather_c, ".png", NULL);


	GError *error = NULL;
	GdkPixbufLoader *loader = gdk_pixbuf_loader_new();

	int landscape = (mood + weather) / 2;

	if (elog_img_landscape(landscape) == NULL) {
		gdk_pixbuf_loader_close(loader, &error);
		return;
	}

	gdk_pixbuf_loader_write(loader, elog_img_landscape(landscape),
				elog_img_landscapeSize(landscape), &error);
	GdkPixbuf *landscape_pb = gdk_pixbuf_loader_get_pixbuf(loader);
	gdk_pixbuf_loader_close(loader, &error);

	loader = gdk_pixbuf_loader_new();
	gdk_pixbuf_loader_write(loader, elog_img_smiley(mood),
				elog_img_smileySize(mood), &error);
	GdkPixbuf *mood_pb = gdk_pixbuf_loader_get_pixbuf(loader);
	gdk_pixbuf_loader_close(loader, &error);


	loader = gdk_pixbuf_loader_new();
	gdk_pixbuf_loader_write(loader, elog_img_weather(weather),
				elog_img_weatherSize(weather), &error);
	GdkPixbuf *weather_pb = gdk_pixbuf_loader_get_pixbuf(loader);
	gdk_pixbuf_loader_close(loader, &error);


	int w = elog_gui_al_pane(-1);
	int h = 2.5 * w;

	int mood_n_channels = gdk_pixbuf_get_n_channels(mood_pb);
	int mood_rowstride = gdk_pixbuf_get_rowstride(mood_pb);


	int landscape_n_channels = gdk_pixbuf_get_n_channels(landscape_pb);
	int landscape_rowstride = gdk_pixbuf_get_rowstride(landscape_pb);

	int weather_n_channels = gdk_pixbuf_get_n_channels(weather_pb);
	int weather_rowstride = gdk_pixbuf_get_rowstride(weather_pb);
	int height = gdk_pixbuf_get_height(weather_pb);
	int width = gdk_pixbuf_get_width(weather_pb);

	guchar *pixels = gdk_pixbuf_get_pixels(weather_pb);


	guchar *smiley = gdk_pixbuf_get_pixels(mood_pb);

	guchar *bottom = gdk_pixbuf_get_pixels(landscape_pb);


	int y;
	for (y = 0; y < height; ++y) {
		int row;
		for (row = 0; row < width; ++row) {
			guchar *p =
			    pixels + y * weather_rowstride +
			    row * weather_n_channels;
			guchar *s =
			    smiley + y * mood_rowstride +
			    row * mood_n_channels;
			guchar *l =
			    bottom + y * landscape_rowstride +
			    row * landscape_n_channels;

			if (s[3] == 255) {
				p[0] = s[0];
				p[1] = s[1];
				p[2] = s[2];
			}	//no need to do divisions here
			else if (s[3] > 0) {	//blending alpha's                
				p[0] =
				    ((float) s[3] / 255.0) * (float) s[0] +
				    (255.0 - (float) s[3])
				    / 255.0 * (float) p[0];
				p[1] =
				    ((float) s[3] / 255.0) * (float) s[1] +
				    (255.0 - (float) s[3])
				    / 255.0 * (float) p[1];
				p[2] =
				    ((float) s[3] / 255.0) * (float) s[2] +
				    (255.0 - (float) s[3])
				    / 255.0 * (float) p[2];
			}

			if (l[3] == 255) {
				p[0] = l[0];
				p[1] = l[1];
				p[2] = l[2];
			}	//no need to do divisions here
			else if (l[3] > 0) {	//blending alpha's                
				p[0] =
				    ((float) l[3] / 255.0) * (float) l[0] +
				    (255.0 - (float) l[3])
				    / 255.0 * (float) p[0];
				p[1] =
				    ((float) l[3] / 255.0) * (float) l[1] +
				    (255.0 - (float) l[3])
				    / 255.0 * (float) p[1];
				p[2] =
				    ((float) l[3] / 255.0) * (float) l[2] +
				    (255.0 - (float) l[3])
				    / 255.0 * (float) p[2];
			}

		}
	}


	if (error != NULL) {
		elog_err_print_console(g_quark_to_string(error->domain));

		return;
	}


	if (h > 0) {
		GdkPixbuf *scaled =
		    gdk_pixbuf_scale_simple(weather_pb, w, h,
					    GDK_INTERP_HYPER);

		gtk_image_set_from_pixbuf(GTK_IMAGE(_sideImage), scaled);

		g_object_unref(scaled);
	} else
		gtk_image_set_from_pixbuf(GTK_IMAGE(_sideImage),
					  weather_pb);

	g_object_unref(mood_pb);
	g_object_unref(weather_pb);
	g_object_unref(landscape_pb);
	free(mood_c);
	free(weather_c);

}

void elog_gui_al_clearDay()
{

	gtk_list_store_clear(GTK_LIST_STORE(_mainDayList));

}
void elog_gui_al_addItemToDay(const char *title, const char *path,
			      int mood)
{
	GError *error = NULL;
	GdkPixbufLoader *loader = gdk_pixbuf_loader_new();
	GdkPixbuf *scaled = NULL;


	if (mood < -1)
		return;

	int fr = 0;
	void *pix = NULL;
	unsigned int size;
	if (mood >= 0) {
		char *path;
		elog_sp_cat(&path, DATADIR, "/ejourn/img/ejourn.png",
			    NULL);
		struct elog_io_file *f =
		    elog_io_initialize(path, ELOG_IO_READ);
		if (f) {
			pix = elog_io_readRestofFile(f, &size);
			elog_io_close(f);
			fr = 1;
		} else {
			elog_err_print("Error, missing page_32.png\n");
			return;
		}
		free(path);

	} else {
		char *path;
		elog_sp_cat(&path, DATADIR, "/ejourn/img/add2.png", NULL);
		struct elog_io_file *f =
		    elog_io_initialize(path, ELOG_IO_READ);
		if (f) {
			pix = elog_io_readRestofFile(f, &size);
			elog_io_close(f);
			fr = 1;
		} else {
			elog_err_print("Error, missing add.png\n");
		}
		free(path);
	}


	gdk_pixbuf_loader_write(loader, pix, size, &error);
	GdkPixbuf *mood_pb = gdk_pixbuf_loader_get_pixbuf(loader);
	gdk_pixbuf_loader_close(loader, &error);

	if (pix)
		free(pix);

	scaled = mood_pb;




	GtkTreeIter iter;
	gtk_list_store_append(GTK_LIST_STORE(_mainDayList), &iter);
	gtk_list_store_set(GTK_LIST_STORE(_mainDayList), &iter, 0, title,
			   1, path, 2, scaled, -1);
	g_object_unref(loader);
}
int elog_gui_al_setKey(int mode)
{
	setKey(NULL);
	//      create_intro_window();  
	return create_login_window(mode);
}


char *elog_gui_al_clipBoard(char *text)
{
	if (text) {
		gtk_clipboard_set_text(gtk_clipboard_get_for_display
				       (gdk_display_get_default(),
					GDK_SELECTION_CLIPBOARD), text,
				       strlen(text));
		return NULL;
	}
	return (char *)
	    gtk_clipboard_wait_for_text(gtk_clipboard_get_for_display
					(gdk_display_get_default(),
					 GDK_SELECTION_CLIPBOARD));
}


/*****************************************************/


/*  Search Interfacing  */

char *elog_gui_al_searchText(char *txt)
{

	if (txt == NULL) {
		char *ret =
		    (char *) gtk_entry_get_text(GTK_ENTRY(_srchTxt));

		return ret;
	}

	gtk_entry_set_text(GTK_ENTRY(_srchTxt), (gchar *) txt);

	return NULL;
}

int elog_gui_al_addResult(struct elog_srch_result *item)
{

	gtk_list_store_append(GTK_LIST_STORE(_srchTree), _srchIter);
	const char *month = elog_mnth_str(item->month);
	char *year = elog_sp_shortToString(item->year);
	char *occur = elog_sp_shortToString(item->occurances);
	gtk_list_store_set(GTK_LIST_STORE(_srchTree), _srchIter, 0, year,
			   1, month, 2, item->name, 3, occur, 4,
			   item->fileName, -1);

	free(year);

	return 0;
}

int elog_gui_al_clearResults()
{

	gtk_list_store_clear(GTK_LIST_STORE(_srchTree));

	return 0;
}

int elog_gui_al_caseSensitive(int set)
{
	if (set < 0) {
		if (gtk_toggle_button_get_active
		    (GTK_TOGGLE_BUTTON(_srchCaseSentive)) == TRUE) {

			return 1;
		} else {

			return 0;
		}
	}
	if (set > 0)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON
					     (_srchCaseSentive), TRUE);
	else
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON
					     (_srchCaseSentive), FALSE);


	return -1;
}

int elog_gui_al_lyric(int set)
{
	if (set < 0) {
		if (gtk_toggle_button_get_active
		    (GTK_TOGGLE_BUTTON(_srchLyric))
		    == TRUE) {

			return 1;
		} else {

			return 0;
		}
	}
	if (set > 0)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(_srchLyric),
					     TRUE);
	else
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(_srchLyric),
					     FALSE);


	return -1;
}


float elog_gui_al_srchAccuracy(float set)
{

	if (set < 0.0) {
		float ret =
		    (float) gtk_range_get_value(GTK_RANGE(_srchAccuracy));

		return ret;
	}
	gtk_range_set_value(GTK_RANGE(_srchAccuracy), (gdouble) set);

	return -1.0;
}

/************************************/

/****************Calendar Functions*******************/

struct cal_date *elog_gui_al_calendarDate(struct cal_date *date)
{

	if (date == NULL) {
		struct cal_date *ret = malloc(sizeof *ret);
		gtk_calendar_get_date(GTK_CALENDAR(_calendar),
				      &(ret->year), &(ret->month),
				      &(ret->day));

		return ret;
	}
	
	gtk_calendar_select_month(GTK_CALENDAR(_calendar), date->month,
				  date->year);
	gtk_calendar_select_day(GTK_CALENDAR(_calendar), date->day);
	

	return NULL;
}
void elog_gui_al_markDate(int day)
{

	gtk_calendar_mark_day(GTK_CALENDAR(_calendar), day);

}

void elog_gui_al_clearMarks()
{

	gtk_calendar_clear_marks(GTK_CALENDAR(_calendar));

}

/************************************/


/***********link stuff*/
char *elog_gui_al_getTreeSelected()
{

	gchar *s;
	gchar *d;
	GtkTreeSelection *selection;
	GtkTreeModel *model =
	    gtk_tree_view_get_model(GTK_TREE_VIEW(_treeViewLink));
	GtkTreeIter iter;

	/* This will only work in single or browse selection mode! */

	selection =
	    gtk_tree_view_get_selection(GTK_TREE_VIEW(_treeViewLink));
	if (gtk_tree_selection_get_selected(selection, &model, &iter)) {
		gtk_tree_model_get(model, &iter, 0, &s, 1, &d, -1);
		char *ret;
		elog_sp_cat(&ret, d, NULL);

		return ret;
	}

	return NULL;
}

void elog_gui_al_msg_win_pulse(struct elog_gui_al_msg_win *win)
{
	gtk_progress_bar_pulse(GTK_PROGRESS_BAR(win->progress));
	gtk_progress_bar_set_text(GTK_PROGRESS_BAR(win->progress),
				  "Please wait..");

	gtk_widget_grab_focus(win->label);

	gtk_widget_queue_draw(win->win);
	gtk_widget_queue_draw(win->label);
	gtk_widget_queue_draw(win->progress);

	//now clear all events.
	while (gtk_events_pending())
		gtk_main_iteration();


}

struct elog_gui_al_msg_win *elog_gui_al_msg_win_create(const char *msg)
{
	struct elog_gui_al_msg_win *nue = malloc(sizeof *nue);
	nue->win = gtk_dialog_new();
	gtk_window_set_decorated(GTK_WINDOW(nue->win), FALSE);

	char *wmsg;
	elog_sp_cat(&wmsg, "Caution:\n", msg, NULL);
	GtkWidget *label = gtk_label_new(wmsg);
	free(wmsg);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(nue->win)->vbox), label,
			   TRUE, TRUE, 0);

	nue->progress = gtk_progress_bar_new();
	gtk_progress_bar_set_pulse_step(GTK_PROGRESS_BAR(nue->progress),
					0.03);
	//gtk_progress_bar_set_bar_style(GTK_PROGRESS_BAR(nue->progress), GTK_PROGRESS_DISCRETE);
	gtk_progress_bar_set_orientation(GTK_PROGRESS_BAR(nue->progress),
					 GTK_PROGRESS_LEFT_TO_RIGHT);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(nue->win)->vbox),
			   nue->progress, TRUE, TRUE, 0);
	gtk_widget_show_all(nue->win);


	//now clear all events.
	while (gtk_events_pending())
		gtk_main_iteration_do(FALSE);

	nue->label = label;
	nue->n = 0;
	elog_sp_cat(&(nue->txt), msg, NULL);

	return nue;
}

void elog_gui_al_msg_win_destroy(struct elog_gui_al_msg_win *msg)
{
	gtk_widget_destroy(msg->win);
	free(msg);
}

/*****View menu stuff****/
GtkWidget *_attached_to_view = NULL;

void on_view_all_activate(GtkMenuItem * menuitem, gpointer user_data)
{
	void (*callback) () = user_data;
	callback();
}
struct elog_gui_al_menu *elog_gui_al_menu_new()
{
	struct elog_gui_al_menu *ret =
	    malloc(sizeof(struct elog_gui_al_menu));
	ret->parent = NULL;
	ret->widget = gtk_menu_new();
	int c;
	for (c = 0; c < 16; ++c)
		ret->groups[c] = NULL;
	ret->num = 0;
	return ret;
}
void elog_gui_al_menu_attach_view(struct elog_gui_al_menu *menu)
{
	_attached_to_view = menu->widget;
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(_viewMenu),
				  (GtkWidget *) (menu->widget));
	menu->parent = _viewMenu;
	g_object_ref(menu->widget);	//otherwise it disappears.
}
void elog_gui_al_menu_detach(struct elog_gui_al_menu *menu)
{
	g_object_ref(menu->widget);	//otherwise it disappears.
	menu->parent = NULL;
	gtk_menu_detach(GTK_MENU(menu->parent));
}

void elog_gui_al_menu_detach_view()
{
	if (_attached_to_view) {
		g_object_ref(_attached_to_view);
		gtk_menu_detach(GTK_MENU(_attached_to_view));
		_attached_to_view = NULL;
	}
}

void elog_gui_al_menu_free(struct elog_gui_al_menu *menu)
{
	gtk_widget_destroy(menu->widget);
	free(menu);
}


int elog_gui_al_view_add(struct elog_gui_al_menu *menu, const char *title,
			 void (*callback) (), int group)
{
	GtkWidget *item = NULL;
	if (group == -1)
		item = gtk_menu_item_new_with_label((const gchar *) title);
	else if (group == 0)
		item =
		    gtk_check_menu_item_new_with_label((const gchar *)
						       title);
	else if (group > 0) {
		if (!(menu->groups[group])) {
			item =
			    gtk_radio_menu_item_new_with_label(NULL,
							       title);
			menu->groups[group] = item;
		} else
			item =
			    gtk_radio_menu_item_new_with_label_from_widget
			    (menu->groups[group], title);

	}
	gtk_widget_show(item);
	g_signal_connect((gpointer) item, "activate",
			 G_CALLBACK(on_view_all_activate), callback);
	gtk_container_add(GTK_CONTAINER(menu->widget), item);

	return ++(menu->num);
}

/*****************************************************/
void elog_gui_al_jump_to(int pos)
{
	GtkTextBuffer *buffer =
	    gtk_text_view_get_buffer(GTK_TEXT_VIEW(_mainTextView));
	GtkTextIter iter;
	gtk_text_buffer_get_iter_at_offset(buffer, &iter, pos);
	gtk_text_view_scroll_to_iter(GTK_TEXT_VIEW(_mainTextView), &iter,
				     0.0, TRUE, 0, 0);
}
int elog_gui_al_locToOffset(int loc, const char *str)
{
	return g_utf8_pointer_to_offset(str, &(str[loc]));
}
int elog_gui_al_strlen(const char *str)
{
	return (int) g_utf8_strlen(str, -1);
}
