/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 

/*Why me?
This file exists as a thin glue layer for gtk/gdk.  It has very little logic, except
for some image manipulations which require gdk.
Most of the functions are just set/get functions (although my set/gets operate
as one function with a get input).

*/

#ifndef GUI_AL_H
#define GUI_AL_H
 
#include <stdlib.h>
#include "xml.h"
#include "search.h"
#include "images.h"
#include "crypt.h"
#include "threads.h"
#include "login.h"
#include "status.h"
#include <gtk/gtk.h>


 
GtkWidget *_intro_window;
/*These are off limits for outside use, use at your own self hating risk*/
GtkWidget *_mainWindow;
GtkWidget *_date;
GtkWidget *_creationDate;
GtkWidget *_links;
GtkWidget *_calendar;
GtkWidget *_mood;
GtkWidget *_weather;
GtkWidget *_textBox;
GtkWidget *_mainTextView;
GtkWidget *_subject;
GtkWidget *_sideImage;
GtkWidget *_mainHPane;
GtkWidget *_mainDayList;
GtkWidget *_notebook;
GtkWidget *_mainScroll;
GtkWidget *_mainMenuBar;
GtkWidget *_viewMenu;
GtkWidget *_mainBox;
GtkWidget *_mainDayView; //treeview containing _mainDayList

/*Search widgets*/
GtkWidget *_srchTreeView;
GtkWidget *_srchTxt;
GtkWidget *_srchTree;
GtkTreeIter *_srchIter;

GtkWidget *_srchCaseSentive;
GtkWidget *_srchAccuracy;
GtkWidget *_srchLyric;


GtkWidget *_res_srch_window;
GtkWidget *_res_srch_list;
GtkWidget *_res_srch_pane;
GtkWidget *_menu_srch_entry;

//Links window:
GtkWidget *_linkWindow;
GtkWidget *_expanderLocal;
GtkWidget *_expanderFile;
GtkWidget *_expanderWeb;
GtkWidget *_treeViewLink;
	enum
	{
		COL_SRCH_YEAR = 0,
		COL_SRCH_MONTH = 1,
		COL_SRCH_ENTRY = 2,
		COL_SRCH_ENTRY2 = 3,
		COL_SRCH_FILE_PATH,
		NUM_SRCH_COLS
	};


	
struct elog_gui_al_msg_win
{
	GtkWidget *win;
	GtkWidget *label;
	GtkWidget *progress;
	char *txt;
	unsigned long n;
	struct elog_thread *th;
};

	
GtkWidget *_fileListTree;
	

#define ELOG_GUI_AL_PAGE_CAL 0
#define ELOG_GUI_AL_PAGE_EDIT 1
#define ELOG_GUI_AL_PAGE_SRCH 2	
	
/*End stuff to not use, please use the functions below*/

void elog_gui_al_lock();
//Pre:
//Post:  Locks for threading purposes
	
void elog_gui_al_unlock();
//Pre:  
//Post:  unlocks for threading purposes.
	
void elog_gui_al_setLockMode(int mode);
//Pre:
//Post:  Sets that mode.  Often used for callbacks.
	
#define ELOG_GUI_AL_LOCKED 0 //normal mode, for normal running
#define ELOG_GUI_AL_LOCK_CALLBACK 1 //for calling these functions within callbacks.

void elog_gui_al_win_title(const char *title);
//Pre:  Main win is loaded
//Post:  The main window now has title title.

struct elog_gui_al_msg_win *elog_gui_al_msg_win_create(const char *msg);
//Creates and displayes a msg
void elog_gui_al_msg_win_destroy(struct elog_gui_al_msg_win *msg);
//closes and frees a msg
void  elog_gui_al_msg_win_pulse(struct elog_gui_al_msg_win *win);
//makes the msg update, call this frequently


int elog_gui_al_width();
//Returns the width of the main window

int elog_gui_al_page(int page);
	
	
int elog_gui_al_pane(int pos);
//Pos = -1 to return current pos, otherwise sets it.
	
void elog_gui_al_srch_pane(int pos);
//sets the pos of the search pane

char *elog_gui_al_lastEdit(const char *date);
//Sets the date widget, or if passed null returns the value in the
//date widget.

char *elog_gui_al_creationDate(char *date);
//Sets or returns creationDate.

int elog_gui_al_addLink(struct elog_xml_link *lnk);
//Returns 0 upon a successful addition of the link to the gui.

struct elog_xml_link **elog_gui_al_getLinks();
//Returns a pointer to an array of all links.



int elog_gui_al_mood(int mood);
//Sets or returns current displayed mood, -1 to return

int elog_gui_al_weather(int weather);
//Sets or returns current weather.

char *elog_gui_al_title(char *title);


char *elog_gui_al_text(char *txt);
//Sets or returns current main text.

void elog_gui_al_removeChar(int loc);
//Pre:
//Post:  Removes character at loc.

void elog_gui_al_insertChar(int loc, unsigned int character);
//Pre: character is 4 chars, and is null terminated
//Post:  inserts character at loc.
void elog_gui_al_removeStr(int loc, int len);
//Pre:
//Post: removes section starting at loc and ending at len
void elog_gui_al_insertStr(int loc, char *str);
//Pre:
//Post:  inserts str at loc.

int elog_gui_al_cursor(int);

char *elog_gui_al_getSelectedText();
//Pre:  Main window is initialized
//Post:  Returns the highlighted text or all text.


int elog_gui_al_textLink(int start, int end, char *lnk);
//Pre:  int start and end are within the text, and lnk is a valid c stringMatc
//Post:  Main text is given the link and made visible.

void elog_gui_al_removeLink(const char *name);
//Pre:  Name exists
//Post:  Is removed and destroyed from the interface.

void elog_gui_al_markText(const char *text, const char *start, const char *end);
//Marks text for search

void elog_gui_al_clearTextMarks();
//Clears marked made with above function

void elog_gui_al_setVisible(int yn);
//Set to 0 for invisible and 1 for visible.  
//This is for the highlight function to make it much faster.

void elog_gui_al_setImage(int mood, int weather);
//Pre:  Mood and weather must exists
//Post:  Opens the corresponding files, mixes them, and sets to the 
//		side image.

int elog_gui_al_setKey(int mode);
//Pre:  Makes intro window to get a key
//Post:  Holds until the user had closed the intro window.
//Note:  See login.h for available modes


char *elog_gui_al_clipBoard(char *text) ;
//Pre:  text is a c string or NULL
//Post:  Returns the current clipboard if text is NULL
//  otherwise sets global clipboard to text


/*  Search Interfacing  */

char *elog_gui_al_searchText(char *txt);
//Sets or returns current search text.


int elog_gui_al_addResult(struct elog_srch_result *item);
//Adds a result to the search list, returns 0 on success

int elog_gui_al_clearResults();
//Returns 0 upon successfully clearing search results.

void elog_gui_al_clearDay();
//Pre:
//Post:  Clearns content of the day.

void elog_gui_al_addItemToDay(const char *title, const char *path, int mood);
//Pre:  title is a valid c string
//Post:  Adds the item to the display of day contents.  Mood will display that moods icon, if any

int elog_gui_al_caseSensitive(int set);
//Pre:  set is 1,0,-1
//Post:  If set is -1, returns current value, if it is 0,1 it will set it.

int elog_gui_al_lyric(int set);
//Pre:  set is 1,0,-1
//Post:  If set is -1, returns current value, if it is 0,1 it will set it.

float elog_gui_al_srchAccuracy(float set);
//Pre:  set is -1-1
//Post:  If set is < 0; retrieves current value; otherwise it sets it.


int elog_gui_al_locToOffset(int loc, const char *str);
//Pre:  loc is an index to a char array. str is that array.
//Post:  Returns the utf8 safe offset.

int elog_gui_al_strlen(const char *str);
//Pre:  str is a utf8 string.
//Post:  returns the utf8 length.

/************************************/


/****Calendar!!!**/

struct cal_date
{
	unsigned int day;
	unsigned int month;
	unsigned int year;
};

struct cal_date *elog_gui_al_calendarDate(struct cal_date *date);
//Sets/returns the date selected on the calendar

void elog_gui_al_markDate(int day);
//Marks the date given within the current month

void elog_gui_al_clearMarks();

/********************************/


/****link stuff****/
char *elog_gui_al_getTreeSelected();
//Pre:  link box is opened (exists)
//Post:  returns text of selected link
/**********************************/





/*****Status bar*****/
//Moved to status.h/c

/*******************/


/********Menu Add calls*******/
/* The basic explanation of how to use it
 *  This supports three types of menu entries...
 *		1.)  Regular entries.  Just call group as -1 for this.
 *		2.)  Check Box entries.  Call group as 0 for this.
 *		3.)  Radio button entries.  Pick a group 1-15 for this.
 *			Each one in the same group num is in the same group!
 *			-This could be easily extended over 15, but I think
 *			the view menu should never be more complex than that!
 */
struct elog_gui_al_menu
{
	GtkWidget *widget;
	GtkWidget *parent;
	void *groups[16];
	int num;
};
struct elog_gui_al_menu *elog_gui_al_menu_new();
//Post:  Returns a new menu object.

void elog_gui_al_menu_free(struct elog_gui_al_menu *menu);
//Pre:  menu is alloced.
//Post:  Deletes the menu, doesn't detach it.

void elog_gui_al_menu_attach_view(struct elog_gui_al_menu *menu);
//Pre:  menu is alloced
//Post:  Attaches menu to the view menu.

void elog_gui_al_menu_detach_view();
//Pre:  menu is alloced
//Post:  Detaches menu to the view menu.
//Note:  This detaches reguardless of what's attached to it, this
// is a safe function.

void elog_gui_al_menu_detach(struct elog_gui_al_menu *menu);
//Pre:
//Post:  menu is detached from its parent.

int elog_gui_al_view_add(struct elog_gui_al_menu *menu, const char *title, void (*callback)(), int group);
//Pre:  menu is alloced, title is a c string, callback is a function, group is -1, 0, 1...15
//Post:  Adds to menu a item titled "title" which calls "callback" when clicked.
//It is associated in the group "group", if "group" is 1 or more, if it's 
//0 group becomes a check box, and -1 makes group a regular item.


/*****************************/

void elog_gui_al_jump_to(int pos);
//Pre:
//Post:  Jumps the main text box to iter at pos inside its' text.



#endif
