/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
 
 /*Why me?
 This file is to keep central open and close methods for the gui.
 The gui is only allowed to operate on one file at a time through
 this method, it's for working with current editable files.
 So to save and close you can simply call those functions.
 
 This file also runs things like displaying the current day in
a calendar (although the actual widgets are hidden from it).

It also handles things like what to do with certain kinds of 
link hrefs, and etc.  This is the real binding for the feel 
of the program.  Some of the feel ends up falling into
the callbacks; but as much as possible I will be moving 
this out of the callbacks and into a combination of
gui API abstractions and smart gui_io type files (although
one file for all of it will get too large).

This file is in a high state of flux as much of it is moving to
calendar.c, edit.c, and search_tab.c.  It was getting too large
and difficult to read!
gui_io_open(...) will probably stay forever.  Just for sentimental
value ;).
 
 */
 
#ifndef GUI_IO_H
#define GUI_IO_H
 
#include "xml.h"
#include "gui_al.h"
#include "undo.h"
#include "months.h"

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include "gui_types.h" 


int elog_gui_io_lock();
//Tells if the program is currently trying to open a file and display it.
//This basically exists to make sure callbacks don't interfere with quick
//displaying!

 int elog_gui_io_open(const char *fileName, struct cal_date *date);
//Pre:  fileName is a valid c string
//Post:  opens the file, reads the meta, fills it into 
//		the iface after saving previous contents to the appropriate file
 //Returns:  1 for opened, 0 for failure (likely the user said no)

void elog_gui_io_markCalendar();
//Pre:	The gui is loaded
//Post:  Marks the calendar in an appropriate way (srch items, or dir listing)

void elog_gui_previewPane_set(struct elog_xml_doc *meta);
//Pre:  fileName is a valid file link
//Post:  creates a new preview pane, can be included using sidePan, and will 
//		contain info about the file contents.

struct elog_xml_doc *elog_gui_getMeta();
//Pre:  box is a valid created struct
//Post:  returns the meta data from it using the information in the side pane.

int elog_gui_io_save();
//Pre:  Something is open;
//Post:  Saves to the disk and returns 0 on success!

void elog_gui_io_setSyncNeeded();

void elog_gui_io_addLink(struct elog_xml_link *lnk);
//Pre: lnk must be a valid link
//Post:  adds it to the list for the current file, so it can be saved.
		//Do not free the inputed lnk, it is not copied.

void elog_gui_io_removeLink(int loc);
//Pre: loc must be a spot within a valid link
//Post:  Link will be removed from ui and from app storage.

void elog_gui_io_fileHandler(char *fileHandle);
//Pre: fileHandle is in the format, file://name, local://name, http://name
//Post:  Handles files.

int elog_gui_io_checkRange(int loc, struct elog_xml_link **lnk);
//Pre:
//POst: Checks if the current loc has a tag there, returns 0 for no tag
//1 for a tag

void elog_gui_io_updateTags(int start, int len);
//Pre:
//Post: Moves links, so they are saved in the correct positions!


//**** Day display Stuff

void elog_gui_io_dispDay(const char *day);
//Pre:  day is given in the form of a directory:  ~/.elog/MyJournal/2003/4/25/day
//Post:  The files for day will be displayed.
//If NULL, redoes current day.

void elog_gui_io_dispLocation(const char *fileName);
//Pre:  fileName is the full path of an existing entry of any form
//Post:  this will set the calendar and disp the surrounding files.

void elog_gui_io_newEntry(const char *day);
//Pre:  
//Post:  opens a new entry for the day.

struct cal_date *elog_gui_io_getDate(const char *fileName);
//Post:  Fetches a date from a fileName
//

void elog_gui_io_search(void *);
//Pre:
//Post:  This is the standard search function, please 
//use this for tracking search results....

//*******/

/*************View menu stuff***********/
int elog_gui_io_view_in_srch_results(int year, int month, int day, int n);
//Pre:  
//Post:  Returns 1 if that is in the list of results present.  
//Returns 0 otherwise

void elog_gui_io_view_srch_results();  //mode 1
//Pre:  Callback for the view search results item
//Post:  marks search results in the calendar, instead of 
// marking days.
//  The pair for this is above, markCalendar

void elog_gui_io_view_dir_results();  //mode 0
//Pre:
//Post:  This is the normal view mode for the cal.

void elog_gui_io_view_set_result_mode(int);
//Pre: 
//Post: Sets the view result mode to one of the two
//  		elog_gui_io_markCalendar will call one.

void elog_gui_io_view_add_result(int year, int month, int day, int n);
//Pre:  Adds a result for this day
//Post: ^^

void elog_gui_io_view_clear_results();
//Pre:  Clears gui_io's list of search results.


/**************************************/

void elog_gui_io_open_manual();
//PRe:
//Post:  Opens the manual for ejourn.

#endif
