/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "handler.h"

struct elog_handler_category *_categories = NULL;
struct elog_handler_category *_categories_last = NULL;


void elog_handler_fileHandler(char *fileHandle)
{
	if (fileHandle[0] == 'l' &&
	    fileHandle[1] == 'o' &&
	    fileHandle[2] == 'c' &&
	    fileHandle[3] == 'a' &&
	    fileHandle[4] == 'l' &&
	    fileHandle[5] == ':' &&
	    fileHandle[6] == '/' && fileHandle[7] == '/') {
		char *name;
		elog_sp_cat(&name, elog_set_path(NULL), "/",
			    &fileHandle[8], NULL);
		printf("Name:%s:\n", name);
		elog_gui_io_open(name);
		free(name);
	} else if (fileHandle[0] == 'f' &&
		   fileHandle[1] == 'i' &&
		   fileHandle[2] == 'l' &&
		   fileHandle[3] == 'e' &&
		   fileHandle[4] == ':' &&
		   fileHandle[5] == '/' && fileHandle[6] == '/') {
		printf("local file:%s\n", fileHandle);

	}

}

void elog_handler_loadSettings(char *fileName)
{
	struct elog_io_file *f =
	    elog_io_initialize(fileName, ELOG_IO_READ);
	int len;
	char *contents = elog_io_readRestofFile(f, &len);

	elog_io_close(f);


	int c;

	for (c = 0;; ++c) {
		char *line = elog_sp_getLine(contents, c);
		if (line == NULL)
			break;
		char **arr = elog_sp_breakToArr(line, ' ');
		if (strcmp(arr[0], "cat") != 0) {
			free(line);
			int j;
			for (j = 0; arr[j] != NULL; ++j)
				free(arr[j]);
			free(arr);
			break;	//done with categories
		}
		char *cat;
		elog_sp_cat(&cat, arr[1], NULL);
		char *exec;
		elog_sp_cat(&exec, arr[2], NULL);
		int j;
		for (j = 0; arr[j] != NULL; ++j)
			free(arr[j]);
		free(arr);
		free(line);
		printf("Category: %s :: %s\n", cat, exec);
		elog_handler_addCategory(cat, exec);
		free(cat);
		free(exec);
	}


	for (;; ++c) {
		char *line = elog_sp_getLine(contents, c);
		if (line == NULL)
			break;	//loop exit point
		char **arr = elog_sp_breakToArr(line, ' ');
		char *ext;
		elog_sp_cat(&ext, arr[1], NULL);
		char *category;
		elog_sp_cat(&category, arr[2], NULL);

		int j;
		for (j = 0; arr[j] != NULL; ++j)
			free(arr[j]);
		free(arr);
		free(line);
		printf("Extension: %s :: %s\n", ext, category);

		elog_handler_addExtension(ext, category);
		free(category);
		free(ext);
	}
}

void elog_handler_addCategory(char *cat, char *exec)
{
	struct elog_handler_category *nue = malloc((sizeof *nue));
	elog_sp_cat(&(nue->name), cat, NULL);
	elog_sp_cat(&(nue->exec), exec, NULL);
	nue->next = NULL;

	if (_categories == NULL) {
		_categories = nue;
		_categories_last = nue;
	} else {
		_categories_last->next = nue;
		_categories_last = nue;
	}
	_categories_last->list = NULL;
	_categories_last->list_last_item = NULL;
}

void elog_handler_addExtension(char *ext, char *category)
{
	struct elog_handler_category *p = _categories;
	for (; p != NULL; p = p->next)
		if (strcmp(p->name, category) == 0)
			break;

	if (p == NULL)
		return;

	struct elog_handler_ext *nue = malloc(sizeof *nue);
	elog_sp_cat(&(nue->ext), ext, NULL);

	if (p->list == NULL) {
		p->list = nue;
		p->list_last_item = nue;
	} else {
		p->list_last_item->next = nue;
		p->list_last_item = nue;
	}
}
char *elog_handler_getApp(const char *extension)
{
	struct elog_handler_category *cats = _categories;

	for (; cats != NULL; cats = cats->next) {
		struct elog_handler_ext *exts = cats->list;
		for (; exts != NULL; exts = exts->next)
			if (strcmp(exts->ext, extension) == 0)
				break;
		if (exts != NULL) {
			char *ret;
			elog_sp_cat(&ret, cats->exec, NULL);
			return ret;
		}
	}
	return NULL;
}
int elog_handler_open(const char *fileName)
{
	char **name = elog_sp_breakToArr(fileName, '.');
	if (name == NULL)
		return 1;
	if (name[1] == NULL) {
		free(name[0]);
		free(name);
		return 2;
	}
	char *prog = elog_handler_getApp(name[1]);

	char *run;
	elog_sp_cat(&run, prog, " ", fileName, NULL);

	system(run);
	free(run);

	int c;
	for (c = 0; name[c] != NULL; ++c)
		free(name[c]);
	free(name);
	free(prog);
	return 0;
}
