#include "images.h"
#include "defines.h"

char **_smilies;
unsigned int *_sizeOf_smilies;
char **_weathers;
unsigned int *_sizeOf_weathers;
char **_landscapes;
unsigned int *_sizeOf_landscapes;



unsigned int _smilies_size = 0;
unsigned int _weathers_size = 0;
unsigned int _landscapes_size = 0;


char **_imageNums_smiley;

char **_imageNums_weather;
char **_imageNums_landscapes;

int __getImageNum(char **imageList, const char *num)
{
	int c;
	for (c = 0; imageList[c] != NULL; ++c)
		if (strcmp(imageList[c], num) == 0)
			return c;
	return -1;
}


void _load_img_set(const char *theme, const char *name, char ***images,
		   unsigned int **sizes, unsigned int *size,
		   char **imageList)
{
	char *dir;
	elog_sp_cat(&dir, getenv("HOME"), _ELOG_CONFIG, theme, "/", NULL);
	char *dir_mood;
	elog_sp_cat(&dir_mood, dir, name, NULL);


	char **moods = elog_io_dirContents(dir_mood);
	if (moods == NULL)
		return;

	if (*size == 0) {
		*images = malloc((sizeof *(*images)) * 10);
		*sizes = malloc((sizeof *(*sizes)) * 10);
		int c;
		for (c = 0; c < 10; ++c) {
			(*images)[c] = NULL;	//This isn't NULL.
			(*sizes)[c] = -1;
		}
	}
	*size = 10;
	int c;
	for (c = 0; moods[c] != NULL; ++c) {
		char **arr = elog_sp_breakToArr(moods[c], '.');
		if (arr != NULL) {
			int num = __getImageNum(imageList, arr[0]);
			if (num >= 0 && num < 99) {	//checking if it was a valid number
				if (num > (_smilies_size - 1)) {
					int n = (*size);
					elog_sp_resizeArrayWSize(images,
								 &n);
					elog_sp_resizeArrayInt((int **)
							       sizes,
							       (int) size);
				}


				char *path;
				elog_sp_cat(&path, dir_mood, moods[c],
					    NULL);
				struct elog_io_file *f =
				    elog_io_initialize(path, ELOG_IO_READ);


				(*images)[num] =
				    elog_io_readRestofFile(f,
							   &((*sizes)
							     [num]));

				elog_io_close(f);
				free(path);
			}
			free(arr[0]);
			if (arr[1] != NULL)
				free(arr[1]);
			free(arr);
		}
		free(moods[c]);
	}
	free(moods);


	free(dir);
	free(dir_mood);
}

void elog_img_init()
{
	_imageNums_smiley = malloc((sizeof *_imageNums_smiley) * 11);



	_imageNums_smiley[0] = "young";
	_imageNums_smiley[1] = "happy";
	_imageNums_smiley[2] = "doh";
	_imageNums_smiley[3] = "shocked";
	_imageNums_smiley[4] = "nerves";
	_imageNums_smiley[5] = "embarrassed";
	_imageNums_smiley[6] = "mad";
	_imageNums_smiley[7] = "depressed";
	_imageNums_smiley[8] = "wavey";
	_imageNums_smiley[9] = "dead";
	_imageNums_smiley[10] = NULL;

	_imageNums_weather = malloc((sizeof *_imageNums_weather) * 11);


	_imageNums_weather[0] = "Sunny";
	_imageNums_weather[1] = "Night";
	_imageNums_weather[2] = "Hazy";
	_imageNums_weather[3] = "Partly Cloudy";
	_imageNums_weather[4] = "Cloudy";
	_imageNums_weather[5] = "Snow";
	_imageNums_weather[6] = "Rain";
	_imageNums_weather[7] = "Heavy Rain";
	_imageNums_weather[8] = "Thunderstorm";
	_imageNums_weather[9] = "Blizzard";
	_imageNums_weather[10] = NULL;


	_imageNums_landscapes =
	    malloc((sizeof *_imageNums_landscapes) * 12);



	_imageNums_landscapes[0] = "Green";
	_imageNums_landscapes[1] = "Dirt";
	_imageNums_landscapes[2] = "Leaves";

	_imageNums_landscapes[3] = "Snow";

	_imageNums_landscapes[4] = "Blue Water";
	_imageNums_landscapes[5] = "Green Water";
	_imageNums_landscapes[6] = "Mountain";
	_imageNums_landscapes[7] = "Fire";
	_imageNums_landscapes[8] = "Tsunami Blue";
	_imageNums_landscapes[9] = "Volcano";
	_imageNums_landscapes[10] = NULL;
}


void elog_img_load(const char *theme)
{



	_load_img_set(theme, "Smilies/", &_smilies, &_sizeOf_smilies,
		      &_smilies_size, _imageNums_smiley);
	_load_img_set(theme, "Weathers/", &_weathers, &_sizeOf_weathers,
		      &_weathers_size, _imageNums_weather);
	_load_img_set(theme, "Landscapes/", &_landscapes,
		      &_sizeOf_landscapes, &_landscapes_size,
		      _imageNums_landscapes);
}

void elog_img_free()
{
	int c;
	for (c = 0; c < _smilies_size; ++c)
		if (_sizeOf_smilies[c] != -1)
			free(_smilies[c]);

	free(_smilies);
	free(_sizeOf_smilies);

	for (c = 0; c < _weathers_size; ++c)
		if (_sizeOf_weathers[c] != -1)
			free(_weathers[c]);
	free(_weathers);
	free(_sizeOf_weathers);

	for (c = 0; c < _landscapes_size; ++c)
		if (_sizeOf_landscapes[c] != -1)
			free(_landscapes[c]);
	free(_landscapes);
	free(_sizeOf_landscapes);

	free(_imageNums_landscapes);
	free(_imageNums_weather);
	free(_imageNums_smiley);
}

void *elog_img_smiley(int n)
{
	if (n >= _smilies_size)
		return NULL;
	return _smilies[n];
}
int elog_img_smileySize(int n)
{
	if (n >= _smilies_size)
		return 0;
	return _sizeOf_smilies[n];
}

void *elog_img_weather(int n)
{
	if (n >= _weathers_size)
		return NULL;
	return _weathers[n];
}
int elog_img_weatherSize(int n)
{
	if (n >= _weathers_size)
		return 0;
	return _sizeOf_weathers[n];
}
void *elog_img_landscape(int n)
{
	if (n >= _landscapes_size)
		return NULL;
	return _landscapes[n];
}
int elog_img_landscapeSize(int n)
{
	if (n >= _landscapes_size)
		return 0;
	return _sizeOf_landscapes[n];
}

char *elog_img_name_weather(int num)
{
	return _imageNums_weather[num];
}

char *elog_img_name_smiley(int num)
{
	return _imageNums_smiley[num];
}

char *elog_img_name_landscape(int num)
{
	return _imageNums_landscapes[num];
}
