/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
/*Why me?
To make opening files about 1ms faster (ok, possibly more or less).

This file just buffers the smiley images.  This is so they don't
have to be loaded off the disk 18 times; which is needed because
these images must never cause the user to wait.

It comes at a variable cost depending on the images.
They are stored in memory as they are on the disk, compressed.
So it will likely cost you 250KB-1MB of RAM.


*/

 #include "io.h"
 #include "simple.h"
 #include <stdlib.h>
#include <string.h>

void elog_img_load(const char *theme);
//Pre:  
//Post:  Loads $HOME/.elog/theme/

void elog_img_free(); 
//Frees all the memory used.

char *elog_img_name_weather(int num);

char *elog_img_name_smiley(int num);

char *elog_img_name_landscape(int num);


void *elog_img_smiley(int n);
//Pre:
//Post: Return NULL for non-existant or a pointer to the data.
int elog_img_smileySize(int n);

void elog_img_init();
//Initializes values for names of images, needed before a lot of stuff.
//No reason to ever run it more than once

void *elog_img_weather(int n);
//Pre:
//Post: Return NULL for non-existant or a pointer to the data.
int elog_img_weatherSize(int n);


void *elog_img_landscape(int n);
//Pre:
//Post: Return NULL for non-existant or a pointer to the data.
int elog_img_landscapeSize(int n);
