/*
 * DO NOT EDIT THIS FILE - it is generated by Glade.
 */



#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>


#include "journ_wzrd.h"
#include "journal.h"
#include "error.h"
#include "gui_io.h"

int _new_wzrd_err = 0;

void on_cancelbutton1_activate(GtkButton * button, gpointer user_data)
{
	_new_wzrd_err = 1;
	gtk_widget_destroy(elog_journ_wzrd_dialog);
	gtk_main_quit();
}

void on_okbutton1_activate(GtkButton * button, gpointer user_data)
{
	const char *name = (const char *)
	    gtk_entry_get_text(GTK_ENTRY(elog_journ_wzrd_name));
	/* first make sure there name doesn't conflict */
	char **list = elog_journ_list();
	if (list) {
		int c;
		for (c = 0; list[c]; ++c) {
			if (strcmp(list[c], name) == 0) {	//we have a problem
				for (; list[c]; ++c)
					free(list[c]);
				free(list);
				elog_wrn_ask
				    ("The journal name you selected is taken, please choose a different one.",
				     ELOG_WRN_ASK_OKONLY);
				return;
			}
		}
		free(list);
	}
	/* now make the change */
	elog_journ_new();


	elog_sp_cat(&(elog_journ_current()->name), name, NULL);
	elog_journ_current()->settings->path =
	    gtk_file_chooser_get_current_folder(GTK_FILE_CHOOSER
						(elog_journ_wzrd_path));
	if (!
	    (gtk_toggle_button_get_active
	     (GTK_TOGGLE_BUTTON(elog_journ_wzrd_enc)))) {
		elog_sp_cat(&(elog_journ_current()->settings->encryption),
			    "NONE", NULL);

		gtk_widget_destroy(elog_journ_wzrd_dialog);
	} else {
		elog_sp_cat(&(elog_journ_current()->settings->encryption),
			    "AES", NULL);
		gtk_widget_destroy(elog_journ_wzrd_dialog);


	}
	elog_set_set_str("path", elog_journ_current()->settings->path);
	elog_journ_load(elog_journ_current()->name);

	gtk_main_quit();
}



#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

#define GLADE_HOOKUP_OBJECT_NO_REF(component,widget,name) \
  g_object_set_data (G_OBJECT (component), name, widget)

char *create_dialog(void)
{
	GtkWidget *dialog;
	GtkWidget *dialog_vbox2;
	GtkWidget *vbox1;
	GtkWidget *hbox1;
	GtkWidget *label1;
	GtkWidget *entry_name;
	GtkWidget *hbox2;
	GtkWidget *file_path;
	GtkWidget *hbox3;
	GtkWidget *radio_aes;
	GSList *radio_aes_group = NULL;
	GtkWidget *radio_none;
	GtkWidget *dialog_action_area2;
	GtkWidget *cancelbutton1;
	GtkWidget *okbutton1;
	GtkWidget *help;



	dialog = gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(dialog),
			     "eJourn::Create New Journal");
	gtk_window_set_type_hint(GTK_WINDOW(dialog),
				 GDK_WINDOW_TYPE_HINT_DIALOG);

	dialog_vbox2 = GTK_DIALOG(dialog)->vbox;
	gtk_widget_show(dialog_vbox2);



	vbox1 = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox1);
	gtk_box_pack_start(GTK_BOX(dialog_vbox2), vbox1, TRUE, TRUE, 0);

	GtkWidget *infolbl =
	    gtk_label_new
	    ("Creating a new journal:\nFirst you must put in a name, this can be any name you'd like.\nIt's how you will later identify the journal.\nNext, pick a directory on your computer to store the journal.\nThis directory should be empty to avoid confusion, so please create one.\nMake sure you double check that the directory which gets listed is \nthe same as the one you chose!\nLast.  Choose whether you'd like to encrypt or not.  No encryption is the recommended choice.\n");
	gtk_widget_show(infolbl);
	gtk_box_pack_start(GTK_BOX(vbox1), infolbl, TRUE, TRUE, 0);

	hbox1 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox1);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox1, TRUE, TRUE, 0);




	label1 = gtk_label_new("Name:");
	gtk_widget_show(label1);
	gtk_box_pack_start(GTK_BOX(hbox1), label1, FALSE, FALSE, 0);



	entry_name = gtk_entry_new();
	gtk_widget_show(entry_name);
	gtk_box_pack_start(GTK_BOX(hbox1), entry_name, TRUE, TRUE, 0);

	gtk_entry_set_text(GTK_ENTRY(entry_name), "Personal");

	hbox2 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox2);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox2, TRUE, TRUE, 0);

	file_path =
	    gtk_file_chooser_button_new("Select the Path",
					GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER);
	gtk_widget_show(file_path);
	gtk_box_pack_start(GTK_BOX(hbox2), file_path, TRUE, TRUE, 0);


	char *home = getenv("HOME");
	char *path;
	int c;
	elog_sp_cat(&path, home, _ELOG_CONFIG, NULL);

	struct stat buf;

	if (stat(path, &buf) < 0)
		elog_io_mkdir(path);

	free(path);


	for (c = 0; c < 1024; ++c) {
		char *n = elog_sp_shortToString(c);
		elog_sp_cat(&path, home, _ELOG_CONFIG, "journal", n, NULL);
		free(n);

		if (stat(path, &buf) < 0)
			break;
		char **list = elog_io_dirContents(path);
		if (!(list[0])) {
			free(list);
			if (!elog_journ_exists(path))
				break;	//the folder is empty
		} else
			free(list);
		free(path);
	}
	elog_io_mkdir(path);
	char *path2;

	elog_sp_cat(&path2, path, "/", NULL);
	free(path);
	elog_sp_cat(&path, home, _ELOG_CONFIG, "/", NULL);
	gtk_file_chooser_unselect_all(GTK_FILE_CHOOSER(file_path));

	gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(file_path),
					    path2);

	free(path2);
	free(path);


	hbox3 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox3);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox3, FALSE, FALSE, 0);

	radio_none =
	    gtk_radio_button_new_with_mnemonic(NULL, "No Encryption");
	gtk_widget_show(radio_none);
	gtk_box_pack_start(GTK_BOX(hbox3), radio_none, FALSE, FALSE, 0);
	gtk_radio_button_set_group(GTK_RADIO_BUTTON(radio_none),
				   radio_aes_group);
	radio_aes_group =
	    gtk_radio_button_get_group(GTK_RADIO_BUTTON(radio_none));

	radio_aes =
	    gtk_radio_button_new_with_mnemonic(NULL, "AES Encryption");
	gtk_widget_show(radio_aes);
	gtk_box_pack_start(GTK_BOX(hbox3), radio_aes, FALSE, FALSE, 0);
	gtk_radio_button_set_group(GTK_RADIO_BUTTON(radio_aes),
				   radio_aes_group);
	radio_aes_group =
	    gtk_radio_button_get_group(GTK_RADIO_BUTTON(radio_aes));


	dialog_action_area2 = GTK_DIALOG(dialog)->action_area;
	gtk_widget_show(dialog_action_area2);
	gtk_button_box_set_layout(GTK_BUTTON_BOX(dialog_action_area2),
				  GTK_BUTTONBOX_END);

	help = gtk_button_new_from_stock("gtk-help");
	gtk_widget_show(help);
	gtk_dialog_add_action_widget(GTK_DIALOG(dialog), help,
				     GTK_RESPONSE_HELP);
	GTK_WIDGET_SET_FLAGS(help, GTK_CAN_DEFAULT);

	cancelbutton1 = gtk_button_new_from_stock("gtk-cancel");
	gtk_widget_show(cancelbutton1);
	gtk_dialog_add_action_widget(GTK_DIALOG(dialog), cancelbutton1,
				     GTK_RESPONSE_CANCEL);
	GTK_WIDGET_SET_FLAGS(cancelbutton1, GTK_CAN_DEFAULT);

	okbutton1 = gtk_button_new_from_stock("gtk-ok");
	gtk_widget_show(okbutton1);
	gtk_dialog_add_action_widget(GTK_DIALOG(dialog), okbutton1,
				     GTK_RESPONSE_OK);
	GTK_WIDGET_SET_FLAGS(okbutton1, GTK_CAN_DEFAULT);

	g_signal_connect((gpointer) cancelbutton1, "activate",
			 G_CALLBACK(on_cancelbutton1_activate), NULL);
	g_signal_connect((gpointer) cancelbutton1, "clicked",
			 G_CALLBACK(on_cancelbutton1_activate), NULL);
	g_signal_connect((gpointer) cancelbutton1, "pressed",
			 G_CALLBACK(on_cancelbutton1_activate), NULL);
	g_signal_connect((gpointer) okbutton1, "activate",
			 G_CALLBACK(on_okbutton1_activate), NULL);
	g_signal_connect((gpointer) okbutton1, "clicked",
			 G_CALLBACK(on_okbutton1_activate), NULL);
	g_signal_connect((gpointer) okbutton1, "pressed",
			 G_CALLBACK(on_okbutton1_activate), NULL);

	g_signal_connect((gpointer) help, "clicked",
			 G_CALLBACK(elog_gui_io_open_manual), NULL);

	g_signal_connect((gpointer) help, "activate",
			 G_CALLBACK(elog_gui_io_open_manual), NULL);
	g_signal_connect((gpointer) help, "pressed",
			 G_CALLBACK(elog_gui_io_open_manual), NULL);


	/* Store pointers to all widgets, for use by lookup_widget(). */
	GLADE_HOOKUP_OBJECT_NO_REF(dialog, dialog, "dialog");
	GLADE_HOOKUP_OBJECT_NO_REF(dialog, dialog_vbox2, "dialog_vbox2");
	GLADE_HOOKUP_OBJECT(dialog, vbox1, "vbox1");
	GLADE_HOOKUP_OBJECT(dialog, hbox1, "hbox1");
	GLADE_HOOKUP_OBJECT(dialog, label1, "label1");
	GLADE_HOOKUP_OBJECT(dialog, entry_name, "entry_name");
	GLADE_HOOKUP_OBJECT(dialog, hbox2, "hbox2");
	GLADE_HOOKUP_OBJECT(dialog, file_path, "file_path");
	GLADE_HOOKUP_OBJECT(dialog, hbox3, "hbox3");
	GLADE_HOOKUP_OBJECT(dialog, radio_aes, "radio_aes");
	GLADE_HOOKUP_OBJECT(dialog, radio_none, "radio_none");
	GLADE_HOOKUP_OBJECT_NO_REF(dialog, dialog_action_area2,
				   "dialog_action_area2");
	GLADE_HOOKUP_OBJECT(dialog, cancelbutton1, "cancelbutton1");
	GLADE_HOOKUP_OBJECT(dialog, okbutton1, "okbutton1");

	elog_journ_wzrd_dialog = dialog;
	elog_journ_wzrd_name = entry_name;
	elog_journ_wzrd_enc = radio_aes;
	elog_journ_wzrd_path = file_path;
	gtk_widget_show_all(dialog);
	gtk_main();

	if (_new_wzrd_err)
		return NULL;

	elog_journ_load(elog_journ_current()->name);
	elog_journ_save();


	elog_sp_cat(&path, getenv("HOME"), _ELOG_CONFIG, "/journals.conf",
		    NULL);
	elog_journ_saveStates(path);
	free(path);


	return elog_journ_current()->name;
}
