/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * #This is a proposal for the journal config file
<journals>
	<how many>
		2
	</how many>
	<journal num=0>
		<name>	
			The journals namo
		</name>
		<settings>
			#this could be written by the file
			<confPath>
				/home/user/abc/journ/0
			</confPath>
		</settings>


	</journal num=1>
	<journal num=1>
		<name>
			The journals name
		</name>
		<settings>
			#this could be written by the file
			<confPath>
				/home/user/abc/journ/1
			</confPath>
		</settings>


	</journal num=1>
</journals>
 * 
 * 
 * */

/*NOte:
login.c is heavily tied into the workings of this.  And other parts use the names via current.  So changes here have to be well thought through.

If you change the journ_load function you'll have to make changes to a couple sections of login.c too. 

The main fix for this will probably be to make the set function equivalent to the load function, except it won't check for encryption keys, by removing path and encryption_method from settings.  This involves removing it at every use in the app!
alexus% grep "path" *.c | grep str | grep "elog_set" | grep -c ""
30
alexus% grep "encryption_method" *.c | grep "elog_set" | grep -c ""
18

As you can see, there's a lot of changes involved in that.
*/

#ifndef JOURNAL_H
#define JOURNAL_H


#include <stdlib.h>


struct elog_journ_set
{
	char *path;
	char *encryption;
};

struct elog_journ_state
{
	char *name;
	char *currentFile;
	unsigned char *key; //encryption key.
	struct elog_journ_set *settings;

};

struct elog_journ_state *elog_journ_state_new();
//Pre:  numElts is the number of data elements it needs to have
//Post:  Creates a new state

void elog_journ_state_free(struct elog_journ_state *state);
//Pre:
//Post:  Frees the state



int elog_journ_initialize(const char *fileName);
//Pre:  fileNAme is a file with journal setup
//Post:  Reads fileName and stores all the data needed.

void elog_journ_saveStates(const char *fileName);
//Pre:
//Post:  Saves states.

void elog_journ_save();
//Pre:  The application must be fully initialized
//Post:  gets current state info on all files for current journal.
	
int elog_journ_load(const char *journ);
//Pre:  journ is a name for an existing journal
//Post:  Loads up the new journal from file or saved state.
//       Returns 0 on success, 1 on failure

int elog_journ_load_no_last_file(const char *journ);
//Same as journ_load, but doesn't load the last file from it.

void elog_journ_new();
//Pre:
//Post:  Makes a new journal reguardless of current state.
//	Sets current state to said new item
//	Please, then use elog_journ_current

void elog_journ_fork(const char *name);
//Pre:  Must have a current state;
//Post:  Copies current state with new name.

struct elog_journ_state *elog_journ_current();
//Pre:  A current state exists
//Post:  Gives you access to the current state data.

int elog_journ_set(const char *path);
//Pre:  initialize has been called.
//Post:  if path was a path of a loaded journal, this will
//   be set as the current journal.

char **elog_journ_list();
//Pre:  initialize has been called.
//Post:  returns a null terminated list of names.
// DO NOT FREE THE STRINGS!

const char *elog_journ_path(const char *name);
//Pre:  name is a name of a journal
//Post:  Returns the path corresponding to name

int elog_journ_exists(const char *path);
//Pre:
//Post:  says if there's a journ for the path given.

const char *elog_journ_in_current(const char *path);
//PRe;  path is a valid c string
//Post:  Says NULL for:  path is in the current journ
//Otherwise gives you the journal to switch to.

#endif
