/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef LISTEN_H
#define LISTEN_H

/*  Why me?
Listen is a set of functions intended to allow other programs to talk
to the currently running one.  This allows a single instance
of the program to exist.

It will also allow IPC like Unix std Piping:
ls | ejourn

This will mean that you can pipe things into the running
program from the command line.

*/


/*Communique!
<mesg>
    <type>
         std-pipe
    </type>
    <txt>
         Whatever text you wanna send!

    </txt>
</mesg>
*/



#include "talk.h"
#include "threads.h"
#include "error.h"
#include "xml.h"
#include "simple.h"
#ifndef NO_GUI
#include "gui_al.h"
#include "undo.h"
#endif
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>



#define ELOG_LSN_MSG_SIZE 1024

#define ELOG_LSN_TYPE_COMMAND "SEND"
#define ELOG_LSN_TYPE_FETCH	"FETCH"
#define ELOG_LSN_TYPE_REPLY "REPLY"
#define ELOG_LSN_TYPE_EXPORT "EXPORT"


/* Why me?
 * I exist to abstract speaking between processes in conjunction with talk.h
 * I am the ears, talk is the mouth.
 * We call eath other.
 * Since I make references into the gui, I have two compile modes:
 * Normal and -DNO_GUI
 * With the NO_GUI option all of my abilities to communicate with the gui
 * are gone, this is for another process that has no gui to use. 
 * 
 * */


/* Hi...
 * The general pattern is this:
 * Call elog_lsn_initialize on process1 as a new thread.
 * In another process do a talk operation on the same file:
 * "/tmp/ejourn-$USER"
 * If you need data back for the talk operation, it will come back
 * on "/tmp/ejourn-$USER"."1"
 * 
 * */

void elog_lsn_initialize(const char *file);
//Pre:  Threads must be valid, otherwise listen stops.
//Post:  If threads exist a new thread is launched to listen.

void elog_lsn_process(const char *file, const char *mesg);
//Pre:  mesg must be of above format.
//Post:  Processes message

char *elog_lsn_listen(const char *file);
//Pre:
//Post:  Listens to file and returns full message it gets.
//Note:  This function will wait..


#endif
