#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "login.h"
#include "support.h"
#include "journal.h"
#include "prefix.h"
#include "gui_io.h"
#include "error.h"

int _lgn_type;
//^^will contain the current login type:
int _lgn_mode;

char *_lgn_content = NULL;
int _lgn_content_len = 0;

char *_lgn_current = NULL;

int _lgn_ok = 0;		//whether or not it's ok to let them login

GtkWidget *login_window;
void lgn_set_sensitive(gboolean b)
{
	gtk_widget_set_sensitive(lookup_widget(login_window, "textview1"),
				 b);
	gtk_widget_set_sensitive(lookup_widget(login_window, "label2"), b);
	gtk_widget_set_sensitive(lookup_widget(login_window, "entry2"), b);
	gtk_widget_set_sensitive(lookup_widget(login_window, "label3"), b);
	gtk_widget_set_sensitive(lookup_widget(login_window, "entry3"), b);

}

void login_check(gpointer user_data)
{
	if (!_lgn_ok)
		return;

	if (_lgn_type == 1 || _lgn_type == 3) {
		//We have to save the new text!
		GtkWidget *textview =
		    lookup_widget(login_window, "textview1");
		GtkTextBuffer *buffer =
		    gtk_text_view_get_buffer(GTK_TEXT_VIEW(textview));
		GtkTextIter start, end;
		gtk_text_buffer_get_start_iter(buffer, &start);
		gtk_text_buffer_get_end_iter(buffer, &end);

		char *content =
		    (char *) gtk_text_buffer_get_text(buffer, &start, &end,
						      TRUE);
		unsigned int len;
		unsigned char *cont =
		    elog_sp_toUnsignedChar(content, &len);

		encryptText(cont, len);

		char *path;
		elog_sp_cat(&path, elog_journ_path(_lgn_current),
			    "/intro.dry", NULL);
		struct elog_io_file *f =
		    elog_io_initialize(path, ELOG_IO_WRITE);
		elog_io_writeLine(f, cont, len);

		elog_io_close(f);
		free(path);
		free(cont);
	}
	elog_journ_current()->key = viewKey();

	if (_lgn_current)
		free(_lgn_current);
	if (_lgn_content_len)
		free(_lgn_content);
	_lgn_current = NULL;
	_lgn_content = NULL;
	_lgn_content_len = 0;


	int *status = user_data;
	*status = 0;
	gtk_main_quit();
}


gboolean lgn_on_login(GtkWidget * widget,
		      GdkEventKey * event, gpointer user_data)
{
	login_check(user_data);
	return FALSE;
}

gboolean on_entry2_type(GtkWidget * widget,
			GdkEventKey * event, gpointer user_data)
{
	GtkWidget *btn = lookup_widget(login_window, "okbutton1");

	if (_lgn_type == 2) {
		if (!_lgn_content_len)
			return FALSE;
		char *pass =
		    (char *) gtk_entry_get_text(GTK_ENTRY(widget));
		if (strlen(pass) <= 0)
			return FALSE;


		createKey(pass, 256);

		char *tmp_1 = malloc((sizeof *tmp_1) * (_lgn_content_len));
		memcpy(tmp_1, _lgn_content, _lgn_content_len);


		decryptText((unsigned char *) tmp_1, _lgn_content_len);



		tmp_1[_lgn_content_len - 1] = '\0';


		GtkWidget *textview =
		    lookup_widget(login_window, "textview1");
		GtkTextBuffer *buffer =
		    gtk_text_view_get_buffer(GTK_TEXT_VIEW(textview));
		if (g_utf8_validate(tmp_1, _lgn_content_len - 1, NULL) ==
		    TRUE) {
			gtk_text_buffer_set_text(buffer, tmp_1, -1);
			_lgn_ok = 1;
			gtk_widget_set_sensitive(btn, TRUE);
		} else {
			gtk_text_buffer_set_text(buffer,
						 "Enter the correct password please.",
						 -1);
			_lgn_ok = 0;
			gtk_widget_set_sensitive(btn, FALSE);
		}

		free(tmp_1);

	} else if (_lgn_type == 1 || _lgn_type == 3) {
		GtkWidget *entry1;
		GtkWidget *entry2;
		entry1 = lookup_widget(login_window, "entry2");
		entry2 = lookup_widget(login_window, "entry3");
		char *pass1, *pass2;
		pass1 = (char *) gtk_entry_get_text(GTK_ENTRY(entry1));
		pass2 = (char *) gtk_entry_get_text(GTK_ENTRY(entry2));
		if (pass2 && pass1) {
			if (strcmp(pass1, pass2) == 0 && pass1[0]) {
				_lgn_ok = 1;
				gtk_widget_set_sensitive(btn, TRUE);
				createKey(pass1, 256);
			} else {
				_lgn_ok = 0;
				gtk_widget_set_sensitive(btn, FALSE);
			}
		} else {
			_lgn_ok = 0;
			gtk_widget_set_sensitive(btn, FALSE);
		}


	}

	return FALSE;
}


void on_entry2_activate(GtkEntry * entry, gpointer user_data)
{
	login_check(user_data);
}

gboolean lgn_on_cancel(GtkWidget * widget,
		       GdkEventKey * event, gpointer user_data)
{
	if (_lgn_content_len)
		free(_lgn_content);
	if (_lgn_current)
		free(_lgn_current);

	_lgn_current = NULL;
	_lgn_content = NULL;
	_lgn_content_len = 0;
	int *status = user_data;
	*status = 1;
	gtk_main_quit();
	return FALSE;
}

void lgn_on_cancelbutton1_activate(GtkButton * button, gpointer user_data)
{
	if (_lgn_content_len)
		free(_lgn_content);
	if (_lgn_current)
		free(_lgn_current);
	_lgn_current = NULL;
	_lgn_content = NULL;
	_lgn_content_len = 0;

	int *status = user_data;
	*status = 1;
	gtk_main_quit();
}

gboolean on_window_login_close(GtkWidget * widget,
			       GdkEvent * event, gpointer user_data)
{
	if (_lgn_current)
		free(_lgn_current);
	if (_lgn_content_len)
		free(_lgn_content);
	_lgn_current = NULL;
	_lgn_content = NULL;
	_lgn_content_len = 0;
	gtk_widget_destroy(widget);
	int *status = user_data;
	*status = 1;
	gtk_main_quit();
	return TRUE;
}

gboolean lgn_on_select_journ(GtkTreeView * treeview,
			     gboolean arg1, gpointer user_data)
{
	/* Resetting everything */
	_lgn_ok = 0;
	GtkWidget *btn = lookup_widget(login_window, "okbutton1");
	GtkWidget *entry1, *entry2;
	entry1 = lookup_widget(login_window, "entry2");
	gtk_entry_set_text(GTK_ENTRY(entry1), "");
	entry2 = lookup_widget(login_window, "entry3");
	gtk_entry_set_text(GTK_ENTRY(entry2), "");

	if (_lgn_current)
		free(_lgn_current);
	if (_lgn_content_len)
		free(_lgn_content);
	_lgn_content_len = 0;
	_lgn_content = NULL;
	/*Done resetting */

	gtk_widget_set_sensitive(btn, FALSE);
	char *path;
	char *name;
	GtkTreeSelection *selection;
	GtkTreeModel *model = gtk_tree_view_get_model(treeview);
	GtkTreeIter iter;

	/* This will only work in single or browse selection mode! */

	selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(treeview));
	if (gtk_tree_selection_get_selected(selection, &model, &iter))
		gtk_tree_model_get(model, &iter, 0, &name, -1);

	_lgn_current = name;



	elog_sp_cat(&path, elog_journ_path(name), "/intro.dry", NULL);
	struct elog_io_file *f = elog_io_initialize(path, ELOG_IO_READ);
	int len;
	char *content;
	if (f) {
		_lgn_content = content = elog_io_readRestofFile(f, &len);
		_lgn_content_len = len;
		elog_io_close(f);
	} else {
		_lgn_content_len = len = 0;
	}

	GtkWidget *textview = lookup_widget(login_window, "textview1");
	GtkTextBuffer *buffer =
	    gtk_text_view_get_buffer(GTK_TEXT_VIEW(textview));

	if (_lgn_mode == ELOG_LGN_MODE_LOGIN) {
		elog_journ_set(elog_journ_path(name));
		elog_set_set_str("path",
				 elog_journ_current()->settings->path);
		elog_set_set_str("encryption_method",
				 elog_journ_current()->settings->
				 encryption);
	}

	if (len > 0) {
		if (g_utf8_validate(content, len - 1, NULL) == TRUE) {
			if (_lgn_mode == ELOG_LGN_MODE_LOGIN) {
				lgn_set_sensitive(FALSE);
				gtk_widget_hide(lookup_widget
						(login_window, "label3"));
				gtk_widget_hide(lookup_widget
						(login_window, "entry3"));
				gtk_widget_hide(lookup_widget
						(login_window, "label2"));
				gtk_widget_hide(lookup_widget
						(login_window, "entry2"));
				gtk_text_buffer_set_text(buffer,
							 "Just Click Login!",
							 -1);
				gtk_text_view_set_editable(GTK_TEXT_VIEW
							   (textview),
							   FALSE);
				_lgn_type = 0;
				_lgn_ok = 1;
				gtk_widget_set_sensitive(btn, TRUE);
				gtk_widget_grab_focus(btn);
				gtk_widget_grab_focus(btn);
			} else {
				lgn_set_sensitive(TRUE);
				gtk_widget_show(lookup_widget
						(login_window, "label3"));
				gtk_widget_show(lookup_widget
						(login_window, "entry3"));
				gtk_widget_show(lookup_widget
						(login_window, "label2"));
				gtk_widget_show(lookup_widget
						(login_window, "entry2"));
				gtk_text_buffer_set_text(buffer, content,
							 -1);
				gtk_text_view_set_editable(GTK_TEXT_VIEW
							   (textview),
							   TRUE);
				_lgn_type = 1;
				gtk_widget_grab_focus(textview);
				gtk_widget_grab_focus(textview);
			}
		} else		//if utf no validate
		{

			lgn_set_sensitive(TRUE);
			gtk_widget_hide(lookup_widget
					(login_window, "label3"));
			gtk_widget_hide(lookup_widget
					(login_window, "entry3"));
			gtk_widget_show(lookup_widget
					(login_window, "label2"));
			gtk_widget_show(lookup_widget
					(login_window, "entry2"));
			gtk_text_view_set_editable(GTK_TEXT_VIEW(textview),
						   FALSE);
			gtk_text_buffer_set_text(buffer,
						 "Enter the correct password please.",
						 -1);
			_lgn_type = 2;
			gtk_widget_grab_focus(lookup_widget
					      (login_window, "entry2"));
			gtk_widget_grab_focus(lookup_widget
					      (login_window, "entry2"));
		}
	} else {
		if (_lgn_mode == ELOG_LGN_MODE_LOGIN) {
			lgn_set_sensitive(FALSE);
			gtk_widget_hide(lookup_widget
					(login_window, "label3"));
			gtk_widget_hide(lookup_widget
					(login_window, "entry3"));
			gtk_widget_hide(lookup_widget
					(login_window, "label2"));
			gtk_widget_hide(lookup_widget
					(login_window, "entry2"));
			gtk_text_view_set_editable(GTK_TEXT_VIEW(textview),
						   FALSE);
			gtk_text_buffer_set_text(buffer,
						 "Just Click Login!", -1);
			_lgn_type = 0;
			_lgn_ok = 1;
			gtk_widget_set_sensitive(btn, TRUE);
			gtk_widget_grab_focus(btn);
			gtk_widget_grab_focus(btn);
		} else if (_lgn_mode == ELOG_LGN_MODE_RECOVER) {
			lgn_set_sensitive(TRUE);
			gtk_widget_show(lookup_widget
					(login_window, "label3"));
			gtk_widget_show(lookup_widget
					(login_window, "entry3"));
			gtk_widget_show(lookup_widget
					(login_window, "label2"));
			gtk_widget_show(lookup_widget
					(login_window, "entry2"));
			gtk_text_buffer_set_text(buffer,
						 "Recovery Mode:\n   Please Enter a personal message here, and enter the correct password for this already setup journal.",
						 -1);
			gtk_text_view_set_editable(GTK_TEXT_VIEW(textview),
						   TRUE);
			_lgn_type = 3;
			_lgn_ok = 0;
			gtk_widget_grab_focus(textview);
			gtk_widget_grab_focus(textview);
		} else {
			lgn_set_sensitive(TRUE);
			gtk_widget_show(lookup_widget
					(login_window, "label3"));
			gtk_widget_show(lookup_widget
					(login_window, "entry3"));
			gtk_widget_show(lookup_widget
					(login_window, "label2"));
			gtk_widget_show(lookup_widget
					(login_window, "entry2"));
			gtk_text_buffer_set_text(buffer,
						 "Please enter your own personalized message here!",
						 -1);
			gtk_text_view_set_editable(GTK_TEXT_VIEW(textview),
						   TRUE);
			_lgn_type = 1;
			gtk_widget_grab_focus(textview);
			gtk_widget_grab_focus(textview);
		}
	}


	free(path);

	return FALSE;
}



#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

#define GLADE_HOOKUP_OBJECT_NO_REF(component,widget,name) \
  g_object_set_data (G_OBJECT (component), name, widget)


int create_login_window(int mode)
{
	int STATUS;

	_lgn_mode = mode;
	GtkWidget *dialog_vbox1;
	GtkWidget *vbox1;
	GtkWidget *label1;
	GtkWidget *scrolledwindow2;
	GtkWidget *journals_lst;
	GtkWidget *scrolledwindow1;
	GtkWidget *textview1;
	GtkWidget *hseparator1;
	GtkWidget *hbox2;
	GtkWidget *label2;
	GtkWidget *entry2;
	GtkWidget *hbox4;
	GtkWidget *label3;
	GtkWidget *entry3;
	GtkWidget *dialog_action_area1;
	GtkWidget *cancelbutton1;
	GtkWidget *okbutton1;
	GtkTooltips *tooltips;
	GtkWidget *help;

	tooltips = gtk_tooltips_new();

	login_window = gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(login_window), "eJourn::Login");
	gtk_window_set_type_hint(GTK_WINDOW(login_window),
				 GDK_WINDOW_TYPE_HINT_DIALOG);

	GError *err;
	char *icon;
	elog_sp_cat(&icon, DATADIR, "/ejourn/img/ejourn.png", NULL);

	if (gtk_window_set_icon_from_file
	    (GTK_WINDOW(login_window), icon, &err)
	    == FALSE)
		elog_err_print_console
		    ("Failed to load login window icon\n");


	free(icon);

	dialog_vbox1 = GTK_DIALOG(login_window)->vbox;
	gtk_widget_show(dialog_vbox1);

	vbox1 = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox1);
	gtk_box_pack_start(GTK_BOX(dialog_vbox1), vbox1, TRUE, TRUE, 0);

	label1 = gtk_label_new("Please Login:");
	gtk_widget_show(label1);
	gtk_box_pack_start(GTK_BOX(vbox1), label1, FALSE, FALSE, 0);

	scrolledwindow2 = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW
				       (scrolledwindow2), GTK_POLICY_NEVER,
				       GTK_POLICY_NEVER);
	gtk_widget_show(scrolledwindow2);
	gtk_box_pack_start(GTK_BOX(vbox1), scrolledwindow2, TRUE, TRUE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(scrolledwindow2), 11);
	gtk_scrolled_window_set_shadow_type(GTK_SCROLLED_WINDOW
					    (scrolledwindow2),
					    GTK_SHADOW_IN);

	journals_lst = gtk_tree_view_new();
	gtk_widget_show(journals_lst);
	gtk_container_add(GTK_CONTAINER(scrolledwindow2), journals_lst);
	gtk_tooltips_set_tip(tooltips, journals_lst,
			     "Select the journal you'd like to login to here.",
			     NULL);

	scrolledwindow1 = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW
				       (scrolledwindow1),
				       GTK_POLICY_AUTOMATIC,
				       GTK_POLICY_AUTOMATIC);
	gtk_widget_show(scrolledwindow1);
	gtk_box_pack_start(GTK_BOX(vbox1), scrolledwindow1, TRUE, TRUE, 0);
	gtk_scrolled_window_set_shadow_type(GTK_SCROLLED_WINDOW
					    (scrolledwindow1),
					    GTK_SHADOW_IN);


	textview1 = gtk_text_view_new();
	gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(textview1),
				    GTK_WRAP_WORD);
	gtk_widget_show(textview1);
	gtk_container_add(GTK_CONTAINER(scrolledwindow1), textview1);
	gtk_tooltips_set_tip(tooltips, textview1,
			     "Login text.  Please type your login text here; this is the text you will see upon sucessful entry of your password on later logins.",
			     NULL);
	gtk_text_view_set_editable(GTK_TEXT_VIEW(textview1), FALSE);



	hseparator1 = gtk_hseparator_new();
	gtk_widget_show(hseparator1);
	gtk_box_pack_start(GTK_BOX(vbox1), hseparator1, TRUE, TRUE, 0);

	hbox2 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox2);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox2, TRUE, TRUE, 0);

	label2 = gtk_label_new("Enter Password:  ");
	gtk_widget_show(label2);
	gtk_box_pack_start(GTK_BOX(hbox2), label2, FALSE, FALSE, 0);
	gtk_misc_set_padding(GTK_MISC(label2), 7, 0);

	entry2 = gtk_entry_new();
	gtk_widget_show(entry2);
	gtk_box_pack_start(GTK_BOX(hbox2), entry2, TRUE, TRUE, 0);
	gtk_tooltips_set_tip(tooltips, entry2, "Enter your password here.",
			     NULL);

	hbox4 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox4);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox4, TRUE, TRUE, 0);

	label3 = gtk_label_new("ReEnter Password:  ");
	//gtk_widget_show (label3);
	gtk_box_pack_start(GTK_BOX(hbox4), label3, FALSE, FALSE, 0);

	entry3 = gtk_entry_new();
	gtk_entry_set_visibility(GTK_ENTRY(entry3), FALSE);
	gtk_entry_set_visibility(GTK_ENTRY(entry2), FALSE);
	//gtk_widget_show (entry3);
	gtk_box_pack_start(GTK_BOX(hbox4), entry3, TRUE, TRUE, 0);
	gtk_tooltips_set_tip(tooltips, entry3,
			     "Reenter your password here.", NULL);

	dialog_action_area1 = GTK_DIALOG(login_window)->action_area;
	gtk_widget_show(dialog_action_area1);
	gtk_button_box_set_layout(GTK_BUTTON_BOX(dialog_action_area1),
				  GTK_BUTTONBOX_END);

	help = gtk_button_new_from_stock("gtk-help");
	gtk_widget_show(help);
	gtk_dialog_add_action_widget(GTK_DIALOG(login_window), help,
				     GTK_RESPONSE_HELP);
	GTK_WIDGET_SET_FLAGS(help, GTK_CAN_DEFAULT);


	cancelbutton1 = gtk_button_new_from_stock("gtk-cancel");
	gtk_widget_show(cancelbutton1);
	gtk_dialog_add_action_widget(GTK_DIALOG(login_window),
				     cancelbutton1, GTK_RESPONSE_CANCEL);
	GTK_WIDGET_SET_FLAGS(cancelbutton1, GTK_CAN_DEFAULT);

	//  okbutton1 = gtk_button_new_from_stock ("gtk-ok");
	okbutton1 = gtk_button_new_with_mnemonic("Login");
	gtk_widget_show(okbutton1);
	gtk_dialog_add_action_widget(GTK_DIALOG(login_window), okbutton1,
				     GTK_RESPONSE_OK);
	GTK_WIDGET_SET_FLAGS(okbutton1, GTK_CAN_DEFAULT);

	g_signal_connect((gpointer) entry2, "activate",
			 G_CALLBACK(on_entry2_activate), &STATUS);
	g_signal_connect((gpointer) entry2, "key-release-event",
			 G_CALLBACK(on_entry2_type), &STATUS);
	g_signal_connect((gpointer) entry3, "key-release-event",
			 G_CALLBACK(on_entry2_type), &STATUS);
	g_signal_connect((gpointer) entry3, "activate",
			 G_CALLBACK(on_entry2_activate), &STATUS);
	g_signal_connect((gpointer) cancelbutton1, "activate",
			 G_CALLBACK(lgn_on_cancelbutton1_activate),
			 &STATUS);
	g_signal_connect((gpointer) cancelbutton1, "button-press-event",
			 G_CALLBACK(lgn_on_cancel), &STATUS);

	g_signal_connect((gpointer) help, "activate",
			 G_CALLBACK(elog_gui_io_open_manual), NULL);
	g_signal_connect((gpointer) help, "button-press-event",
			 G_CALLBACK(elog_gui_io_open_manual), NULL);



	g_signal_connect((gpointer) okbutton1, "key-press-event",
			 G_CALLBACK(lgn_on_login), &STATUS);
	g_signal_connect((gpointer) okbutton1, "button-press-event",
			 G_CALLBACK(lgn_on_login), &STATUS);

	g_signal_connect((gpointer) login_window, "delete-event",
			 G_CALLBACK(on_window_login_close), &STATUS);

	g_signal_connect((gpointer) journals_lst, "cursor-changed",
			 G_CALLBACK(lgn_on_select_journ), NULL);


	/* Store pointers to all widgets, for use by lookup_widget(). */
	GLADE_HOOKUP_OBJECT_NO_REF(login_window, login_window,
				   "login_window");
	GLADE_HOOKUP_OBJECT_NO_REF(login_window, dialog_vbox1,
				   "dialog_vbox1");
	//  GLADE_HOOKUP_OBJECT (login_window, vbox1, "vbox1");
	GLADE_HOOKUP_OBJECT(login_window, label1, "label1");
	//  GLADE_HOOKUP_OBJECT (login_window, scrolledwindow2, "scrolledwindow2");
	//GLADE_HOOKUP_OBJECT (login_window, journals_lst, "journals_lst");
	//  GLADE_HOOKUP_OBJECT (login_window, scrolledwindow1, "scrolledwindow1");
	GLADE_HOOKUP_OBJECT(login_window, textview1, "textview1");
	//  GLADE_HOOKUP_OBJECT (login_window, hseparator1, "hseparator1");
	//  GLADE_HOOKUP_OBJECT (login_window, hbox2, "hbox2");
	GLADE_HOOKUP_OBJECT(login_window, label2, "label2");
	GLADE_HOOKUP_OBJECT(login_window, entry2, "entry2");
	//  GLADE_HOOKUP_OBJECT (login_window, hbox4, "hbox4");
	GLADE_HOOKUP_OBJECT(login_window, label3, "label3");
	GLADE_HOOKUP_OBJECT(login_window, entry3, "entry3");
	//  GLADE_HOOKUP_OBJECT_NO_REF (login_window, dialog_action_area1, "dialog_action_area1");
	//  GLADE_HOOKUP_OBJECT (login_window, cancelbutton1, "cancelbutton1");
	GLADE_HOOKUP_OBJECT(login_window, okbutton1, "okbutton1");
	//  GLADE_HOOKUP_OBJECT_NO_REF (login_window, tooltips, "tooltips");








	//showing before we add, this is slower
	//but otherwise I'd have to manually resize the window, or somehow
	//else consistently control its size.  At least, in some gtk themes.

	/*Add in list of journals */
	GtkCellRenderer *renderer;
	GtkTreeViewColumn *col;


	col = gtk_tree_view_column_new();
	if (ELOG_LGN_MODE_LOGIN == mode)
		gtk_tree_view_column_set_title(col,
					       "Select a journal to login to:");
	else if (ELOG_LGN_MODE_SWITCH == mode)
		gtk_tree_view_column_set_title(col, "Please login to:");

	gtk_tree_view_column_set_reorderable(col, FALSE);

	gtk_tree_view_append_column(GTK_TREE_VIEW(journals_lst), col);

	renderer = gtk_cell_renderer_text_new();

	gtk_tree_view_column_pack_start(col, renderer, TRUE);

	gtk_tree_view_column_add_attribute(col, renderer, "text", 0);

	GtkWidget *fileListTree =
	    (GtkWidget *) gtk_list_store_new(1, G_TYPE_STRING);
	gtk_tree_view_set_model(GTK_TREE_VIEW(journals_lst),
				GTK_TREE_MODEL(fileListTree));

	gtk_widget_show(login_window);

	GtkTreeIter iter;

	if (mode == ELOG_LGN_MODE_LOGIN) {
		char *last_journ = elog_set_get_str("path");
		if (last_journ)
			elog_journ_set(last_journ);

		char **list = elog_journ_list();
		int c;
		for (c = 0; list[c] != NULL; ++c) {
			gtk_list_store_append(GTK_LIST_STORE(fileListTree),
					      &iter);

			gtk_list_store_set(GTK_LIST_STORE(fileListTree),
					   &iter, 0, list[c], -1);
			if (strcmp(list[c], elog_journ_current()->name) ==
			    0) {
				char *n = elog_sp_shortToString(c);
				GtkTreePath *path =
				    gtk_tree_path_new_from_string(n);
				gtk_tree_view_set_cursor(GTK_TREE_VIEW
							 (journals_lst),
							 path, NULL,
							 FALSE);
				free(n);
			}
		}
		free(list);
	} else			//if (mode == ELOG_LGN_MODE_SWITCH)
	{
		gtk_list_store_append(GTK_LIST_STORE(fileListTree), &iter);
		gtk_list_store_set(GTK_LIST_STORE(fileListTree), &iter, 0,
				   elog_journ_current()->name, -1);
		char n[] = "0";
		GtkTreePath *path = gtk_tree_path_new_from_string(n);
		gtk_tree_view_set_cursor(GTK_TREE_VIEW(journals_lst), path,
					 NULL, FALSE);

	}

	/*done with journal listing */



	lgn_on_select_journ(GTK_TREE_VIEW(journals_lst), FALSE, NULL);

	gtk_main();


	gtk_widget_destroy(login_window);


	return STATUS;
}


int elog_lgn_is_protected(const char *fileName)
{
	/*  struct elog_io_file *f = elog_io_initialize(fileName, ELOG_IO_READ);

	   int ret=0;
	   if (
	   ret = 1;
	   free(content);

	   elog_io_close(f);
	   return ret; */
	return 0;		//GUTTED!
}
