#ifndef LOGIN_H
#define LOGIN_H

#include <gtk/gtk.h>
#include "support.h"


#define ELOG_LGN_MODE_LOGIN 0
#define ELOG_LGN_MODE_SWITCH 1
//Only call with ELOG_LGN_MODE_SWITCH if you have encryption set
//Otherwise do not, absolutely do not, bother the user!
#define ELOG_LGN_MODE_RECOVER 2

gboolean    on_entry2_type      (GtkWidget *widget,
                                            GdkEventKey *event,
                                            gpointer user_data);

void
on_entry2_activate                     (GtkEntry        *entry,
                                        gpointer         user_data);

gboolean    lgn_on_login      (GtkWidget *widget,
                                            GdkEventKey *event,
                                            gpointer user_data);

gboolean    lgn_on_cancel      (GtkWidget *widget,
                                            GdkEventKey *event,
                                            gpointer user_data);

void
lgn_on_cancelbutton1_activate              (GtkButton       *button,
                                        gpointer         user_data);


gboolean    lgn_on_select_journ      (GtkTreeView *treeview,
				gboolean arg1,
				gpointer user_data);




int
create_login_window (int mode);
//Pre:
//Post:  Launch a login window for the user.
//       Returns 0 on success and 1 or more if the user cancels

gboolean    on_window_login_close      (GtkWidget *widget,
                                            GdkEvent *event,
                                            gpointer user_data);


int elog_lgn_is_protected(const char *fileName);
//Pre:  fileName is a valid login file:  $path/intro.dry
//Post:  returns 0 if it is not protected, 1 if it is
//Note:  Protected means encrypted

#endif
